#!/usr/bin/env python
# Copyright (c) 2014
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
#     The above copyright notice and this permission notice shall be
#     included in all copies or substantial portions of the Software.
#
#     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
#     EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
#     OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
#     NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
#     HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
#     WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
#     FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
#     OTHER DEALINGS IN THE SOFTWARE.

import os
import errno
import sys
import platform

class EnvSetting:
    def __init__(self):
        self.cert_password = "changeme"
        self.secondary_node = False
        self.primary_node = False
        self.upgrade = False
        self._LB_FQDN = ""
        self._lb_cert_folder= ""
        self._sso_server_sign = ""
        self.root_cert = ""
        if not os.environ.has_key('VMWARE_JAVA_HOME'):
           if os.environ.has_key('JAVA_HOME'):
              os.environ['VMWARE_JAVA_HOME'] = os.environ['JAVA_HOME']
           else:
              print """
              ERROR: VMWARE_JAVA_HOME or JAVA_HOME not set in environment.
              Please set to location of Java runtime and retry.
              """
              sys.exit(1)

        EXT = ""
        if platform.system() == 'Windows':
           EXT = ".exe"

        self.JAVA = "%s/bin/java%s" % (os.environ['VMWARE_JAVA_HOME'], EXT)
        if platform.system() == 'Windows':
            if os.environ.has_key('VMWARE_CIS_HOME'):
                self._OPEN_SSL_PATH = os.environ['VMWARE_CIS_HOME'] + "\\openssl"
                self._CER_TOOL_PATH = os.environ['VMWARE_CIS_HOME'] + "\\vmcad"
                self.service_control_exe = os.environ['VMWARE_CIS_HOME'] + "\\bin\\service-control.bat"
                self._VMWARE_DATA_DIR = os.environ['VMWARE_DATA_DIR']
                self._VMWARE_CFG_DIR = os.environ['VMWARE_CFG_DIR']
                self._VMWARE_RUNTIME_DATA_DIR = os.environ['VMWARE_RUNTIME_DATA_DIR']
                self.rootcertPath =self. _VMWARE_CFG_DIR + "\\sso\\keys\\ssoServerRoot.crt"
                self.certPath = self._VMWARE_CFG_DIR + "\\sso\\keys\\ssoServerSign.crt"
                self.privateKeyPath =self. _VMWARE_CFG_DIR + "\\sso\\keys\\ssoServerSign.key"
                self.logDir = os.environ['VMWARE_LOG_DIR']
            else:
                print """ ERROR: Unable to find the correct environment variables """
                sys.exit(1)

        if platform.system() == 'Windows':
            self.openssl_exe = self._OPEN_SSL_PATH + "\\openssl.exe"
            self.certool_exe = self._CER_TOOL_PATH + "\\certool.exe"
            self.certool_cfg = self._CER_TOOL_PATH + "\\certool.cfg"
            self.srcfile = self._VMWARE_DATA_DIR + "\\vmca\\root.cer"
            self.ha_folder = "c:\\ha"
            self.dstfile = self.ha_folder + "\\root.cer"
            self.lb_key_file = self.ha_folder + "\\lb.key"
            self.lb_key_pub_file = self.ha_folder + "\\lb.pub"
            self.lb_crt_file = self.ha_folder + "\\lb.crt"
            self.lb_p12_file = self.ha_folder + "\\lb.p12"
            self.lb_rsa_key = self.ha_folder + "\\lb_rsa.key"
            self.hostname_file = self._VMWARE_CFG_DIR + "\\sso\\hostname.txt"
            self.server_xml_file = self._VMWARE_RUNTIME_DATA_DIR + "\\VMwareSTSService\\conf\\server.xml"
            self.vmdir_cert_file = self._VMWARE_CFG_DIR + "\\vmdird\\vmdircert.pem"
            self.vmdir_key_file =  self._VMWARE_CFG_DIR + "\\vmdird\\vmdirkey.pem"
            self.vmdirServicename = "VMWareDirectoryService"
            self.vmstsServicename = "VMwareSTS"
            self.vmidmServicename = "VMwareIdentityMgmtService"
            self.vcenterdir = os.environ['VMWARE_CIS_HOME']
            self.CLASSPATH =   self.vcenterdir + "\\VMware Identity Services\*;" + self.vcenterdir + "\\vmware-sso\\commonlib\\*;."
            self.logdir = "-Dvmware.log.dir="+ self.logDir + "\\sso\\"
            self.vmdir = os.environ['VMWARE_CIS_HOME'] + "\\vmafdd\\dir-cli.exe"
            if not os.environ.has_key('OPENSSL_CONF'):
                os.environ['OPENSSL_CONF'] = os.path.join(self._OPEN_SSL_PATH,"openssl.cnf")

        else:
            self.openssl_exe = "openssl"
            self.certool_exe = "/usr/lib/vmware-vmca/bin/certool"
            self.service_control_exe = "/bin/service-control"
            self.certool_cfg = "/usr/lib/vmware-vmca/share/config/certool.cfg"
            self.srcfile = "/var/lib/vmware/vmca/root.cer"
            self.ha_folder = "/ha"
            self.dstfile = self.ha_folder + "/root.cer"
            self.lb_key_file = self.ha_folder + "/lb.key"
            self.lb_key_pub_file = self.ha_folder + "/lb.pub"
            self.lb_crt_file = self.ha_folder + "/lb.crt"
            self.lb_p12_file = self.ha_folder + "/lb.p12"
            self.lb_rsa_key = self.ha_folder + "/lb_rsa.key"
            self.hostname_file = "/etc/vmware-sso/hostname.txt"
            self.server_xml_file = "/usr/lib/vmware-sso/vmware-sts/conf/server.xml"
            self.vmdir_cert_file = "/usr/lib/vmware-vmdir/share/config/vmdircert.pem"
            self.vmdir_key_file =  "/usr/lib/vmware-vmdir/share/config/vmdirkey.pem"
            self.vmdirServicename = "vmdird"
            self.vmstsServicename = "vmware-stsd"
            self.vmidmServicename = "vmware-sts-idmd"
            self.CLASSPATH =  "/opt/vmware/lib64/*:/usr/lib/vmware-sso/commonlib/*:.:*"
            self.logdir = "-Dvmware.log.dir=/var/log/vmware/sso/"
            self.rootcertPath = "/etc/vmware-sso/keys/ssoserverRoot.crt"
            self.certPath = "/etc/vmware-sso/keys/ssoserverSign.crt"
            self.privateKeyPath = "/etc/vmware-sso/keys/ssoserverSign.key"
            self.vmdir = "/usr/lib/vmware-vmafd/bin/dir-cli"
        print """Initialization complete"""