/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.awt.EmbeddedFrame;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;

class PluginPopupHelper
implements ChangeListener {
    private EmbeddedFrame win;
    private Point origWinLocation;
    private Timer timer;

    PluginPopupHelper() {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!(changeEvent.getSource() instanceof MenuSelectionManager)) {
            return;
        }
        MenuElement[] menuElementArray = ((MenuSelectionManager)changeEvent.getSource()).getSelectedPath();
        if (menuElementArray.length == 0) {
            this.stopPolling();
        } else {
            Component component = this.getMenuOwnerComponent(menuElementArray);
            if (component != null) {
                this.startPolling((EmbeddedFrame)component);
            }
        }
    }

    private Component getMenuOwnerComponent(MenuElement[] menuElementArray) {
        for (int i = 0; i < menuElementArray.length; ++i) {
            Component component = this.getMenuOwnerComponent(menuElementArray[i]);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    private Component getMenuOwnerComponent(MenuElement menuElement) {
        Window window;
        Component component = menuElement.getComponent();
        if (!(component instanceof JPopupMenu)) {
            return null;
        }
        Component component2 = ((JPopupMenu)component).getInvoker();
        if (component2 != null && (window = SwingUtilities.getWindowAncestor(component2)) instanceof EmbeddedFrame) {
            return window;
        }
        return null;
    }

    private void windowMoved(Component component) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(component), new UngrabEvent(component));
    }

    private void startPolling(EmbeddedFrame embeddedFrame) {
        if (this.win != null) {
            return;
        }
        this.win = embeddedFrame;
        if (this.win != null) {
            this.origWinLocation = this.win.getLocationOnScreen();
            if (this.timer == null) {
                this.timer = new Timer(20, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (PluginPopupHelper.this.win != null && !PluginPopupHelper.this.win.getLocationOnScreen().equals(PluginPopupHelper.this.origWinLocation)) {
                            PluginPopupHelper.this.windowMoved(PluginPopupHelper.this.win);
                            PluginPopupHelper.this.timer.stop();
                        }
                    }
                });
            }
            this.timer.start();
        }
    }

    private void stopPolling() {
        if (this.win != null) {
            this.timer.stop();
            this.win = null;
        }
    }
}

