/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.validator.common;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.util.ValidatorUtils;

public class CommonValidatorUtil {
    public static final int USERNAME_MIN_LENGTH = 3;
    public static final int USERNAME_MAX_LENGTH = 24;
    public static final String USERNAME_VALID_REGEXP = "^[A-Za-z0-9-_]{3,24}$";
    public static final int PASSWORD_MIN_LENGTH = 3;
    public static final int PASSWORD_MAX_LENGTH = 24;
    public static final String FIELD_TEST_NULL = "NULL";
    public static final String FIELD_TEST_NOTNULL = "NOTNULL";
    public static final String FIELD_TEST_EQUAL = "EQUAL";
    private static Class stringClass = new String().getClass();

    public static boolean validateRequired(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return !GenericValidator.isBlankOrNull((String)value);
    }

    public static boolean validateEmail(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isEmail((String)value);
    }

    public static boolean validatePrincipal(Object bean, Field field) {
        boolean valid = false;
        String userName = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (userName != null && GenericValidator.matchRegexp((String)userName, (String)USERNAME_VALID_REGEXP)) {
            valid = true;
        }
        return valid;
    }

    public static boolean validatePassword(Object bean, Field field) {
        boolean valid = false;
        String pwd = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (pwd != null && GenericValidator.minLength((String)pwd, (int)3) && GenericValidator.maxLength((String)pwd, (int)24)) {
            valid = true;
        }
        return valid;
    }

    public static boolean validatePasswordVerification(Object bean, Field field) {
        boolean valid = false;
        String pwdv = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String pwd = ValidatorUtils.getValueAsString((Object)bean, (String)field.getArg(1).getKey());
        if (pwd != null && pwdv != null && pwdv.compareTo(pwd) == 0) {
            valid = true;
        }
        return valid;
    }

    public static boolean validateRequiredIf(Object bean, Field field, Validator validator) {
        Object form = validator.getParameterValue("java.lang.Object");
        String value = null;
        boolean required = false;
        value = CommonValidatorUtil.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        int i = 0;
        String fieldJoin = "AND";
        if (!GenericValidator.isBlankOrNull((String)field.getVarValue("field-join"))) {
            fieldJoin = field.getVarValue("field-join");
        }
        if (fieldJoin.equalsIgnoreCase("AND")) {
            required = true;
        }
        while (!GenericValidator.isBlankOrNull((String)field.getVarValue("field[" + i + "]"))) {
            String key;
            String dependProp = field.getVarValue("field[" + i + "]");
            String dependTest = field.getVarValue("field-test[" + i + "]");
            String dependTestValue = field.getVarValue("field-value[" + i + "]");
            String dependIndexed = field.getVarValue("field-indexed[" + i + "]");
            if (dependIndexed == null) {
                dependIndexed = "false";
            }
            String dependVal = null;
            boolean this_required = false;
            if (field.isIndexed() && dependIndexed.equalsIgnoreCase("true") && (key = field.getKey()).indexOf("[") > -1 && key.indexOf("]") > -1) {
                String ind = key.substring(0, key.indexOf(".") + 1);
                dependProp = ind + dependProp;
            }
            dependVal = ValidatorUtils.getValueAsString((Object)form, (String)dependProp);
            if (dependTest.equals(FIELD_TEST_NULL)) {
                this_required = dependVal == null || dependVal.length() <= 0;
            }
            if (dependTest.equals(FIELD_TEST_NOTNULL)) {
                this_required = dependVal != null && dependVal.length() > 0;
            }
            if (dependTest.equals(FIELD_TEST_EQUAL)) {
                this_required = dependTestValue.equalsIgnoreCase(dependVal);
            }
            required = fieldJoin.equalsIgnoreCase("AND") ? required && this_required : required || this_required;
            ++i;
        }
        if (required) {
            return value != null && value.length() > 0;
        }
        return true;
    }

    private static boolean isString(Object o) {
        if (o == null) {
            return true;
        }
        return stringClass.isInstance(o);
    }
}

