/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hyperic.util.math.MathUtil;

class WriterHandler {
    private boolean rolledBack = false;
    private boolean cleanedUp = false;
    private boolean wrote = false;

    WriterHandler() {
    }

    public boolean hasWritten() {
        return this.wrote;
    }

    public void cleanup() {
        if (this.cleanedUp) {
            throw new IllegalStateException("Cleanup called twice");
        }
        if (!this.wrote) {
            throw new IllegalStateException("Cleanup called when not written");
        }
        this.cleanedUp = true;
    }

    public void rollback() throws IOException {
        if (this.rolledBack) {
            throw new IllegalStateException("Rollback called twice");
        }
        if (!this.wrote) {
            throw new IllegalStateException("Rollback called when not written");
        }
        if (this.cleanedUp) {
            throw new IllegalStateException("Rolled back after cleaning up");
        }
        this.rolledBack = true;
    }

    public void write() throws IOException {
        if (this.wrote) {
            throw new IllegalStateException("Write called twice");
        }
        this.wrote = true;
    }

    protected static void copyStream(InputStream is, OutputStream os, long totalToCopy) throws IOException {
        int count;
        byte[] buf = new byte[8192];
        long total = 0L;
        long remain = totalToCopy;
        while (total != totalToCopy && (count = is.read(buf, 0, (int)MathUtil.clamp(remain, 0L, (long)buf.length))) != -1) {
            os.write(buf, 0, count);
            total += (long)count;
            remain -= (long)count;
        }
        if (totalToCopy != total) {
            throw new IOException("Short read, expected=" + totalToCopy + " read=" + total);
        }
    }
}

