/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.hq.product.jmx.MxNotificationPlugin;
import org.hyperic.hq.product.jmx.MxUtil;

public class MxNotificationListener
implements NotificationListener {
    private LogTrackPlugin plugin;
    private Properties props;
    private String[] mbeans;
    private boolean isLogTrackEnabled = true;
    private boolean isConfigTrackEnabled = true;
    protected static Log log = LogFactory.getLog((String)MxNotificationListener.class.getName());

    private MxNotificationListener() {
    }

    public MxNotificationListener(LogTrackPlugin plugin) {
        this.plugin = plugin;
        this.props = plugin.getConfig().toProperties();
    }

    public static MxNotificationListener getInstance(MxNotificationPlugin plugin) {
        MxNotificationListener listener = new MxNotificationListener(plugin);
        listener.mbeans = plugin.getMBeans();
        return listener;
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public Object getHandback() {
        return null;
    }

    private String[] translate(String[] mbeans) {
        String[] translated = new String[mbeans.length];
        for (int i = 0; i < mbeans.length; ++i) {
            translated[i] = MxUtil.expandObjectName(mbeans[i], this.props);
        }
        return translated;
    }

    public void add() throws PluginException {
        MBeanServerConnection mServer;
        try {
            mServer = MxUtil.getMBeanServer(this.props);
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), e);
        }
        String[] mbeans = this.translate(this.mbeans);
        for (int i = 0; i < mbeans.length; ++i) {
            ObjectName obj;
            try {
                obj = new ObjectName(mbeans[i]);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            try {
                mServer.addNotificationListener(obj, this, this.getFilter(), this.getHandback());
                log.debug((Object)("Added listener for: " + mbeans[i]));
                continue;
            }
            catch (Exception e) {
                throw new PluginException("addNotificationListener(" + mbeans[i] + "): " + e.getMessage(), e);
            }
        }
    }

    public void remove() throws PluginException {
        MBeanServerConnection mServer;
        try {
            mServer = MxUtil.getMBeanServer(this.props);
        }
        catch (Exception e) {
            throw new PluginException("getMBeanServer(" + this.props + "): " + e.getMessage(), e);
        }
        String[] mbeans = this.translate(this.mbeans);
        for (int i = 0; i < mbeans.length; ++i) {
            ObjectName obj;
            try {
                obj = new ObjectName(mbeans[i]);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            try {
                mServer.removeNotificationListener(obj, this);
                log.info((Object)("Removed listener for: " + mbeans[i]));
                continue;
            }
            catch (ListenerNotFoundException e) {
                log.warn((Object)(mbeans[i] + ": " + e.getMessage()));
                continue;
            }
            catch (Exception e) {
                throw new PluginException("removeNotificationListener(" + mbeans[i] + "): " + e.getMessage(), e);
            }
        }
    }

    @Override
    public synchronized void handleNotification(Notification notification, Object handback) {
        String msg;
        boolean isAttrChange = notification instanceof AttributeChangeNotification;
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.plugin.getName() + " received notification: " + notification));
        }
        if (isAttrChange && this.isConfigTrackEnabled) {
            AttributeChangeNotification change = (AttributeChangeNotification)notification;
            msg = "Attribute: " + change.getAttributeName() + " changed from " + change.getOldValue() + " to " + change.getNewValue();
        } else if (this.isLogTrackEnabled) {
            msg = notification.getMessage();
        } else {
            return;
        }
        if (msg == null) {
            Object data = notification.getUserData();
            msg = data != null ? data.toString() : notification.getType();
        }
        long time = notification.getTimeStamp();
        int level = 6;
        String typeString = notification.getType();
        if (typeString != null) {
            if (typeString.equalsIgnoreCase("Error")) {
                level = 3;
            } else if (typeString.equalsIgnoreCase("Warn")) {
                level = 4;
            } else if (typeString.equalsIgnoreCase("Debug")) {
                level = 7;
            }
        }
        String source = notification.getSource().toString();
        if (isAttrChange) {
            TrackEvent event = new TrackEvent(this.plugin.getName(), time, level, source, msg);
            this.plugin.getManager().reportEvent(event);
        } else {
            this.plugin.reportEvent(time, level, source, msg);
        }
    }
}

