/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.util.security.MD5;

public class PluginInfo
implements Serializable {
    public long mtime;
    public String jar;
    public String md5;
    public String name;
    public String version;
    public String product;
    public int deploymentOrder = 0;
    public transient ClassLoader resourceLoader = null;

    PluginInfo(String name, String version) {
        this.name = name;
        this.version = version;
        this.product = name;
        this.jar = "";
        this.md5 = "";
    }

    PluginInfo(File file, String version) {
        this.name = file.getName().replace("-plugin", "").replace(".xml", "").replace(".jar", "");
        this.version = version;
        this.product = this.name;
        this.jar = file.getName();
        this.md5 = MD5.getMD5Checksum((File)file);
    }

    public PluginInfo(ProductPlugin plugin, String jar) {
        try {
            File jarFile = new File(jar);
            this.deploymentOrder = plugin.getDeploymentOrder();
            this.name = plugin.getName();
            this.version = plugin.getPluginVersion();
            this.product = plugin.getName();
            this.md5 = this.getMD5(plugin, jar);
            this.jar = jarFile.getName();
            this.mtime = jarFile.lastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PluginInfo(String name, PluginInfo info) {
        this.product = info.name;
        this.name = name;
        this.version = info.version;
        this.md5 = info.md5;
        this.jar = info.jar;
        this.mtime = info.mtime;
        this.resourceLoader = info.resourceLoader;
        this.deploymentOrder = info.deploymentOrder;
    }

    private String getMD5(ProductPlugin plugin, String jar) throws IOException {
        return MD5.getMD5Checksum((File)new File(jar));
    }

    public int hashCode() {
        return 17 + (7 * this.md5.hashCode() + 7 * this.jar.hashCode());
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof PluginInfo) {
            PluginInfo info = (PluginInfo)rhs;
            return this.md5.equals(info.md5) && this.jar.equals(info.jar);
        }
        return false;
    }

    public boolean matches(PluginInfo info) {
        return this.md5.equals(info.md5) && this.jar.equals(info.jar) && this.mtime == info.mtime;
    }

    public String toString() {
        String s = "product=" + this.product + ", name=" + this.name + ", md5=" + this.md5 + ", file=" + this.jar + ", mtime=" + new Date(this.mtime);
        return "{" + s + "}";
    }
}

