/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.Map;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;

public class ServiceResource {
    public static final String SERVER_NAME_PLACEHOLDER = "%serviceName%";
    AIServiceValue resource = new AIServiceValue();

    public void setServiceName(String name) {
        this.setName(name);
    }

    public void setType(GenericPlugin plugin, String type) {
        this.setType(plugin.getTypeInfo().getName() + " " + type);
    }

    public void setType(String name) {
        this.resource.setServiceTypeName(name);
    }

    public String getType() {
        return this.resource.getServiceTypeName();
    }

    public void setName(String name) {
        this.resource.setName(name);
    }

    public String getName() {
        return this.resource.getName();
    }

    public void setDescription(String description) {
        this.resource.setDescription(description);
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    private RuntimeException encodeException() {
        return new RuntimeException("Error encoding config");
    }

    public void setProductConfig(ConfigResponse config) {
        if (config == null) {
            return;
        }
        try {
            this.resource.setProductConfig(config.encode());
        }
        catch (EncodingException e) {
            throw this.encodeException();
        }
    }

    public ConfigResponse getProductConfig() {
        try {
            return ConfigResponse.decode((byte[])this.resource.getProductConfig());
        }
        catch (EncodingException e) {
            throw this.encodeException();
        }
    }

    public void setMeasurementConfig(ConfigResponse config) {
        if (config == null) {
            return;
        }
        try {
            this.resource.setMeasurementConfig(config.encode());
        }
        catch (EncodingException e) {
            throw this.encodeException();
        }
    }

    public void setMeasurementConfig(ConfigResponse config, int logTrackLevel) {
        LogTrackPlugin.setEnabled(config, 3, logTrackLevel);
        this.setMeasurementConfig(config);
    }

    public void setControlConfig(ConfigResponse config) {
        if (config == null) {
            return;
        }
        try {
            this.resource.setControlConfig(config.encode());
        }
        catch (EncodingException e) {
            throw this.encodeException();
        }
    }

    public void setResponseTimeConfig(ConfigResponse config) {
        if (config == null) {
            return;
        }
        try {
            this.resource.setResponseTimeConfig(config.encode());
        }
        catch (EncodingException e) {
            throw this.encodeException();
        }
    }

    public void setProductConfig() {
        this.resource.setProductConfig(ConfigResponse.EMPTY_CONFIG);
    }

    public void setMeasurementConfig() {
        this.resource.setMeasurementConfig(ConfigResponse.EMPTY_CONFIG);
    }

    public void setControlConfig() {
        this.resource.setControlConfig(ConfigResponse.EMPTY_CONFIG);
    }

    public void setCustomProperties(ConfigResponse config) {
        if (config == null || config.getKeys().size() == 0) {
            return;
        }
        try {
            this.resource.setCustomProperties(config.encode());
        }
        catch (EncodingException e) {
            throw this.encodeException();
        }
    }

    public void setProductConfig(Map config) {
        this.setProductConfig(new ConfigResponse(config));
    }

    public void setMeasurementConfig(Map config) {
        this.setMeasurementConfig(new ConfigResponse(config));
    }

    public void setControlConfig(Map config) {
        this.setControlConfig(new ConfigResponse(config));
    }

    public void setCustomProperties(Map props) {
        this.setCustomProperties(new ConfigResponse(props));
    }

    public String toString() {
        return this.resource.toString();
    }
}

