#!/bin/bash

# Define a timestamp function
timestamp() {
  date +%Y-%m-%d" "%H:%M:%S.%3N
}

# Should we generate a new instance id
FORCE_UPDATE_UM_UUID="$1"

TABLE_NAME="\"KeyValueStore\""
UM_UUID_KEY="UM_UUID"

PSQL_CHECK=`psql -U usgmtr -c "select count(1) from $TABLE_NAME;"`
PSQL_COMMAND="psql -U usgmtr"
if [[ "$PSQL_CHECK" != *"count"* ]]
then
    PSQL_COMMAND="/opt/vmware/vpostgres/current/bin/psql -U usgmtr"
fi

# First check whether a row with key "UM_UUID" exists
CHECK_UM_UUID_EXISTENCE=`$PSQL_COMMAND -c "select count(*) from $TABLE_NAME where key='$UM_UUID_KEY';";`
if [[ "$CHECK_UM_UUID_EXISTENCE" == *"0"* ]]
# If no row is found, add it
then
    UUID="$(uuidgen)"
    DATE="$(timestamp)"

    # Add a row to the KeyValueStore table, with the key of "UM_UUID" and the value of the generated UUID
    INSERT=`$PSQL_COMMAND -c "insert into $TABLE_NAME values ('$UM_UUID_KEY', '$UUID', '$DATE', '$DATE', '');" 2>&1`
    echo $UM_UUID_KEY was added to $TABLE_NAME with value: $UUID.
    exit
else
# If a row exists, but we force update, update it
    if [[ "$FORCE_UPDATE_UM_UUID" == "--forceUpdate" ]]
    then
        UUID="$(uuidgen)"
        DATE="$(timestamp)"

        # If a row with the key of "UM_UUID" already exists in "KeyValueStore" and force update of the instance UUID
        # update the value with the new generated instance UUID and the date of change
        UPDATE=`$PSQL_COMMAND -c "update $TABLE_NAME set \"value\"='$UUID', \"changedDate\"='$DATE' where \"key\"='$UM_UUID_KEY';"`
        echo $UM_UUID_KEY value was updated: $UUID.
        exit
    else
        echo $UM_UUID_KEY is already generated and update is not forced.
        echo You can force update using "--forceUpdate" flag.
        exit 1
    fi
fi