/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.FileMetadata;
import org.hyperic.hq.agent.commands.AgentUpdateFiles_result;
import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.bizapp.client.AgentCallbackClient;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.shared.lather.GetAgentCommands_args;
import org.hyperic.hq.bizapp.shared.lather.GetAgentCommands_result;
import org.hyperic.hq.bizapp.shared.lather.GetDisabledPlugins_args;
import org.hyperic.hq.bizapp.shared.lather.GetDisabledPlugins_result;
import org.hyperic.hq.bizapp.shared.lather.SendAgentResponses_args;
import org.hyperic.hq.bizapp.shared.lather.SendAgentResponses_result;
import org.hyperic.hq.common.InvocationRequest;
import org.hyperic.hq.common.InvocationResponse;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.lather.LatherValue;
import org.hyperic.util.file.FileWriter;
import org.hyperic.util.http.ServerHttpClient;

public class AgentCommandsCallbackClient
extends AgentCallbackClient {
    private static final Log LOGGER = LogFactory.getLog(AgentCommandsCallbackClient.class);
    private static final int DOWNLOAD_MAX_SLEEP_TIME = 300000;
    private static final int DOWNLOAD_RETRY_COUNT = 10;
    private final List<FileWriter> fileWriters = new ArrayList<FileWriter>();

    public AgentCommandsCallbackClient(ProviderFetcher fetcher, AgentConfig config) {
        super(fetcher, config);
    }

    public List<InvocationRequest> getAgentCommands() throws AgentCallbackClientException {
        ProviderInfo provider = this.getProvider();
        GetAgentCommands_result result = (GetAgentCommands_result)this.invokeLatherCall(provider, "getAgentCommands", (LatherValue)new GetAgentCommands_args());
        return result.getAgentCommands();
    }

    public boolean sendAgentResponses(List<InvocationResponse> responses) throws AgentCallbackClientException {
        ProviderInfo provider = this.getProvider();
        SendAgentResponses_args args = new SendAgentResponses_args();
        args.setResponses(responses);
        SendAgentResponses_result result = (SendAgentResponses_result)this.invokeLatherCall(provider, "sendCommandsResponse", (LatherValue)args);
        return result.isSuccess();
    }

    public List<String> getDisabledPlugins() throws AgentCallbackClientException {
        ProviderInfo provider = this.getProvider();
        GetDisabledPlugins_result result = (GetDisabledPlugins_result)this.invokeLatherCall(provider, "getDisabledPlugins", (LatherValue)new GetDisabledPlugins_args());
        return result.getDisabledPlugins();
    }

    public AgentUpdateFiles_result downloadFilesFromCurrentProvider(List<FileMetadata> fileMetaDataList) throws AgentCallbackClientException {
        ProviderInfo providerInfo = null;
        try {
            providerInfo = this.getProvider();
            return this.downloadFilesFromProvider(providerInfo, fileMetaDataList);
        }
        catch (AgentCallbackClientException e) {
            LOGGER.error((Object)"Error occurred while attempting to download files: ", (Throwable)((Object)e));
            throw e;
        }
    }

    public AgentUpdateFiles_result downloadFilesFromProvider(ProviderInfo provider, List<FileMetadata> fileMetaDataList) throws AgentCallbackClientException {
        if (CollectionUtils.isEmpty(fileMetaDataList)) {
            LOGGER.info((Object)"No files to download");
            return new AgentUpdateFiles_result();
        }
        if (null == provider) {
            LOGGER.info((Object)"No server to download from");
            throw new AgentCallbackClientException("Provider is null");
        }
        LOGGER.info((Object)String.format("%d files are going to be downloaded from the server", fileMetaDataList.size()));
        ServerHttpClient httpClient = this.getReusableClient();
        int randomNumber = this.getRandomBaseInterval(20);
        return this.downloadWithRetries(provider, fileMetaDataList, httpClient, 10, randomNumber);
    }

    private AgentUpdateFiles_result downloadWithRetries(ProviderInfo provider, List<FileMetadata> fileMetaDataList, ServerHttpClient httpClient, int attemptNum, int randomNumber) throws AgentCallbackClientException {
        AgentUpdateFiles_result result = new AgentUpdateFiles_result();
        for (FileMetadata fileMetaData : fileMetaDataList) {
            long sleepTimeMillis = 1000 * randomNumber;
            DOWNLOAD_STATUS downloadStatus = DOWNLOAD_STATUS.SHOULD_RETRY;
            for (int i = 0; i < attemptNum; ++i) {
                LOGGER.info((Object)("Performing download attempt " + String.valueOf(i + 1) + "/" + String.valueOf(attemptNum)));
                downloadStatus = this.downloadSingleFile(httpClient, fileMetaData, provider.getProviderAddress());
                if (downloadStatus == DOWNLOAD_STATUS.DONE) {
                    result.setValue("FilesToUpdate-" + fileMetaData.getMD5CheckSum(), "true");
                    break;
                }
                sleepTimeMillis = this.waitForRetry(sleepTimeMillis);
            }
            if (downloadStatus == DOWNLOAD_STATUS.DONE) continue;
            LOGGER.error((Object)"Could not download all plugins. Rolling back.");
            this.rollback();
            throw new AgentCallbackClientException("Download attempts exhausted.");
        }
        LOGGER.info((Object)String.format("All %d files in this batch have been downloaded successfully", fileMetaDataList.size()));
        return result;
    }

    private void rollback() {
        for (FileWriter fileWriter : this.fileWriters) {
            try {
                fileWriter.rollback();
            }
            catch (IOException exc) {
                LOGGER.error((Object)String.format("Error rolling back '%s': ", fileWriter.getDestFile()), (Throwable)exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private DOWNLOAD_STATUS downloadSingleFile(ServerHttpClient httpClient, FileMetadata fileMetadata, String providerAddress) throws AgentCallbackClientException {
        DOWNLOAD_STATUS downloadStatus;
        block14: {
            HttpEntity httpEntity;
            String absolutePluginUrl;
            block13: {
                String fileName = this.extractFileNameFromUrl(fileMetadata.getSourceFileUri());
                if (!ProductPluginManager.isValidPluginName((String)fileName) && !ProductPluginManager.isValidBundleName((String)fileName)) {
                    throw new AgentCallbackClientException("Invalid file name (neither a bundle filename nor a plugin name): " + fileMetadata);
                }
                absolutePluginUrl = this.getAbsosultePluginUrl(fileMetadata.getSourceFileUri(), providerAddress);
                LOGGER.info((Object)String.format("Downloading file from: %s", absolutePluginUrl));
                httpEntity = null;
                HttpResponse response = httpClient.get(absolutePluginUrl, true);
                httpEntity = response.getEntity();
                if (httpEntity != null && response.getStatusLine().getStatusCode() == 200) {
                    this.writeFileToDisk(httpEntity, fileMetadata);
                    downloadStatus = DOWNLOAD_STATUS.DONE;
                    break block13;
                }
                if (response.getStatusLine().getStatusCode() == 404) {
                    throw new AgentCallbackClientException(String.format("Could not find file : %s", absolutePluginUrl));
                }
                LOGGER.error((Object)String.format("Failed downloading file: %s , server returned the following error: %d-%s", absolutePluginUrl, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                downloadStatus = DOWNLOAD_STATUS.SHOULD_RETRY;
            }
            try {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Failed to consume HttpEntity in order to clean the connection");
            }
            break block14;
            catch (IOException e) {
                try {
                    LOGGER.error((Object)String.format("Failed downloading file: %s", absolutePluginUrl), (Throwable)e);
                    downloadStatus = DOWNLOAD_STATUS.SHOULD_RETRY;
                }
                catch (Throwable throwable) {
                    try {
                        EntityUtils.consume(httpEntity);
                    }
                    catch (IOException e2) {
                        LOGGER.error((Object)"Failed to consume HttpEntity in order to clean the connection");
                    }
                    throw throwable;
                }
                try {
                    EntityUtils.consume((HttpEntity)httpEntity);
                }
                catch (IOException e3) {
                    LOGGER.error((Object)"Failed to consume HttpEntity in order to clean the connection");
                }
            }
        }
        return downloadStatus;
    }

    private boolean writeFileToDisk(HttpEntity httpEntity, FileMetadata fileMetaData) throws IOException, AgentCallbackClientException {
        String errorMessage = null;
        InputStream inputStream = httpEntity.getContent();
        LOGGER.info((Object)("Preparing to write " + fileMetaData.getDestFileRelativePath()));
        FileWriter fileWriter = null;
        try {
            LOGGER.info((Object)("Writing to '" + fileMetaData + "'"));
            fileWriter = new FileWriter(new File(fileMetaData.getDestFileRelativePath()), inputStream, fileMetaData.getMD5CheckSum());
            this.fileWriters.add(fileWriter);
            fileWriter.write();
            fileWriter.verifyMD5CheckSum();
            fileWriter.cleanup();
            String destFile = fileWriter.getDestFile().getAbsolutePath();
            LOGGER.info((Object)("Successfully wrote: " + destFile));
            boolean bl = true;
            return bl;
        }
        catch (IOException exc) {
            errorMessage = "Error writing to '" + fileWriter.getDestFile().getAbsolutePath() + "': " + exc.getMessage();
            String destFile = fileWriter.getDestFile().getAbsolutePath();
            LOGGER.error((Object)errorMessage, (Throwable)exc);
            LOGGER.info((Object)("Rolling back '" + destFile + "'"));
            try {
                fileWriter.rollback();
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error rolling back '" + destFile + ": " + e.getMessage()), (Throwable)e);
            }
            throw new AgentCallbackClientException(exc);
        }
        finally {
            inputStream.close();
        }
    }

    private String getAbsosultePluginUrl(String pluginUrl, String providerAddress) {
        try {
            URI uri = new URI(pluginUrl);
            if (uri.isAbsolute()) {
                return pluginUrl;
            }
        }
        catch (URISyntaxException e) {
            LOGGER.debug((Object)"Got a non-absolute path", (Throwable)e);
        }
        String absolutePluginUrl = providerAddress + pluginUrl;
        absolutePluginUrl = absolutePluginUrl.replaceFirst("\\/epops-webapp\\/lather", "");
        return absolutePluginUrl;
    }

    private String extractFileNameFromUrl(String relativePluginUrl) {
        String pluginName = relativePluginUrl.substring(relativePluginUrl.lastIndexOf(47) + 1);
        return pluginName;
    }

    private long waitForRetry(long sleepTimeMillis) {
        LOGGER.error((Object)("Could not download file, waiting for " + String.valueOf(sleepTimeMillis / 1000L) + " seconds before retrying."));
        try {
            Thread.sleep(sleepTimeMillis);
            if ((sleepTimeMillis *= 2L) > 300000L) {
                sleepTimeMillis = 300000L;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return sleepTimeMillis;
    }

    private int getRandomBaseInterval(int maxValue) {
        Random rand = new Random();
        int randomNumber = rand.nextInt(maxValue) + 1;
        return randomNumber;
    }

    private static enum DOWNLOAD_STATUS {
        DONE,
        SHOULD_RETRY;

    }
}

