/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.stats.AgentStatsCollector;
import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.bizapp.agent.client.AgentClient;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.common.CommonServerInteractor;
import org.hyperic.hq.bizapp.shared.lather.CommandInfo;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;
import org.hyperic.lather.client.LatherHTTPClient;
import org.hyperic.util.http.ServerHttpClient;

public abstract class AgentCallbackClient {
    private static final String HTTP_PROTOCOL = "https";
    private static final String LATHER_DEFAULT_PATH = "/epops-webapp/lather";
    private static final Log log = LogFactory.getLog(AgentCallbackClient.class);
    private static final String LATHER_CMD = "LATHER_CMD";
    private final ProviderFetcher fetcher;
    private static AgentStatsCollector statsCollector = AgentStatsCollector.getInstance();
    private static final AtomicReference<AgentConfig> config;

    public static void setAgentConfig(AgentConfig cfg) {
        config.set(cfg);
    }

    public static AgentConfig getAgentConfig() {
        return config.get();
    }

    protected ServerHttpClient getReusableClient() {
        ServerHttpClient reusableClient = CommonServerInteractor.INSTANCE.getHttpClient();
        return reusableClient;
    }

    public AgentCallbackClient(ProviderFetcher fetcher, AgentConfig config) {
        this.fetcher = fetcher;
        this.resetProvider();
        AgentCallbackClient.setAgentConfig(config);
    }

    void resetProvider() {
    }

    protected ProviderInfo getProvider() throws AgentCallbackClientException {
        ProviderInfo val = this.fetcher.getProvider();
        if (val == null) {
            String msg = "Unable to communicate with server -- provider not yet setup. Agent might still be initializing.";
            throw new AgentCallbackClientException("Unable to communicate with server -- provider not yet setup. Agent might still be initializing.");
        }
        return val;
    }

    public static String getDefaultProviderURL(String host, int port) {
        if (port == -1) {
            port = 443;
        }
        try {
            return new URL(HTTP_PROTOCOL, host, port, LATHER_DEFAULT_PATH).toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String getHostFromProviderURL(String providerURL) {
        URL url = null;
        try {
            url = new URL(providerURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return url.getHost();
    }

    protected LatherValue invokeLatherCall(ProviderInfo provider, String methodName, LatherValue args) throws AgentCallbackClientException {
        boolean closeConn = Boolean.parseBoolean(AgentConfig.getDefaultProperties().getProperty(AgentConfig.PROP_CLOSE_HTTP_CONNECTION_BY_DEFAULT[0]));
        String addr = provider.getProviderAddress();
        LatherHTTPClient latherClient = new LatherHTTPClient(addr, this.getReusableClient());
        return this.invokeLatherCall(provider, methodName, args, latherClient, closeConn);
    }

    protected LatherValue invokeLatherCall(ProviderInfo provider, String methodName, LatherValue args, LatherHTTPClient latherClient) throws AgentCallbackClientException {
        boolean closeConn = Boolean.parseBoolean(AgentConfig.getDefaultProperties().getProperty(AgentConfig.PROP_CLOSE_HTTP_CONNECTION_BY_DEFAULT[0]));
        return this.invokeLatherCall(provider, methodName, args, latherClient, closeConn);
    }

    protected LatherValue invokeLatherCall(ProviderInfo provider, String methodName, LatherValue args, boolean closeConn) throws AgentCallbackClientException {
        String addr = provider.getProviderAddress();
        LatherHTTPClient latherClient = new LatherHTTPClient(addr, this.getReusableClient());
        return this.invokeLatherCall(provider, methodName, args, latherClient, closeConn);
    }

    protected LatherValue invokeLatherCall(ProviderInfo provider, String methodName, LatherValue args, LatherHTTPClient latherClient, boolean closeConn) throws AgentCallbackClientException {
        boolean debug = log.isDebugEnabled();
        String addr = provider.getProviderAddress();
        try {
            long start = this.now();
            LatherValue rtn = latherClient.invoke(methodName, args, closeConn);
            long duration = this.now() - start;
            statsCollector.addStat(duration, LATHER_CMD);
            statsCollector.addStat(duration, "LATHER_CMD_" + methodName.toUpperCase());
            return rtn;
        }
        catch (SSLException e) {
            if (debug) {
                log.debug((Object)e, (Throwable)e);
            }
            try {
                log.debug((Object)"Handling SSL Exception due to SSL Certificate change in vROps Server");
                AgentConfig.acceptChangedSSLCertFromServer = true;
                String[] setupCmd = new String[]{"setup"};
                AgentClient.main(setupCmd);
                log.debug((Object)"Successfully installed new SSL Certificate received from server");
                AgentConfig.acceptChangedSSLCertFromServer = false;
                String[] restartCmd = new String[]{"restart"};
                AgentClient.main(restartCmd);
            }
            catch (Exception ex) {
                log.debug((Object)"Exeception occured while installing updated SSl Certificate :", (Throwable)ex);
                AgentConfig.acceptChangedSSLCertFromServer = false;
            }
            throw new AgentCallbackClientException(e);
        }
        catch (ConnectException exc) {
            String eMsg = "Unable to contact server @ " + addr + ": " + exc;
            if (debug) {
                log.debug((Object)eMsg);
            }
            throw new AgentCallbackClientException(eMsg, exc);
        }
        catch (IOException exc) {
            String msg = exc.getMessage();
            if (debug) {
                log.debug((Object)("IOException occurred" + msg));
            }
            throw new AgentCallbackClientException(msg, exc);
        }
        catch (LatherRemoteException exc) {
            String eMsg = "Remote error while invoking '" + methodName + ": " + (Object)((Object)exc);
            if (debug) {
                log.debug((Object)eMsg);
            }
            throw new AgentCallbackClientException(eMsg, exc);
        }
        catch (IllegalStateException e) {
            if (debug) {
                log.debug((Object)"Could not create the LatherHTTPClient instance", (Throwable)e);
            }
            throw new AgentCallbackClientException(e);
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    static {
        statsCollector.register(LATHER_CMD);
        for (String cmd : CommandInfo.ALL_COMMANDS) {
            statsCollector.register("LATHER_CMD_" + cmd.toUpperCase());
        }
        config = new AtomicReference();
    }
}

