/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent.client;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.bouncycastle.operator.OperatorCreationException;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentConfigException;
import org.hyperic.hq.agent.AgentConnectionException;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.agent.AgentLifecycle;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentUpgradeManager;
import org.hyperic.hq.agent.client.AgentCommandsClient;
import org.hyperic.hq.agent.client.AgentConnection;
import org.hyperic.hq.agent.client.LegacyAgentCommandsClientImpl;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.LoggingOutputStream;
import org.hyperic.hq.bizapp.agent.PlatformToken;
import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.bizapp.agent.TokenNotFoundException;
import org.hyperic.hq.bizapp.agent.client.AgentClientUtil;
import org.hyperic.hq.bizapp.agent.client.AgentInvokeException;
import org.hyperic.hq.bizapp.agent.client.AgentStartupException;
import org.hyperic.hq.bizapp.agent.client.AskQuestionsUtil;
import org.hyperic.hq.bizapp.agent.client.CommandsClient;
import org.hyperic.hq.bizapp.agent.client.SecureAgentConnection;
import org.hyperic.hq.bizapp.client.AgentCallbackClient;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.BizappCallbackClient;
import org.hyperic.hq.bizapp.client.CachedCertificateException;
import org.hyperic.hq.bizapp.client.RegisterAgentResult;
import org.hyperic.hq.bizapp.client.StaticProviderFetcher;
import org.hyperic.hq.bizapp.client.common.CommonServerInteractor;
import org.hyperic.hq.common.shared.ProductProperties;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.util.properties.PropertiesUtil;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.FileWatcherThread;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.util.PropertyEncryptionUtil;
import org.hyperic.util.PropertyUtil;
import org.hyperic.util.StringUtil;
import org.hyperic.util.exec.Os;
import org.hyperic.util.security.CertificateService;
import org.hyperic.util.security.KeystoreConfig;
import org.hyperic.util.security.KeystoreManager;
import org.hyperic.util.security.SecurityUtil;
import org.hyperic.util.vmware.VMwareGuestInfo;
import org.tanukisoftware.wrapper.WrapperManager;

public class AgentClient {
    private static final String EP_OPS_SERVICE_IMAGE_PATH_REGISTRY_KEY = "SYSTEM\\CurrentControlSet\\Services\\End Point Operations Management Agent";
    private static final PrintStream SYSTEM_ERR = System.err;
    private static final PrintStream SYSTEM_OUT = System.out;
    private static final String REGISTRATION_URL_SUFFIX = "-registration";
    private static final String DEFAULT_LOG_LEVEL = "INFO";
    private static final String LOG_PATTERN_LAYOUT = "%d %-5p [%t] [%c{1}] %m%n";
    private static final int BUFFER_SIZE = 1024;
    private static final String MAX_FILE_SIZE = "5000KB";
    private static final int MAX_FILES = 1;
    private static final String PROP_LOGFILE = "agent.logFile";
    private static final String PROP_STARTUP_TIMEOUT = "agent.startupTimeOut";
    private static final int AGENT_STARTUP_TIMEOUT = 300;
    private static final String PROP_SERVER_CONNECTION_TIMEOUT = "agent.setup.serverConnectionTimeout";
    private static final int SERVER_CONNECTION_TIMEOUT_DEFAULT = 300;
    private static final int ONE_MINUTE = 60000;
    private static final int FORCE_SETUP = -42;
    private static final int LOGIN_ATTEMPTS_LIMIT = 5;
    private static final int TOKEN_LOAD_ATTEMPTS_LIMIT = 3;
    private final AgentCommandsClient agtCommands;
    private final CommandsClient camCommands;
    private final AgentConfig config;
    private boolean redirectedOutputs = false;
    private final AskQuestionsUtil askQuestionUtil;
    private static Thread agentDaemonThread;
    private static final Log log;
    private static final String PING = "ping";
    private static final String DIE = "die";
    private static final String START = "start";
    private static final String STATUS = "status";
    private static final String RESTART = "restart";
    private static final String SETUP = "setup";
    private static final String SETUP_IF_NO_PROVIDER = "setup-if-no-provider";
    private static final String SET_PROPERTY = "set-property";
    private static final String UNTRUSTED_CERTIFICATE_MSG = "The authenticity of the host cannot be established for one of the following reasons:\n1. An untrusted certificate was presented.\n2. The host is unreachable.\n3. The agent machine or the host are overloaded.\nVerify the serverIP and serverCertificateThumbprint agent properties and retry.";
    private static final String INVALID_ENTRY_AUTO_MESSAGE = "The agent could not connect to the specified hostname/IP address and port. The current provider host/port is invalid.";
    private static final String VM_UNIQUE_IDENTIFIER_ENV_KEY_NAME = "vrealize_operations_agent_id";

    private AgentClient(AgentConfig config, SecureAgentConnection conn) {
        this.agtCommands = new LegacyAgentCommandsClientImpl((AgentConnection)conn);
        this.camCommands = new CommandsClient((AgentConnection)conn);
        this.config = config;
        this.askQuestionUtil = new AskQuestionsUtil(config);
    }

    private long cmdPing(int numAttempts) throws AgentConnectionException, AgentRemoteException {
        AgentConnectionException lastExc = new AgentConnectionException("Failed to connect to agent");
        while (numAttempts-- != 0) {
            try {
                return this.agtCommands.ping();
            }
            catch (AgentConnectionException exc) {
                lastExc = exc;
                try {
                    if (numAttempts <= 0) continue;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException exc2) {
                    String message = "Connection interrupted: ";
                    log.error((Object)(message + exc2.getMessage()), (Throwable)exc2);
                    throw new AgentConnectionException(message + exc2.getMessage(), (Exception)exc2);
                }
            }
        }
        throw lastExc;
    }

    private void cmdStatus() throws AgentConnectionException, AgentRemoteException {
        String address;
        ProviderInfo pInfo;
        String currentAgentBundle;
        log.info((Object)"Checking agent status");
        try {
            currentAgentBundle = this.agtCommands.getCurrentAgentBundle();
            pInfo = this.camCommands.getProviderInfo();
        }
        catch (AgentConnectionException exc) {
            AgentClient.printAndLog("Unable to contact agent: " + exc.getMessage(), (Exception)((Object)exc));
            return;
        }
        catch (AgentRemoteException exc) {
            AgentClient.printAndLog("Error executing the remote method: " + exc.getMessage(), (Exception)((Object)exc));
            return;
        }
        AgentClient.printAndLog("Current agent bundle: " + currentAgentBundle, LogLevel.INFO);
        if (pInfo == null || (address = pInfo.getProviderAddress()) == null) {
            AgentClient.printAndLog("Agent not yet setup", LogLevel.INFO);
            return;
        }
        AgentClient.printAndLog("Agent token: " + pInfo.getAgentToken(), LogLevel.INFO);
        try {
            URL url = new URL(address);
            AgentClient.printAndLog("Server hostname or IP address: " + url.getHost(), LogLevel.INFO);
            AgentClient.printAndLog("Server (TLS) port: " + url.getPort(), LogLevel.INFO);
        }
        catch (Exception exc) {
            AgentClient.printAndLog("Unable to parse provider info (" + address + "): " + exc.getMessage(), exc);
        }
        if (this.config.isProxyServerSet()) {
            AgentClient.printAndLog("Proxy server hostname or IP address: " + this.config.getProxyIp(), LogLevel.INFO);
            AgentClient.printAndLog("Proxy server port: " + this.config.getProxyPort(), LogLevel.INFO);
        }
    }

    private void cmdDie(int waitTime) throws AgentConnectionException, AgentRemoteException {
        try {
            this.agtCommands.die();
        }
        catch (AgentConnectionException exc) {
            return;
        }
        catch (AgentRemoteException exc) {
            String message = "Error making the remote agent call: ";
            log.error((Object)(message + exc.getMessage()), (Throwable)exc);
            throw new AgentRemoteException(message + exc.getMessage(), (Exception)((Object)exc));
        }
        while (waitTime-- != 0) {
            try {
                this.agtCommands.ping();
            }
            catch (AgentConnectionException exc) {
                return;
            }
            catch (AgentRemoteException exc) {
                AgentClient.printAndLog("Failed to stop the agent: " + exc.getMessage(), (Exception)((Object)exc));
                throw exc;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exc) {
                String message = "Connection interrupted: ";
                log.error((Object)message, (Throwable)exc);
                throw new AgentConnectionException(message + exc.getMessage(), (Exception)exc);
            }
        }
        String message = "Unable to kill agent within timeout";
        log.error((Object)message);
        throw new AgentRemoteException(message);
    }

    private void cmdRestart() throws AgentConnectionException, AgentRemoteException {
        try {
            this.agtCommands.restart();
        }
        catch (AgentConnectionException exc) {
            String message = "Unable to connect to agent: already dead? ";
            log.error((Object)(message + exc.getMessage()), (Throwable)exc);
            throw new AgentConnectionException(message + exc.getMessage(), (Exception)((Object)exc));
        }
        catch (AgentRemoteException exc) {
            String message = "Error making the remote agent call: ";
            log.error((Object)(message + exc.getMessage()), (Throwable)exc);
            throw new AgentRemoteException(message + exc.getMessage(), (Exception)((Object)exc));
        }
    }

    private BizappCallbackClient testProvider(String provider, X509Certificate[] cachedCertificatesChain) throws AgentCallbackClientException, AskQuestionsUtil.AutoQuestionException, IOException, AskQuestionsUtil.UserQuestionException {
        StaticProviderFetcher fetcher = new StaticProviderFetcher(new ProviderInfo(provider, "no-auth"));
        BizappCallbackClient res = new BizappCallbackClient(fetcher, this.config);
        res.bizappServerInfo(cachedCertificatesChain);
        return res;
    }

    private BizappCallbackClient testConnectionToProvider(String provider) throws AskQuestionsUtil.AutoQuestionException, IOException, AskQuestionsUtil.UserQuestionException {
        Properties bootP = this.config.getBootProperties();
        long connectionToProviderTimeout = AgentClient.getServerConnectionTimeout(bootP);
        long startConnectionToProviderTime = System.currentTimeMillis();
        long sleepWaitMillis = 10000L;
        X509Certificate[] cachedCertificatesChain = null;
        while (true) {
            AgentClient.printAndLog("- Testing secure connection ... ", LogLevel.INFO);
            try {
                BizappCallbackClient bizapp = this.testProvider(provider, cachedCertificatesChain);
                AgentClient.printAndLog("- Connection successful.", LogLevel.INFO);
                AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig(bootP);
                CommonServerInteractor.INSTANCE.onKeystoreChange(keystoreConfig);
                return bizapp;
            }
            catch (AgentCallbackClientException exc) {
                CachedCertificateException cachedCertExc;
                String serverCertificateThumbprintPropValue;
                if (exc.getExceptionOfType(SSLPeerUnverifiedException.class) != null && StringUtils.isNotEmpty((String)(serverCertificateThumbprintPropValue = bootP.getProperty("agent.setup.serverCertificateThumbprint")))) {
                    log.error((Object)UNTRUSTED_CERTIFICATE_MSG, (Throwable)((Object)exc));
                    throw new AskQuestionsUtil.AutoQuestionException("The authenticity of the host cannot be established for one of the following reasons:\n1. An untrusted certificate was presented.\n2. The host is unreachable.\n3. The agent machine or the host are overloaded.\nVerify the serverIP and serverCertificateThumbprint agent properties and retry.\n" + exc.getMessage());
                }
                AgentClient.printAndLog("- Connection failed.", LogLevel.ERROR);
                if (this.isAutoHostOrPort(bootP)) {
                    throw new AskQuestionsUtil.AutoQuestionException("Unable to connect to server.");
                }
                if (startConnectionToProviderTime + connectionToProviderTimeout <= System.currentTimeMillis()) {
                    AgentClient.printAndLog("Timeout. Quitting the connection attempts.", LogLevel.ERROR);
                    return null;
                }
                AgentClient.printAndLog("Server might be down (or wrong IP/port were used). Waiting for " + String.valueOf(sleepWaitMillis / 1000L) + " seconds before retrying.", LogLevel.ERROR);
                try {
                    Thread.sleep(sleepWaitMillis);
                    sleepWaitMillis += sleepWaitMillis / 2L;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if ((cachedCertExc = this.getCachedCertificateException(exc)) == null) continue;
                cachedCertificatesChain = cachedCertExc.getCachedCertificatesChain();
                continue;
            }
            catch (AskQuestionsUtil.UserQuestionException e) {
                if (!this.isAutoHostOrPort(bootP)) {
                    boolean isConnectAnotherAnswer = this.askQuestionUtil.askYesNoQuestion("Do you want to connect to another server", false, null);
                    if (isConnectAnotherAnswer) {
                        throw e;
                    }
                    return null;
                }
                AgentClient.printAndLog("- Connection failed.", LogLevel.ERROR);
                throw new AskQuestionsUtil.AutoQuestionException("Unable to connect to server.");
            }
            break;
        }
    }

    private CachedCertificateException getCachedCertificateException(AgentCallbackClientException exc) {
        CachedCertificateException e = (CachedCertificateException)exc.getExceptionOfType(CachedCertificateException.class);
        return e;
    }

    public static String getAgentName() {
        return "EP Ops Agent - " + GenericPlugin.getPlatformDisplayName();
    }

    private void cmdSetupIfNoProvider() throws AgentConnectionException, AgentRemoteException, IOException, AskQuestionsUtil.AutoQuestionException {
        log.debug((Object)"Started cmdSetupIfNoProvider()");
        Properties bootProps = this.config.getBootProperties();
        int timeout = AgentClient.getStartupTimeout(bootProps);
        try {
            this.cmdPing(timeout / 1000);
        }
        catch (AgentRemoteException e) {
            String errorMessage = e.getMessage();
            if ("Unauthorized".equals(errorMessage)) {
                throw new AgentConnectionException("Cannot ping the agent (Unauthorized). Another agent might already be running.");
            }
            throw e;
        }
        ProviderInfo providerInfo = this.camCommands.getProviderInfo();
        if (providerInfo == null) {
            this.cmdSetup();
        } else {
            this.setPlatformVmUniqueIdentifierInGuestinfo(providerInfo.getAgentToken());
        }
    }

    private void cmdSetup() throws AgentConnectionException, AgentRemoteException, IOException, AskQuestionsUtil.AutoQuestionException {
        byte[] csr;
        KeyPair agentKeyPair;
        log.debug((Object)"Started cmdSetup()");
        BizappCallbackClient bizapp = null;
        ProviderInfo providerInfo = this.camCommands.getProviderInfo();
        String provider = null;
        String host = null;
        String agentToken = null;
        int sslConnectionPort = Integer.MIN_VALUE;
        Properties bootP = this.config.getBootProperties();
        try {
            this.cmdPing(1);
        }
        catch (AgentConnectionException exc) {
            AgentClient.printAndLog("Unable to setup agent: " + exc.getMessage(), (Exception)((Object)exc));
            AgentClient.printAndLog("The agent must be running prior to running setup", LogLevel.ERROR);
            return;
        }
        if (System.getenv("SHELL") != null && System.getProperty("os.name") != null && System.getProperty("os.name").toLowerCase().indexOf("win") > -1 && this.config.getBootProperty("agent.setup.serverPword") == null) {
            AgentClient.printAndLog("You cannot use a shell command to register an agent in Windows", LogLevel.ERROR);
            return;
        }
        SYSTEM_OUT.println("[ Running agent setup ]");
        PlatformToken platformToken = this.loadPlatfromToken(bootP, 3);
        if (null == platformToken) {
            AgentClient.printAndLog("You have exceeded the number of attempts permitted to access the default token location. Exiting agent setup.", LogLevel.ERROR);
            return;
        }
        boolean isReissueCertificateRequest = this.isReissueCertificateRequest(providerInfo, platformToken);
        agentToken = this.getEffectiveAgentToken(isReissueCertificateRequest, providerInfo, platformToken);
        if (!this.isSetupFlowWithKnownToken(providerInfo, platformToken)) {
            SYSTEM_ERR.println("The setup command cannot be used because the token file is deleted or damaged. To run setup, correct the token file or reinstall the agent.");
            log.error((Object)("The epops-token file doesn't contain the expected token '" + providerInfo.getAgentToken() + "' so the setup command cannot proceed."));
            return;
        }
        if (platformToken.wasTokenGeneratedByCurrentRun()) {
            AgentClient.printAndLog("- The agent generated the following token", LogLevel.INFO);
        } else {
            AgentClient.printAndLog("- The agent loaded an existing token", LogLevel.INFO);
        }
        AgentClient.printAndLog("    " + agentToken, LogLevel.INFO);
        while (provider == null) {
            if (isReissueCertificateRequest) {
                host = this.getCurrentProviderHost(providerInfo);
                sslConnectionPort = this.getDefaultPort(providerInfo);
                AgentClient.printAndLog("- The agent is already setup for server@" + host + ":" + sslConnectionPort, LogLevel.INFO);
            } else {
                int questionNumber = 1;
                while (true) {
                    try {
                        if (questionNumber == 1) {
                            host = this.askQuestionUtil.askQuestion("Enter the server hostname or IP address", null, "agent.setup.serverIP");
                            ProviderInfo.validateAddress(host);
                            ++questionNumber;
                        }
                        if (questionNumber != 2) break;
                        sslConnectionPort = this.askQuestionUtil.askIntQuestion("Enter the server SSL port", 443, "agent.setup.serverSSLPort");
                        PropertiesUtil.validatePort((int)sslConnectionPort);
                        ++questionNumber;
                    }
                    catch (IllegalArgumentException illegalInputException) {
                        boolean errorInSecondAutoQuestion;
                        boolean errorInFirstAutoQuestion = questionNumber == 1 && StringUtils.isNotBlank((String)bootP.getProperty("agent.setup.serverIP"));
                        boolean bl = errorInSecondAutoQuestion = questionNumber == 2 && StringUtils.isNotBlank((String)bootP.getProperty("agent.setup.serverSSLPort"));
                        if (errorInFirstAutoQuestion || errorInSecondAutoQuestion) {
                            log.error((Object)(INVALID_ENTRY_AUTO_MESSAGE + illegalInputException.getMessage()));
                            throw new AskQuestionsUtil.AutoQuestionException("The agent could not connect to the specified hostname/IP address and port. The current provider host/port is invalid.\n" + illegalInputException.getMessage());
                        }
                        SYSTEM_OUT.println("The data you entered is incorrect.");
                        continue;
                    }
                    break;
                }
            }
            provider = AgentCallbackClient.getDefaultProviderURL(host, sslConnectionPort);
            try {
                bizapp = this.testConnectionToProvider(provider + REGISTRATION_URL_SUFFIX);
                if (bizapp != null && !AgentConfig.acceptChangedSSLCertFromServer) continue;
                return;
            }
            catch (AskQuestionsUtil.UserQuestionException e) {
                if (isReissueCertificateRequest) {
                    String message = "Could not request a new certificate. Current provider host/port is invalid. ";
                    log.error((Object)(message + e.getMessage()));
                    throw new AskQuestionsUtil.AutoQuestionException(message + e.getMessage());
                }
                provider = null;
            }
            catch (IllegalArgumentException illegalArgsExc) {
                AgentClient.printAndLog("Invalid argument: " + illegalArgsExc.getMessage(), LogLevel.ERROR);
                throw new AskQuestionsUtil.AutoQuestionException(INVALID_ENTRY_AUTO_MESSAGE);
            }
        }
        try {
            agentKeyPair = CertificateService.generateKeyPair();
            csr = CertificateService.generateCSR((String)agentToken, (KeyPair)agentKeyPair);
        }
        catch (GeneralSecurityException exc) {
            AgentClient.printAndLog("Unable to generate a certificate signing request: " + exc.getMessage(), exc);
            return;
        }
        catch (OperatorCreationException exc) {
            AgentClient.printAndLog("Unable to generate a certificate signing request: " + exc.getMessage(), (Exception)((Object)exc));
            return;
        }
        String signedCertificateStr = this.registerAgent(isReissueCertificateRequest, bizapp, csr, bootP);
        if (signedCertificateStr == null) {
            return;
        }
        try {
            X509Certificate certificate = CertificateService.convertPemEncodedCertificateToX509Certificate((String)signedCertificateStr);
            this.validateCertificate(certificate, agentToken, agentKeyPair);
            this.importClientCertificateToKeystore(certificate, agentKeyPair);
        }
        catch (Exception exc) {
            AgentClient.printAndLog("- Error with the received certificate: " + exc.getMessage(), exc);
            return;
        }
        this.camCommands.notifyKeystoreChanged();
        AgentClient.printAndLog("- The agent has received a client certificate from server.", LogLevel.INFO);
        ProviderInfo registeredProviderInfo = new ProviderInfo(provider, agentToken, sslConnectionPort);
        this.camCommands.setProviderInfo(registeredProviderInfo);
        providerInfo = this.camCommands.getProviderInfo();
        if (providerInfo == null || !providerInfo.getProviderAddress().equals(provider) || !providerInfo.getAgentToken().equals(agentToken)) {
            if (providerInfo == null) {
                AgentClient.printAndLog(" - Unable to store server information.", LogLevel.ERROR);
            } else {
                AgentClient.printAndLog("- Unable to validate stored server information; the agent is using server '" + providerInfo.getProviderAddress() + "' with token '" + providerInfo.getAgentToken() + "'.", LogLevel.ERROR);
            }
        } else if (isReissueCertificateRequest) {
            AgentClient.printAndLog("- The agent has successfully acquired a new certificate.", LogLevel.INFO);
        } else {
            AgentClient.printAndLog("- The agent has been successfully registered.", LogLevel.INFO);
        }
        this.setPlatformVmUniqueIdentifierInGuestinfo(providerInfo.getAgentToken());
        this.redirectOutputs(bootP);
    }

    private String registerAgent(boolean isReissueCertificateRequest, BizappCallbackClient bizapp, byte[] csr, Properties bootP) throws IOException, AskQuestionsUtil.AutoQuestionException {
        String agentIP = AgentClient.getAgentName();
        for (int attempts = 1; attempts <= 5; ++attempts) {
            RegisterAgentResult result;
            String user = this.askQuestionUtil.askQuestion("Enter your server username", null, "agent.setup.serverLogin");
            String pword = this.askQuestionUtil.askQuestion("Enter your server password", null, true, false, "agent.setup.serverPword");
            try {
                if (isReissueCertificateRequest) {
                    AgentClient.printAndLog("- Sending request for a new certificate", LogLevel.INFO);
                } else {
                    AgentClient.printAndLog("- Registering the agent with server.", LogLevel.INFO);
                }
                result = bizapp.registerAgent(user, pword, agentIP, ProductProperties.getVersion(), csr);
                if (StringUtils.isEmpty((String)result.errorMessage)) {
                    return result.certificate;
                }
            }
            catch (AgentCallbackClientException e) {
                AgentClient.printAndLog("- Unable to register the agent due to server error.", (Exception)((Object)e));
                return null;
            }
            catch (Exception exc) {
                log.error((Object)exc.getMessage(), (Throwable)exc);
                if (isReissueCertificateRequest) {
                    AgentClient.printAndLog("- Error while requesting a new certificate: " + exc.getMessage(), exc);
                } else {
                    AgentClient.printAndLog("- Error registering the agent: " + exc.getMessage(), exc);
                }
                return null;
            }
            this.throwAutoQuestionExceptionIfPropertiesUsed(bootP, result.errorMessage);
            AgentClient.printAndLog("- Unable to register the agent: " + result.errorMessage, LogLevel.ERROR);
        }
        return null;
    }

    private PlatformToken loadPlatfromToken(Properties bootProperties, int maximumRetriesNumber) throws AskQuestionsUtil.AutoQuestionException, IOException {
        PlatformToken platformToken = null;
        String currentTokenLinuxPath = bootProperties.getProperty("agent.setup.tokenFileLinux");
        String currentTokenWindowsPath = bootProperties.getProperty("agent.setup.tokenFileWindows");
        String customTokenPath = Os.isWindowsFamily() ? currentTokenWindowsPath : currentTokenLinuxPath;
        int retryNumber = 0;
        while (null == platformToken) {
            try {
                platformToken = new PlatformToken(currentTokenLinuxPath, currentTokenWindowsPath);
            }
            catch (TokenNotFoundException tokenEx) {
                String message = "Error loading platform token from file: ";
                log.error((Object)(message + tokenEx.getMessage()), (Throwable)tokenEx);
                if (this.isTokenPathConfiguredForAutomatedSetup(bootProperties)) {
                    throw new AskQuestionsUtil.AutoQuestionException(message + tokenEx.getMessage());
                }
                SYSTEM_OUT.println(tokenEx.getMessage());
                if (++retryNumber > maximumRetriesNumber) {
                    return null;
                }
                if (StringUtil.isNullOrEmpty((String)(customTokenPath = this.askQuestionUtil.askQuestionAcceptEmptyAnswer("Correct the problem and press Enter to retry, or provide an alternative token path", customTokenPath, null)))) continue;
                if (Os.isWindowsFamily()) {
                    currentTokenWindowsPath = customTokenPath;
                    continue;
                }
                currentTokenLinuxPath = customTokenPath;
            }
        }
        return platformToken;
    }

    private boolean isAutoHostOrPort(Properties bootP) {
        return bootP.getProperty("agent.setup.serverIP") != null || bootP.getProperty("agent.setup.serverSSLPort") != null;
    }

    private boolean isTokenPathConfiguredForAutomatedSetup(Properties bootProperties) {
        if (Os.isWindowsFamily()) {
            return null != bootProperties.get("agent.setup.tokenFileWindows");
        }
        return null != bootProperties.get("agent.setup.tokenFileLinux");
    }

    private boolean isReissueCertificateRequest(ProviderInfo providerInfo, PlatformToken platformTokenManager) {
        if (platformTokenManager.wasTokenGeneratedByCurrentRun()) {
            return false;
        }
        if (StringUtils.isEmpty((String)platformTokenManager.getValue())) {
            return false;
        }
        if (providerInfo == null) {
            return false;
        }
        return platformTokenManager.getValue().equals(providerInfo.getAgentToken());
    }

    private boolean isSetupFlowWithKnownToken(ProviderInfo providerInfo, PlatformToken platformTokenManager) {
        return !StringUtils.isNotEmpty((String)platformTokenManager.getValue()) || providerInfo == null || !StringUtils.isNotEmpty((String)providerInfo.getAgentToken()) || platformTokenManager.getValue().equals(providerInfo.getAgentToken());
    }

    private String getCurrentProviderHost(ProviderInfo providerInfo) {
        if (providerInfo != null) {
            return providerInfo.getProviderHost();
        }
        return null;
    }

    private int getDefaultPort(ProviderInfo providerInfo) {
        if (providerInfo != null) {
            return providerInfo.getProviderPort();
        }
        return 443;
    }

    private String getEffectiveAgentToken(boolean isReissueCertificateRequest, ProviderInfo providerInfo, PlatformToken platformTokenManager) {
        if (!isReissueCertificateRequest) {
            return platformTokenManager.getValue();
        }
        String currentAgentToken = null;
        if (providerInfo != null) {
            currentAgentToken = providerInfo.getAgentToken();
        }
        return currentAgentToken;
    }

    private void throwAutoQuestionExceptionIfPropertiesUsed(Properties bootP, String errorMessage) throws AskQuestionsUtil.AutoQuestionException {
        if (bootP.getProperty("agent.setup.serverLogin") != null || bootP.getProperty("agent.setup.serverPword") != null) {
            log.error((Object)errorMessage);
            throw new AskQuestionsUtil.AutoQuestionException(errorMessage);
        }
    }

    private void validateCertificate(X509Certificate certificate, String agentTokenInCsr, KeyPair agentKeyPair) throws CertificateException {
        String agentTokenFromCert = CertificateService.extractAgentTokenFromCertificate((X509Certificate)certificate);
        if (!agentTokenInCsr.equals(agentTokenFromCert) || !agentKeyPair.getPublic().equals(certificate.getPublicKey())) {
            String message = "The certificate received from the server does not match the request.";
            log.error((Object)message);
            throw new CertificateException(message);
        }
    }

    private void importClientCertificateToKeystore(X509Certificate certificate, KeyPair agentKeyPair) throws GeneralSecurityException, IOException, OperatorCreationException {
        AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig(this.config);
        CertificateService.saveCertificateToKeystore((String)keystoreConfig.getClientCertificateAlias(), (X509Certificate)certificate, (KeyPair)agentKeyPair, (KeystoreConfig)keystoreConfig);
        log.info((Object)"Imported client certificate into keystore");
    }

    private void verifyAgentRunning(ServerSocket startupSock) throws AgentInvokeException, AgentStartupException {
        FilterInputStream dIs = null;
        Socket conn = null;
        try {
            log.debug((Object)"Before accept socket");
            conn = startupSock.accept();
            log.debug((Object)"After accept socket");
            dIs = new DataInputStream(conn.getInputStream());
            int response = ((DataInputStream)dIs).readInt();
            log.debug((Object)("Read from startup socket: " + response));
            if (response != 1) {
                String message = "Agent reported an error while starting up";
                log.error((Object)message);
                throw new AgentStartupException(message);
            }
        }
        catch (InterruptedIOException exc) {
            String message = "Timed out waiting for Agent to report startup success: ";
            log.error((Object)(message + exc.getMessage()), (Throwable)exc);
            throw new AgentInvokeException(message + exc.getMessage(), exc);
        }
        catch (IOException exc) {
            String message = "Agent failure while starting: ";
            log.error((Object)(message + exc.getMessage()), (Throwable)exc);
            throw new AgentInvokeException(message + exc.getMessage(), exc);
        }
        finally {
            if (startupSock != null) {
                try {
                    startupSock.close();
                }
                catch (IOException exc) {}
            }
            if (dIs != null) {
                try {
                    dIs.close();
                }
                catch (IOException exc) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (IOException exc) {}
            }
        }
        try {
            this.agtCommands.ping();
        }
        catch (Exception exc) {
            String message = "Unable to ping agent: ";
            log.error((Object)(message + exc.getMessage()), (Throwable)exc);
            throw new AgentInvokeException(message + exc.getMessage(), exc);
        }
    }

    private PrintStream newLogStream(String stream, Properties bootProps) throws AgentConfigException, IOException {
        Logger logger = Logger.getLogger((String)stream);
        Level level = Level.toLevel((String)bootProps.getProperty("agent.startup.logLevel." + stream, bootProps.getProperty("agent.logLevel." + stream, DEFAULT_LOG_LEVEL)));
        PatternLayout layout = new PatternLayout(bootProps.getProperty("agent.startup.ConversionPattern", LOG_PATTERN_LAYOUT));
        RollingFileAppender fileAppender = new RollingFileAppender((Layout)layout, this.getStartupLogFile(bootProps), true);
        fileAppender.setImmediateFlush(true);
        fileAppender.setBufferedIO(false);
        fileAppender.setBufferSize(1024);
        fileAppender.setMaxFileSize(bootProps.getProperty("agent.startup.MaxFileSize", MAX_FILE_SIZE));
        fileAppender.setMaxBackupIndex(PropertiesUtil.getGreatOrEqualZeroIntValue((String)"agent.startup.MaxBackupIndex", (String)bootProps.getProperty("agent.startup.MaxBackupIndex"), (int)1));
        logger.addAppender((Appender)fileAppender);
        logger.setAdditivity(false);
        return new PrintStream(new LoggingOutputStream((Category)logger, (Priority)level), true);
    }

    private void redirectOutputs(Properties bootProp) {
        if (this.redirectedOutputs) {
            return;
        }
        this.redirectedOutputs = true;
        try {
            System.setErr(this.newLogStream("SystemErr", bootProp));
            System.setOut(this.newLogStream("SystemOut", bootProp));
        }
        catch (Exception e) {
            e.printStackTrace(SYSTEM_ERR);
        }
    }

    public static Thread getAgentDaemonThread() {
        return agentDaemonThread;
    }

    private int cmdStart(boolean force) throws AgentInvokeException {
        ProviderInfo providerInfo;
        log.debug((Object)"Started cmdStart");
        ServerSocket startupSock = null;
        this.initializeKeystoreBeforeUsage();
        try {
            this.cmdPing(1);
            AgentClient.printAndLog("Agent already running", LogLevel.INFO);
            return -1;
        }
        catch (AgentConnectionException exc) {
        }
        catch (AgentRemoteException exc) {
            // empty catch block
        }
        Properties bootProps = this.config.getBootProperties();
        try {
            int iSleepTime = AgentClient.getStartupTimeout(bootProps);
            startupSock = new ServerSocket(0);
            startupSock.setSoTimeout(iSleepTime);
        }
        catch (IOException e) {
            if (startupSock != null) {
                try {
                    startupSock.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            AgentInvokeException ex = new AgentInvokeException("Unable to setup a socket to listen for Agent startup: " + e.getMessage(), e);
            ex.initCause(e);
            log.error((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        AgentClient.printAndLog("- Invoking agent", LogLevel.INFO);
        int localPort = startupSock.getLocalPort();
        try {
            this.config.setNotifyUpPort(localPort);
        }
        catch (AgentConfigException e) {
            try {
                startupSock.close();
            }
            catch (IOException exc) {
                // empty catch block
            }
            String message = "Invalid notify up port: ";
            log.error((Object)(message + localPort + ": " + e.getMessage()), (Throwable)e);
            throw new AgentInvokeException(message + localPort + ": " + e.getMessage(), (Exception)((Object)e));
        }
        AgentDaemon.RunnableAgent runnableAgent = new AgentDaemon.RunnableAgent(this.config);
        agentDaemonThread = new Thread(runnableAgent);
        agentDaemonThread.setName("AgentDaemonMain");
        AgentUpgradeManager.setAgentDaemonThread((Thread)agentDaemonThread);
        AgentUpgradeManager.setAgent((AgentLifecycle)runnableAgent);
        agentDaemonThread.setDaemon(true);
        log.info((Object)"Starting agent daemon");
        agentDaemonThread.start();
        AgentClient.printAndLog("- Agent thread running", LogLevel.INFO);
        AgentClient.printAndLog("- Verifying if agent is running...", LogLevel.INFO);
        try {
            this.verifyAgentRunning(startupSock);
        }
        catch (AgentStartupException e) {
            log.error((Object)"Error starting the agent: ", (Throwable)((Object)e));
            try {
                log.info((Object)"Join agent daemon thread after agent fails to start");
                agentDaemonThread.join(60000L);
            }
            catch (InterruptedException e1) {
                log.debug((Object)"interrupt after waiting for agent daemon thread.");
            }
        }
        AgentClient.printAndLog("- Agent is running", LogLevel.INFO);
        try {
            providerInfo = this.camCommands.getProviderInfo();
        }
        catch (Exception exc) {
            String message = "Unexpected connection exception: agent is still running: ";
            log.error((Object)(message + exc.getMessage()), (Throwable)exc);
            throw new AgentInvokeException(message + exc.getMessage(), exc);
        }
        AgentClient.printAndLog("Agent successfully started", LogLevel.INFO);
        if (providerInfo == null && !WrapperManager.isControlledByNativeWrapper()) {
            SYSTEM_OUT.println();
            return -42;
        }
        this.redirectOutputs(bootProps);
        return 0;
    }

    private void initializeKeystoreBeforeUsage() throws AgentInvokeException {
        AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig(this.config);
        String message = "Failed to initialize keystore: ";
        try {
            log.debug((Object)"Initializing keystore before its usage");
            KeystoreManager.getKeystoreManager().initializeKeyStore((KeystoreConfig)keystoreConfig);
        }
        catch (KeyStoreException exc) {
            log.error((Object)(message + exc.getMessage()), (Throwable)exc);
            throw new AgentInvokeException(message + exc.getMessage(), exc);
        }
        catch (IOException exc) {
            log.error((Object)(message + exc.getMessage()), (Throwable)exc);
            throw new AgentInvokeException(message + exc.getMessage(), exc);
        }
    }

    private static void cmdSetProp(String propKey, String propVal) throws AgentConfigException {
        String propFile = System.getProperty("agent.propFile", AgentConfig.DEFAULT_PROPFILE);
        AgentConfig.setDefaultProps((String)propFile);
        AgentConfig.ensurePropertiesEncryption((String)propFile);
        char[] propEncKey = null;
        try {
            propEncKey = PropertyEncryptionUtil.getPropertyEncryptionKey((String)AgentConfig.PROP_ENC_KEY_FILE[1]);
            HashMap<String, String> entriesToStore = new HashMap<String, String>();
            entriesToStore.put(propKey, propVal);
            PropertyUtil.storeProperties((String)propFile, (char[])propEncKey, entriesToStore);
        }
        catch (Exception exc) {
            try {
                String message = "Failed to store a new property: ";
                log.error((Object)(message + exc.getMessage()), (Throwable)exc);
                throw new AgentConfigException(message + exc.getMessage(), exc);
            }
            catch (Throwable throwable) {
                SecurityUtil.clearSensitiveData(propEncKey);
                throw throwable;
            }
        }
        SecurityUtil.clearSensitiveData((char[])propEncKey);
    }

    private String getStartupLogFile(Properties bootProps) throws AgentConfigException {
        String logFile = bootProps.getProperty(PROP_LOGFILE);
        if (logFile == null) {
            throw new AgentConfigException("agent.logFile is undefined");
        }
        return logFile + ".startup";
    }

    private static int getStartupTimeout(Properties bootProps) {
        String sleepTime = bootProps.getProperty(PROP_STARTUP_TIMEOUT);
        return PropertiesUtil.getGreatOrEqualZeroIntValue((String)PROP_STARTUP_TIMEOUT, (String)sleepTime, (int)300) * 1000;
    }

    private static int getServerConnectionTimeout(Properties bootProps) {
        String sleepTime = bootProps.getProperty(PROP_SERVER_CONNECTION_TIMEOUT);
        return PropertiesUtil.getGreatOrEqualZeroIntValue((String)PROP_SERVER_CONNECTION_TIMEOUT, (String)sleepTime, (int)300) * 1000;
    }

    private static int getUseTime(String val) {
        return PropertiesUtil.getGreatOrEqualZeroIntValue((String)"UseTime", (String)val, (int)1);
    }

    private static AgentClient initializeAgent(boolean generateToken) throws AgentConfigException {
        AgentConfig cfg;
        String propFile = System.getProperty("agent.propFile", AgentConfig.DEFAULT_PROPFILE);
        AgentConfig.setDefaultProps((String)propFile);
        AgentConfig.ensurePropertiesEncryption((String)propFile);
        BasicConfigurator.configure();
        try {
            cfg = AgentConfig.newInstance((String)propFile, (boolean)true);
        }
        catch (IOException exc) {
            SYSTEM_ERR.println("Error: " + exc);
            return null;
        }
        catch (AgentConfigException exc) {
            SYSTEM_ERR.println("Agent properties error: " + exc.getMessage());
            return null;
        }
        Properties bootProps = cfg.getBootProperties();
        if (!AgentClient.checkCanWriteToLog(bootProps)) {
            return null;
        }
        PropertyConfigurator.configure((Properties)bootProps);
        log.debug((Object)"Started initializeAgent()");
        FileWatcherThread watcherThread = FileWatcherThread.getInstance();
        LoggerSettingsFileWatcher loggingWatcher = new LoggerSettingsFileWatcher(new Sigar(), propFile);
        watcherThread.add((FileWatcher)loggingWatcher);
        watcherThread.doStart();
        AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig(cfg);
        String tokenFile = cfg.getTokenFile();
        if (generateToken) {
            String authToken;
            try {
                authToken = AgentClientUtil.getLocalAuthToken(tokenFile);
            }
            catch (FileNotFoundException exc) {
                AgentClient.printAndLog("- Unable to find the agent token file. Generating a new one ... ", LogLevel.INFO);
                try {
                    String nToken = SecurityUtil.generateRandomToken();
                    AgentClientUtil.generateNewTokenFile(tokenFile, nToken);
                    authToken = AgentClientUtil.getLocalAuthToken(tokenFile);
                }
                catch (IOException oexc) {
                    AgentClient.printAndLog("Unable to setup the preliminary agent auth tokens: " + oexc.getMessage(), oexc);
                    return null;
                }
                AgentClient.printAndLog("Done", LogLevel.INFO);
            }
            catch (IOException exc) {
                AgentClient.printAndLog("Unable to obtain the necessary authentication tokens that are required to talk to the agent: " + exc.getMessage(), exc);
                return null;
            }
            log.info((Object)("Successfully obtained token: " + authToken));
            SecureAgentConnection conn = new SecureAgentConnection(cfg.getListenIp(), cfg.getListenPort(), authToken, (KeystoreConfig)keystoreConfig, keystoreConfig.isAcceptUnverifiedCert());
            AgentClient agentClient = new AgentClient(cfg, conn);
            agentClient.updateRegistry();
            return agentClient;
        }
        long initializeStartTime = System.currentTimeMillis();
        long startupTimeout = AgentClient.getStartupTimeout(bootProps);
        while (initializeStartTime > System.currentTimeMillis() - startupTimeout) {
            try {
                String authToken = AgentClientUtil.getLocalAuthToken(tokenFile);
                SecureAgentConnection conn = new SecureAgentConnection(cfg.getListenIp(), cfg.getListenPort(), authToken, (KeystoreConfig)keystoreConfig, keystoreConfig.isAcceptUnverifiedCert());
                log.info((Object)("Successfully obtained token: " + authToken));
                AgentClient agentClient = new AgentClient(cfg, conn);
                agentClient.updateRegistry();
                return agentClient;
            }
            catch (FileNotFoundException exc) {
                AgentClient.printAndLog("- No token file found, Waiting for the agent to initialize", LogLevel.ERROR);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    AgentClient.printAndLog("The process was interrupted! Shutting down.", LogLevel.ERROR);
                    return null;
                }
            }
            catch (IOException e) {
                AgentClient.printAndLog("Unable to read the preliminary agent auth tokens, Waiting for the agent to initialize (error was: " + e.getMessage() + ")", e);
            }
        }
        AgentClient.printAndLog("Timeout waiting for token file", LogLevel.ERROR);
        return null;
    }

    public static void main(String[] args) {
        block22: {
            if (args.length == 3 && args[0].equals(SET_PROPERTY)) {
                try {
                    AgentClient.cmdSetProp(args[1], args[2]);
                }
                catch (AgentConfigException e) {
                    SYSTEM_ERR.println("Error: " + e.getMessage());
                    e.printStackTrace(SYSTEM_ERR);
                }
                return;
            }
            if (!(args.length >= 1 && (args[0].equals(PING) || args[0].equals(DIE) || args[0].equals(START) || args[0].equals(STATUS) || args[0].equals(RESTART) || args[0].equals(SETUP) || args[0].equals(SETUP_IF_NO_PROVIDER)))) {
                SYSTEM_ERR.println("Syntax: program <ping [numAttempts] | die [dieTime] | start | status | restart | setup | setup-if-no-provider | set-property >");
                return;
            }
            try {
                AgentClient client = args[0].equals(START) ? AgentClient.initializeAgent(true) : AgentClient.initializeAgent(false);
                if (client == null) {
                    log.error((Object)("Exiting unexpectedly. Arguments=" + Arrays.toString(args)));
                    return;
                }
                log.debug((Object)"Passed initializeAgent method");
                if (args[0].equals(PING)) {
                    int nWait = args.length == 3 ? AgentClient.getUseTime(args[2]) : 1;
                    client.cmdPing(nWait);
                    break block22;
                }
                if (args[0].equals(DIE)) {
                    int nWait = args.length == 2 ? AgentClient.getUseTime(args[1]) : 1;
                    AgentClient.printAndLog("Stopping agent ... ", LogLevel.INFO);
                    try {
                        client.cmdDie(nWait);
                        AgentClient.printAndLog("Success -- agent is stopped!", LogLevel.INFO);
                    }
                    catch (Exception exc) {
                        AgentClient.printAndLog("Failed to stop agent: " + exc.getMessage(), exc);
                    }
                    break block22;
                }
                if (args[0].equals(START)) {
                    int errVal = client.cmdStart(false);
                    log.debug((Object)("Finished cmdStart method with value " + errVal));
                    if (errVal == -42) {
                        errVal = 0;
                        client.cmdSetupIfNoProvider();
                    }
                    break block22;
                }
                if (args[0].equals(STATUS)) {
                    client.cmdStatus();
                    break block22;
                }
                if (args[0].equals(SETUP)) {
                    client.cmdSetup();
                    break block22;
                }
                if (args[0].equals(SETUP_IF_NO_PROVIDER)) {
                    client.cmdSetupIfNoProvider();
                    break block22;
                }
                if (args[0].equals(RESTART)) {
                    client.cmdRestart();
                    break block22;
                }
                throw new IllegalStateException("Unhandled condition");
            }
            catch (AskQuestionsUtil.AutoQuestionException exc) {
                AgentClient.printAndLog("Unable to complete automatic agent setup. " + exc.getMessage(), exc);
            }
            catch (AgentInvokeException exc) {
                AgentClient.printAndLog("Error invoking the agent: " + exc.getMessage(), (Exception)((Object)exc));
            }
            catch (AgentConnectionException exc) {
                AgentClient.printAndLog("Error contacting the agent: " + exc.getMessage(), (Exception)((Object)exc));
            }
            catch (AgentRemoteException exc) {
                AgentClient.printAndLog("Error executing the remote method: " + exc.getMessage(), (Exception)((Object)exc));
            }
            catch (IllegalStateException exc) {
                AgentClient.printAndLog("The agent is in an illegal state: " + exc.getMessage(), exc);
            }
            catch (Exception exc) {
                AgentClient.printAndLog("Error: " + exc.getMessage(), exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRegistry() {
        if (!OperatingSystem.IS_WIN32) {
            return;
        }
        RegistryKey subKey = null;
        try {
            subKey = RegistryKey.LocalMachine.openSubKey(EP_OPS_SERVICE_IMAGE_PATH_REGISTRY_KEY);
            String imagePathValue = subKey.getStringValue("ImagePath").trim();
            subKey.close();
            if (imagePathValue == null) {
                return;
            }
            int indexOfHqJavaHome = imagePathValue.indexOf("set.HQ_JAVA_HOME");
            log.debug((Object)("got: " + imagePathValue + " from registry key: " + EP_OPS_SERVICE_IMAGE_PATH_REGISTRY_KEY));
            if (indexOfHqJavaHome == -1) {
                return;
            }
            String newImagePath = this.getNewImagePath(imagePathValue, indexOfHqJavaHome);
            if (imagePathValue.equals(newImagePath)) {
                return;
            }
            log.info((Object)("got: " + imagePathValue + " \n replacing now to: " + newImagePath + " as the new ImagePath in the registry"));
            String command = this.getCommandWithHqJavaHome(newImagePath);
            log.info((Object)("about to run a command to update the registry: " + command));
            Process exec = Runtime.getRuntime().exec(command);
            int exitValue = exec.waitFor();
            if (exitValue != 0) {
                String errorString = IOUtils.toString((InputStream)exec.getErrorStream());
                log.error((Object)("Error running command:" + command + "\n The Error code is:" + exitValue + " The error string returned is:" + errorString));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading or updating the registry", (Throwable)e);
        }
        finally {
            if (subKey != null) {
                subKey.close();
            }
        }
    }

    private String getNewImagePath(String imagePathValue, int indexOfHqJavaHome) {
        return imagePathValue.substring(0, indexOfHqJavaHome).trim();
    }

    private String getCommandWithHqJavaHome(String newImagePath) {
        String command = "REG ADD \"HKLM\\SYSTEM\\CurrentControlSet\\Services\\End Point Operations Management Agent\" /v ImagePath /t REG_EXPAND_SZ /d \"" + newImagePath + "\"" + " /f";
        return command;
    }

    private static boolean checkCanWriteToLog(Properties props) {
        String logFileName = props.getProperty(PROP_LOGFILE);
        if (logFileName == null) {
            SYSTEM_ERR.println("agent.logFile is not set. \nCannot start the agent.");
            return false;
        }
        File logFile = new File(logFileName);
        File logDir = logFile.getParentFile();
        if (!logDir.exists() && !logDir.mkdirs()) {
            SYSTEM_ERR.println("Log directory does not exist and could not be created: " + logDir.getAbsolutePath() + "\nCannot start HQ agent.");
            return false;
        }
        if (!logDir.canWrite()) {
            SYSTEM_ERR.println("Cannot write to the log directory: " + logDir.getAbsolutePath() + "\nEnsure this directory is owned by the user '" + System.getProperty("user.name") + "' and is " + "not a read-only directory." + "\nCannot start the agent.");
            return false;
        }
        if (logFile.exists() && !logFile.canWrite()) {
            SYSTEM_ERR.println("Cannot write to the log file: " + logFile.getAbsolutePath() + "\nEnsure this file is owned by the user '" + System.getProperty("user.name") + "' and is " + "not a read-only file." + "\nCannot start the agent.");
            return false;
        }
        return true;
    }

    private void setPlatformVmUniqueIdentifierInGuestinfo(String agentToken) {
        VMwareGuestInfo.setGuestInfoValue((String)VM_UNIQUE_IDENTIFIER_ENV_KEY_NAME, (String)agentToken);
    }

    private static void printAndLog(String message, LogLevel level) {
        PrintStream stream = level.equals((Object)LogLevel.ERROR) ? SYSTEM_ERR : SYSTEM_OUT;
        stream.println(message);
        switch (level) {
            case INFO: {
                log.info((Object)message);
                break;
            }
            case ERROR: {
                log.error((Object)message);
                break;
            }
            case DEBUG: {
                log.debug((Object)message);
                break;
            }
            case WARN: {
                log.warn((Object)message);
            }
        }
    }

    private static void printAndLog(String message, Exception exc) {
        SYSTEM_ERR.println(message);
        log.error((Object)message, (Throwable)exc);
    }

    static {
        log = LogFactory.getLog(AgentClient.class);
    }

    private static class LoggerSettingsFileWatcher
    extends FileWatcher {
        private final String propFile;

        public LoggerSettingsFileWatcher(Sigar sigar, String propertiesFile) {
            super(sigar);
            this.propFile = propertiesFile;
            File file = AgentConfig.getPropertyFile((String)this.propFile);
            try {
                this.add(file);
            }
            catch (SigarException e) {
                SYSTEM_OUT.println("The log level is set to default. If you customized the log level, you must restart the agent after the registration process finishes in order to apply the changes.");
            }
            this.setInterval(60000L);
        }

        public void onChange(FileInfo fileInfo) {
            try {
                SYSTEM_OUT.println("A change has been detected in " + fileInfo.getName() + ", Reloading the logging configuration.");
                PropertyConfigurator.configure((Properties)AgentConfig.getProperties((String)this.propFile));
            }
            catch (AgentConfigException e) {
                SYSTEM_ERR.println("Error reloading the logging configuration: " + e.getMessage() + ".");
                e.printStackTrace(SYSTEM_ERR);
            }
        }
    }

    private static enum LogLevel {
        INFO,
        WARN,
        ERROR,
        DEBUG;

    }
}

