/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.roo.file.monitor.polling;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.springframework.roo.file.monitor.DirectoryMonitoringRequest;
import org.springframework.roo.file.monitor.MonitoringRequest;
import org.springframework.roo.file.monitor.NotifiableFileMonitorService;
import org.springframework.roo.file.monitor.event.FileDetails;
import org.springframework.roo.file.monitor.event.FileEvent;
import org.springframework.roo.file.monitor.event.FileEventListener;
import org.springframework.roo.file.monitor.event.FileOperation;
import org.springframework.roo.support.lifecycle.ScopeDevelopment;
import org.springframework.roo.support.logging.HandlerUtils;
import org.springframework.roo.support.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScopeDevelopment
public class PollingFileMonitorService
implements NotifiableFileMonitorService {
    private static final Logger logger = HandlerUtils.getLogger(PollingFileMonitorService.class);
    protected Set<FileEventListener> fileEventListeners = new CopyOnWriteArraySet<FileEventListener>();
    private Set<MonitoringRequest> requests = new CopyOnWriteArraySet<MonitoringRequest>();
    private Map<MonitoringRequest, Map<File, Long>> priorExecution = new WeakHashMap<MonitoringRequest, Map<File, Long>>();
    private Set<String> notifyChanged = new HashSet<String>();
    private Set<String> notifyCreated = new HashSet<String>();
    private Set<String> notifyDeleted = new HashSet<String>();
    private Set<MonitoringRequest> notifiedFailingRequests = new CopyOnWriteArraySet<MonitoringRequest>();
    private Boolean lock = new Boolean(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileDetails> getMonitored() {
        Boolean bl = this.lock;
        synchronized (bl) {
            ArrayList<FileDetails> monitored = new ArrayList<FileDetails>();
            if (this.requests.size() == 0) {
                return monitored;
            }
            for (MonitoringRequest request : this.requests) {
                if (!this.priorExecution.containsKey(request)) continue;
                Map<File, Long> priorFiles = this.priorExecution.get(request);
                for (File priorFile : priorFiles.keySet()) {
                    monitored.add(new FileDetails(priorFile, priorFiles.get(priorFile)));
                }
            }
            return monitored;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Boolean bl = this.lock;
        synchronized (bl) {
            return this.notifyChanged.size() > 0 || this.notifyCreated.size() > 0 || this.notifyDeleted.size() > 0;
        }
    }

    private boolean isWithin(MonitoringRequest request, String filePath) {
        DirectoryMonitoringRequest dmr;
        String requestCanonicalPath;
        try {
            requestCanonicalPath = request.getFile().getCanonicalPath();
        }
        catch (IOException e) {
            return false;
        }
        return !(request instanceof DirectoryMonitoringRequest ? ((dmr = (DirectoryMonitoringRequest)request).isWatchSubtree() ? !filePath.startsWith(requestCanonicalPath) : !FileDetails.matchesAntPath((String)(requestCanonicalPath + File.separator + "*"), (String)filePath)) : !requestCanonicalPath.equals(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scanNotified() {
        Boolean bl = this.lock;
        synchronized (bl) {
            if (this.requests.size() == 0 || !this.isDirty()) {
                return 0;
            }
            int changes = 0;
            for (MonitoringRequest request : this.requests) {
                ArrayList<FileEvent> eventsToPublish = new ArrayList<FileEvent>();
                if (this.priorExecution.containsKey(request)) {
                    File thisFile;
                    Map<File, Long> priorFiles = this.priorExecution.get(request);
                    HashSet<String> toRemove = new HashSet<String>();
                    for (String filePath : this.notifyChanged) {
                        if (!this.isWithin(request, filePath)) continue;
                        toRemove.add(filePath);
                        thisFile = new File(filePath);
                        if (!thisFile.exists()) continue;
                        eventsToPublish.add(new FileEvent(new FileDetails(thisFile, Long.valueOf(thisFile.lastModified())), FileOperation.UPDATED, null));
                        priorFiles.put(thisFile, thisFile.lastModified());
                        if (!this.notifyCreated.contains(filePath)) continue;
                        this.notifyCreated.remove(filePath);
                    }
                    for (String remove : toRemove) {
                        this.notifyChanged.remove(remove);
                    }
                    toRemove = new HashSet();
                    for (String filePath : this.notifyCreated) {
                        if (!this.isWithin(request, filePath)) continue;
                        toRemove.add(filePath);
                        thisFile = new File(filePath);
                        if (!thisFile.exists()) continue;
                        eventsToPublish.add(new FileEvent(new FileDetails(thisFile, Long.valueOf(thisFile.lastModified())), FileOperation.CREATED, null));
                        priorFiles.put(thisFile, thisFile.lastModified());
                    }
                    for (String remove : toRemove) {
                        this.notifyCreated.remove(remove);
                    }
                    toRemove = new HashSet();
                    for (String filePath : this.notifyDeleted) {
                        if (!this.isWithin(request, filePath)) continue;
                        toRemove.add(filePath);
                        thisFile = new File(filePath);
                        if (thisFile.exists()) continue;
                        eventsToPublish.add(new FileEvent(new FileDetails(thisFile, null), FileOperation.DELETED, null));
                        priorFiles.remove(thisFile);
                    }
                    for (String remove : toRemove) {
                        this.notifyDeleted.remove(remove);
                    }
                }
                this.publish(eventsToPublish);
                changes += eventsToPublish.size();
            }
            return changes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scanAll() {
        Boolean bl = this.lock;
        synchronized (bl) {
            if (this.requests.size() == 0) {
                return 0;
            }
            int changes = 0;
            for (MonitoringRequest request : this.requests) {
                boolean includeSubtree = false;
                if (request instanceof DirectoryMonitoringRequest) {
                    includeSubtree = ((DirectoryMonitoringRequest)request).isWatchSubtree();
                }
                if (!request.getFile().exists()) {
                    if (this.notifiedFailingRequests.contains(request)) continue;
                    logger.warning("Cannot monitor non-existent path '" + request.getFile() + "'");
                    this.notifiedFailingRequests.add(request);
                    continue;
                }
                if (this.notifiedFailingRequests.contains(request)) {
                    this.notifiedFailingRequests.remove(request);
                }
                HashMap<File, Long> currentExecution = new HashMap<File, Long>();
                this.computeEntries(currentExecution, request.getFile(), includeSubtree);
                ArrayList<FileEvent> eventsToPublish = new ArrayList<FileEvent>();
                if (this.priorExecution.containsKey(request)) {
                    Map<File, Long> priorFiles = this.priorExecution.get(request);
                    for (File thisFile : currentExecution.keySet()) {
                        Long previousTimestamp;
                        if (!priorFiles.containsKey(thisFile)) {
                            eventsToPublish.add(new FileEvent(new FileDetails(thisFile, (Long)currentExecution.get(thisFile)), FileOperation.CREATED, null));
                            try {
                                this.notifyCreated.remove(thisFile.getCanonicalPath());
                            }
                            catch (IOException ignored) {}
                            continue;
                        }
                        Long currentTimestamp = (Long)currentExecution.get(thisFile);
                        if (currentTimestamp.equals(previousTimestamp = priorFiles.get(thisFile))) continue;
                        eventsToPublish.add(new FileEvent(new FileDetails(thisFile, (Long)currentExecution.get(thisFile)), FileOperation.UPDATED, null));
                        try {
                            this.notifyChanged.remove(thisFile.getCanonicalPath());
                        }
                        catch (IOException ignored) {}
                    }
                    priorFiles.keySet().removeAll(currentExecution.keySet());
                    for (File deletedFile : priorFiles.keySet()) {
                        eventsToPublish.add(new FileEvent(new FileDetails(deletedFile, priorFiles.get(deletedFile)), FileOperation.DELETED, null));
                        try {
                            this.notifyDeleted.remove(deletedFile.getCanonicalPath());
                        }
                        catch (IOException ignored) {}
                    }
                } else {
                    for (File thisFile : currentExecution.keySet()) {
                        eventsToPublish.add(new FileEvent(new FileDetails(thisFile, (Long)currentExecution.get(thisFile)), FileOperation.MONITORING_START, null));
                    }
                }
                this.priorExecution.put(request, currentExecution);
                this.notifyCreated.clear();
                this.notifyDeleted.clear();
                for (String canonicalPath : this.notifyChanged) {
                    File file = new File(canonicalPath);
                    eventsToPublish.add(new FileEvent(new FileDetails(file, Long.valueOf(file.lastModified())), FileOperation.UPDATED, null));
                }
                this.notifyChanged.clear();
                this.publish(eventsToPublish);
                changes += eventsToPublish.size();
            }
            return changes;
        }
    }

    private void publish(List<FileEvent> eventsToPublish) {
        if (eventsToPublish.size() > 0) {
            for (FileEvent event : eventsToPublish) {
                for (FileEventListener listener : this.fileEventListeners) {
                    listener.onFileEvent(event);
                }
            }
        }
    }

    private void computeEntries(Map<File, Long> map, File currentFile, boolean includeSubtree) {
        Assert.notNull(map, (String)"Map required");
        Assert.notNull((Object)currentFile, (String)"Current file is required");
        if (!currentFile.exists() || currentFile.getName().length() > 1 && currentFile.getName().startsWith(".")) {
            return;
        }
        map.put(currentFile, currentFile.lastModified());
        if (currentFile.isDirectory()) {
            File[] files = currentFile.listFiles();
            if (files == null || files.length == 0) {
                return;
            }
            for (File file : files) {
                if (!file.isFile() && !includeSubtree) continue;
                this.computeEntries(map, file, includeSubtree);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(MonitoringRequest request) {
        Boolean bl = this.lock;
        synchronized (bl) {
            DirectoryMonitoringRequest dmr;
            Assert.notNull((Object)request, (String)"MonitoringRequest required");
            if (request instanceof DirectoryMonitoringRequest && (dmr = (DirectoryMonitoringRequest)request).isWatchSubtree()) {
                for (MonitoringRequest existing : this.requests) {
                    String newDmrPath;
                    String existingDmrPath;
                    DirectoryMonitoringRequest existingDmr;
                    if (!(existing instanceof DirectoryMonitoringRequest) || !(existingDmr = (DirectoryMonitoringRequest)existing).isWatchSubtree()) continue;
                    try {
                        existingDmrPath = existingDmr.getFile().getCanonicalPath();
                        newDmrPath = dmr.getFile().getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException("Unable to resolve canonical name", ioe);
                    }
                    if (newDmrPath.startsWith(existingDmrPath)) {
                        return false;
                    }
                    if (!existingDmrPath.startsWith(newDmrPath)) continue;
                    this.remove(existing);
                }
            }
            boolean result = this.requests.add(request);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(MonitoringRequest request) {
        Boolean bl = this.lock;
        synchronized (bl) {
            Assert.notNull((Object)request, (String)"MonitoringRequest required");
            if (this.priorExecution.containsKey(request)) {
                ArrayList<FileEvent> eventsToPublish = new ArrayList<FileEvent>();
                Map<File, Long> priorFiles = this.priorExecution.get(request);
                for (File thisFile : priorFiles.keySet()) {
                    eventsToPublish.add(new FileEvent(new FileDetails(thisFile, priorFiles.get(thisFile)), FileOperation.MONITORING_FINISH, null));
                }
                this.publish(eventsToPublish);
            }
            this.priorExecution.remove(request);
            boolean result = this.requests.remove(request);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileEventListener(FileEventListener fileEventListener) {
        Boolean bl = this.lock;
        synchronized (bl) {
            Assert.notNull((Object)fileEventListener, (String)"File event listener required");
            this.fileEventListeners.add(fileEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileEventListener(FileEventListener fileEventListener) {
        Boolean bl = this.lock;
        synchronized (bl) {
            Assert.notNull((Object)fileEventListener, (String)"File event listener required");
            this.fileEventListeners.remove(fileEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<FileDetails> findMatchingAntPath(String antPath) {
        Boolean bl = this.lock;
        synchronized (bl) {
            Assert.hasText((String)antPath, (String)"Ant path required");
            TreeSet<FileDetails> result = new TreeSet<FileDetails>();
            if (this.requests.size() == 0) {
                return result;
            }
            for (MonitoringRequest request : this.requests) {
                if (!this.priorExecution.containsKey(request)) continue;
                Map<File, Long> priorFiles = this.priorExecution.get(request);
                for (File priorFile : priorFiles.keySet()) {
                    FileDetails fd = new FileDetails(priorFile, priorFiles.get(priorFile));
                    if (!fd.matchesAntPath(antPath)) continue;
                    result.add(fd);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChanged(String fileCanoncialPath) {
        Boolean bl = this.lock;
        synchronized (bl) {
            this.notifyChanged.add(fileCanoncialPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCreated(String fileCanoncialPath) {
        Boolean bl = this.lock;
        synchronized (bl) {
            this.notifyCreated.add(fileCanoncialPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDeleted(String fileCanoncialPath) {
        Boolean bl = this.lock;
        synchronized (bl) {
            this.notifyDeleted.add(fileCanoncialPath);
        }
    }
}

