/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.plugin.system.FileControlPlugin;
import org.hyperic.hq.plugin.system.FileServiceLogPlugin;
import org.hyperic.hq.plugin.system.FileSystemDetector;
import org.hyperic.hq.plugin.system.NetifDetector;
import org.hyperic.hq.plugin.system.ProcessorDetector;
import org.hyperic.hq.plugin.system.SigarPlatformDetector;
import org.hyperic.hq.plugin.system.SystemLiveDataPlugin;
import org.hyperic.hq.plugin.system.SystemMeasurementPlugin;
import org.hyperic.hq.plugin.system.UnixLogTrackPlugin;
import org.hyperic.hq.plugin.system.WindowsDetector;
import org.hyperic.hq.plugin.system.WindowsLogTrackPlugin;
import org.hyperic.hq.product.ExecutableMeasurementPlugin;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.LogFileTailPlugin;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.ObjectModel;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProcessControlPlugin;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.hq.product.TypeBuilder;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.Win32ControlPlugin;
import org.hyperic.hq.product.Win32EventLogTrackPlugin;
import org.hyperic.hq.product.Win32MeasurementPlugin;
import org.hyperic.sigar.FileWatcherThread;
import org.hyperic.sigar.ProcFileMirror;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.SchemaBuilder;
import org.hyperic.util.config.StringConfigOption;

public class SystemPlugin
extends ProductPlugin {
    protected static final int DEPLOYMENT_ORDER = 0;
    public static final String NAME = "system";
    public static final String FILE_SERVER_NAME = "FileServer";
    public static final String NETWORK_SERVER_NAME = "NetworkServer";
    public static final String PROCESS_SERVER_NAME = "ProcessServer";
    public static final String WINDOWS_SERVER_NAME = "WindowsServer";
    public static final String FS_NAME = "Mount";
    public static final String PHYSICAL_DISK_NAME = "Physical Disk";
    public static final String LOGICAL_DISK_NAME = "Logical Disk";
    public static final String BLOCK_DEVICE_NAME = "Block Device";
    public static final String FILE_NAME = "File";
    public static final String SCRIPT_NAME = "Script";
    public static final String DIR_NAME = "Directory";
    public static final String DIR_TREE_NAME = "Directory Tree";
    public static final String NETIF_NAME = "Interface";
    public static final String CPU_NAME = "CPU";
    public static final String PROCESS_NAME = "Process";
    public static final String MPROCESS_NAME = "MultiProcess";
    public static final String SVC_NAME = "Windows Service";
    protected static Log log = LogFactory.getLog((String)"SystemPlugin");
    public static final String[] FILE_SERVICES = new String[]{"Mount", "Physical Disk", "Logical Disk", "Block Device", "File", "Directory", "Directory Tree"};
    public static final String[] NETWORK_SERVICES = new String[]{"Interface"};
    public static final String[] PROCESS_SERVICES = new String[]{"CPU", "Process", "MultiProcess"};
    public static final String FILE_MOUNT_SERVICE = TypeBuilder.composeServiceTypeName((String)"FileServer", (String)"Mount");
    public static final String PHYSICAL_DISK_SERVICE = TypeBuilder.composeServiceTypeName((String)"FileServer", (String)"Physical Disk");
    public static final String LOGICAL_DISK_SERVICE = TypeBuilder.composeServiceTypeName((String)"FileServer", (String)"Logical Disk");
    public static final String BLOCK_DEVICE_SERVICE = TypeBuilder.composeServiceTypeName((String)"FileServer", (String)"Block Device");
    public static final String NETWORK_INTERFACE_SERVICE = TypeBuilder.composeServiceTypeName((String)"NetworkServer", (String)"Interface");
    public static final String SCRIPT_SERVICE = "Script";
    public static final String FILE_SERVICE = TypeBuilder.composeServiceTypeName((String)"FileServer", (String)"File");
    public static final String DIR_SERVICE = TypeBuilder.composeServiceTypeName((String)"FileServer", (String)"Directory");
    public static final String DIR_TREE_SERVICE = TypeBuilder.composeServiceTypeName((String)"FileServer", (String)"Directory Tree");
    public static final String PROP_FS = "mount";
    public static final String PROP_PATH = "path";
    public static final String PROP_NETIF = "interface";
    public static final String PROP_CPU = "cpu";
    public static final String PROP_ENABLE_USER_AI = "autodiscover.users";
    public static final String PROP_SVC = "service_name";
    public static final String PROP_ARGS = "args";
    public static final String[] STANDARD_SERVICES = new String[]{"MultiProcess", "Windows Service", "Script"};
    private final Collection<String> standardServicesList = Arrays.asList(STANDARD_SERVICES);
    private static final String[][] PLAT_CPROPS = new String[][]{{"arch", "Architecture"}, {"version", "OS Version"}, {"vendor", "Vendor"}, {"vendorVersion", "Vendor Version"}, {"ram", "RAM"}, {"cpuSpeed", "CPU Speed"}, {"ip", "IP Address"}, {"ipv6", "IPv6 Address"}, {"primaryDNS", "Primary DNS"}, {"secondaryDNS", "Secondary DNS"}, {"defaultGateway", "Default Gateway"}, {"MOID", "MOID"}, {"VCUUID", "VCenter UUID"}};
    private static final String[][] NETIF_CPROPS = new String[][]{{"mtu", "Maximum Transmission Unit"}, {"flags", "Interface Flags"}, {"mac", "MAC Address"}, {"address", "IP Address"}, {"address6", "IPv6 Address"}, {"address6Scope", "IPv6 Address Scope"}, {"netmask", "Netmask"}, {"broadcast", "Broadcast Address"}};
    private static final String[][] FILE_CPROPS = new String[][]{{"md5", "Message Digest"}, {"fs", "File System"}, {"permissions", "Permissions"}, {"user", "User"}, {"group", "Group"}};
    private static final String[][] PROCESS_CPROPS = new String[][]{{"user", "User"}, {"group", "Group"}, {"exe", "Executable"}, {"cwd", "Current Working Directory"}};
    private static final String[][] SVC_CPROPS = new String[][]{{"path", "Path to executable"}, {"startupType", "Startup type"}, {"displayName", "Display name"}};

    public SystemPlugin() {
        this.setName(NAME);
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        String prop = "sigar.mirror.procnet";
        String enable = manager.getProperty("sigar.mirror.procnet");
        this.getLog().debug((Object)("sigar.mirror.procnet=" + enable));
        if (!"true".equals(enable)) {
            return;
        }
        String dir = manager.getProperty(AgentConfig.PROP_TMPDIR[0]);
        ProcFileMirror mirror = null;
        String[] procnet = new String[]{"/proc/net/tcp", "/proc/net/tcp6"};
        for (int i = 0; i < procnet.length; ++i) {
            File file = new File(procnet[i]);
            if (!file.exists()) continue;
            if (mirror == null) {
                mirror = new ProcFileMirror(new Sigar(), dir);
            }
            try {
                mirror.add(file);
                this.getLog().debug((Object)("mirroring " + procnet[i]));
                continue;
            }
            catch (SigarException e) {
                this.getLog().warn((Object)e.getMessage());
            }
        }
        if (mirror != null) {
            FileWatcherThread.getInstance().add(mirror);
            FileWatcherThread.getInstance().doStart();
        }
    }

    public GenericPlugin getPlugin(String type, TypeInfo info) {
        GenericPlugin res = this.aglyGetPlugin(type, info);
        log.info((Object)("[getPlugin] type='" + type + "' info='" + info.getName() + "' res=" + res));
        return res;
    }

    public GenericPlugin aglyGetPlugin(String type, TypeInfo info) {
        if (type.equals("measurement")) {
            if (info.getName().equals(SVC_NAME)) {
                return new Win32MeasurementPlugin();
            }
            if (info.getType() == 2 && ((ServerTypeInfo)info).isVirtual()) {
                return null;
            }
            if (info.getName().equals("Script")) {
                return new ExecutableMeasurementPlugin();
            }
            return new SystemMeasurementPlugin();
        }
        if (type.equals("autoinventory")) {
            switch (info.getType()) {
                case 1: {
                    return new SigarPlatformDetector(this.hasPlatformControlActions());
                }
                case 2: {
                    if (info.getName().equals(FILE_SERVER_NAME)) {
                        return new FileSystemDetector();
                    }
                    if (info.getName().equals(NETWORK_SERVER_NAME)) {
                        return new NetifDetector();
                    }
                    if (info.getName().equals(PROCESS_SERVER_NAME)) {
                        return new ProcessorDetector();
                    }
                    if (!info.getName().equals(WINDOWS_SERVER_NAME)) break;
                    return new WindowsDetector();
                }
            }
        } else if (type.equals("control")) {
            if (info.isService(FILE_NAME)) {
                return new FileControlPlugin();
            }
            if (info.getName().equals(SVC_NAME)) {
                return new Win32ControlPlugin();
            }
            if (info.getName().equals(PROCESS_NAME)) {
                return new ProcessControlPlugin();
            }
        } else if (type.equals("log_track")) {
            if (info.getType() == 1) {
                if (info.isWin32Platform()) {
                    return new WindowsLogTrackPlugin();
                }
                return new UnixLogTrackPlugin();
            }
            if (info.getName().equals(SVC_NAME)) {
                return new Win32EventLogTrackPlugin();
            }
            if (info.isService(FILE_NAME)) {
                return new FileServiceLogPlugin();
            }
            if (info.getName().equals(PROCESS_NAME)) {
                return new LogFileTailPlugin();
            }
            if (info.getName().equals("Script") || info.isService(FS_NAME)) {
                return new LogTrackPlugin();
            }
        } else if (type.equals("livedata") && info.getType() == 1) {
            return new SystemLiveDataPlugin();
        }
        return null;
    }

    protected boolean hasPlatformControlActions() {
        return false;
    }

    public ConfigSchema getCustomPropertiesSchema(String name) {
        String[][] cprops;
        ConfigSchema schema = new ConfigSchema();
        if (SigarPlatformDetector.isSupportedPlatform((String)name)) {
            cprops = PLAT_CPROPS;
        } else if (name.equals(NETWORK_INTERFACE_SERVICE)) {
            cprops = NETIF_CPROPS;
        } else if (name.equals(FILE_SERVICE) || name.equals("Script") || name.equals(DIR_SERVICE)) {
            cprops = FILE_CPROPS;
        } else if (name.equals(PROCESS_NAME)) {
            cprops = PROCESS_CPROPS;
        } else if (name.equals(SVC_NAME)) {
            cprops = SVC_CPROPS;
        } else {
            return schema;
        }
        for (int i = 0; i < cprops.length; ++i) {
            StringConfigOption opt = new StringConfigOption(cprops[i][0], cprops[i][1]);
            schema.addOption((ConfigOption)opt);
        }
        return schema;
    }

    private void addWindowsService(TypeBuilder types) {
        ServerTypeInfo server = new ServerTypeInfo(WINDOWS_SERVER_NAME, WINDOWS_SERVER_NAME, "x");
        server.setValidPlatformTypes(TypeBuilder.WIN32_PLATFORM_NAMES);
        server.setVirtual(true);
        ServiceTypeInfo service = new ServiceTypeInfo(SVC_NAME, SVC_NAME, server);
        service.setModel(this.getModel(SVC_NAME));
        types.add((TypeInfo)server);
        types.add((TypeInfo)service);
    }

    private void addProcessServices(TypeBuilder types) {
        ServerTypeInfo server = new ServerTypeInfo(PROCESS_SERVER_NAME, PROCESS_SERVER_NAME, "x");
        server.setVirtual(true);
        types.add((TypeInfo)server);
        for (int i = 0; i < PROCESS_SERVICES.length; ++i) {
            String name = PROCESS_SERVICES[i];
            ServiceTypeInfo service = new ServiceTypeInfo(name, name, server);
            service.setModel(this.getModel(name));
            types.add((TypeInfo)service);
        }
    }

    public TypeInfo[] getTypes() {
        TypeBuilder types = new TypeBuilder();
        String[] platforms = TypeBuilder.ALL_PLATFORM_NAMES;
        for (int i = 0; i < platforms.length; ++i) {
            types.addPlatform(platforms[i]);
        }
        ServerTypeInfo server = types.addServer(FILE_SERVER_NAME, "x");
        server.setVirtual(true);
        server.setDescription("Platform File Server");
        for (int i = 0; i < FILE_SERVICES.length; ++i) {
            String name = FILE_SERVICES[i];
            types.addService(server, name, this.getModel(name));
        }
        ServiceTypeInfo script = new ServiceTypeInfo("Script", "Script", server);
        script.setModel(this.getModel("Script"));
        types.add((TypeInfo)script);
        server = types.addServer(NETWORK_SERVER_NAME, "x");
        server.setVirtual(true);
        server.setDescription("Platform Network Server");
        for (int i = 0; i < NETWORK_SERVICES.length; ++i) {
            String name = NETWORK_SERVICES[i];
            types.addService(server, name, this.getModel(name));
        }
        this.addProcessServices(types);
        this.addWindowsService(types);
        return types.getTypes();
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        SchemaBuilder schema = new SchemaBuilder(config);
        log.debug((Object)("[getConfigSchema] info=" + info));
        switch (info.getType()) {
            case 1: {
                break;
            }
            case 3: {
                if (info.isService(FS_NAME)) {
                    schema.add(PROP_FS, "File System Mount", "/");
                    break;
                }
                if (info.isService(PHYSICAL_DISK_NAME)) {
                    schema.add("name", "Instace Name", "");
                    break;
                }
                if (info.isService(LOGICAL_DISK_NAME)) {
                    schema.add("name", "Instace Name", "");
                    break;
                }
                if (info.isService(BLOCK_DEVICE_NAME)) {
                    schema.add("name", "Instace Name", "");
                    break;
                }
                if (info.isService(FILE_NAME)) {
                    schema.add(PROP_PATH, "Path to File", "../../log/agent.log");
                    break;
                }
                if (info.isService(DIR_NAME) || info.isService(DIR_TREE_NAME)) {
                    schema.add(PROP_PATH, "Path to Directory", "data");
                    break;
                }
                if (info.isService(NETIF_NAME)) {
                    schema.add(PROP_NETIF, "Network Interface", "eth0");
                    break;
                }
                if (info.getName().equals(CPU_NAME)) {
                    schema.add(PROP_CPU, CPU_NAME, "0");
                    break;
                }
                if (info.getName().equals(PROCESS_NAME)) {
                    schema.add("process.query", "Process Query", "State.Name.eq=java");
                    break;
                }
                if (info.getName().equals(MPROCESS_NAME)) {
                    ConfigOption option = schema.add("process.query", "Multi-process query. For example: State.Name.eq=httpd", "State.Name.eq=");
                    option.setAdvanced(Boolean.valueOf(false));
                    break;
                }
                if (info.getName().equals(SVC_NAME)) {
                    schema.add(PROP_SVC, "Windows Service Name", "");
                    break;
                }
                if (!info.getName().equals("Script")) break;
                schema.add("prefix", "Prefix arguments to script", "").setOptional(true);
                ConfigOption option = schema.add(PROP_PATH, "Script path and name", "/path/to/script");
                option.setAdvanced(Boolean.valueOf(false));
                schema.add(PROP_ARGS, "Script Arguments", "").setOptional(true);
                schema.add("timeout", "Script Timeout (in seconds)", 120);
            }
        }
        return schema.getSchema();
    }

    protected int getDeploymentOrder() {
        return 0;
    }

    private ObjectModel getModel(String serviceName) {
        if (this.standardServicesList.contains(serviceName)) {
            return ObjectModel.STANDARD;
        }
        return ObjectModel.LIGHTWEIGHT;
    }
}

