/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import java.util.List;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;

public abstract class PlatformServiceDetector
extends ServerDetector
implements AutoServerDetector {
    @Override
    protected abstract List discoverServices(ConfigResponse var1) throws PluginException;

    protected ServerResource getServer(ConfigResponse config) {
        ServerResource server = this.createServerResource("/");
        String fqdn = config.getValue("platform.fqdn");
        String type = config.getValue("platform.type");
        server.setName(fqdn + " " + type);
        server.setIdentifier(server.getName());
        server.setProductConfig();
        server.setMeasurementConfig();
        this.getLog().debug((Object)("PlatformServiceDetector created server=" + server.getName()));
        return server;
    }

    protected String getServiceTypeName(String type) {
        return this.getTypeInfo().getPlatformTypes()[0] + " " + type;
    }

    @Override
    protected ServiceResource createServiceResource(String type) {
        ServiceResource service = new ServiceResource();
        service.setType(this.getServiceTypeName(type));
        return service;
    }

    @Override
    public List getServerResources(ConfigResponse config) {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        servers.add(this.getServer(config));
        return servers;
    }
}

