/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.shared.lather;

import org.hyperic.hq.autoinventory.ScanMethodConfig;
import org.hyperic.lather.LatherKeyNotFoundException;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;

public class ScanMethodConfigValue
extends LatherValue {
    private static final String PROP_METHODCLASS = "methodClass";
    private static final String PROP_CONFIG = "config";

    public ScanMethodConfigValue() {
    }

    public ScanMethodConfigValue(ScanMethodConfig cfg) throws LatherRemoteException {
        this.setMethodClass(cfg.getMethodClass());
        try {
            this.setConfig(cfg.getConfig());
        }
        catch (LatherRemoteException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new LatherRemoteException("Error encoding config: " + exc.getMessage());
        }
    }

    public void setMethodClass(String methodClass) {
        this.setStringValue(PROP_METHODCLASS, methodClass);
    }

    public String getMethodClass() {
        return this.getStringValue(PROP_METHODCLASS);
    }

    public void setConfig(ConfigResponse config) throws LatherRemoteException {
        byte[] data;
        try {
            data = config.encode();
        }
        catch (Exception exc) {
            throw new LatherRemoteException("Error encoding configuration: " + exc.getMessage());
        }
        this.setByteAValue(PROP_CONFIG, data);
    }

    public ConfigResponse getConfig() throws LatherRemoteException {
        try {
            return ConfigResponse.decode((byte[])this.getByteAValue(PROP_CONFIG));
        }
        catch (EncodingException exc) {
            throw new LatherRemoteException("Error decoding configuration: " + exc.getMessage());
        }
    }

    public void validate() throws LatherRemoteException {
        try {
            this.getMethodClass();
            this.getConfig();
        }
        catch (LatherKeyNotFoundException exc) {
            throw new LatherRemoteException("All values not set");
        }
    }
}

