/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.units;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.hyperic.util.units.FormatSpecifics;
import org.hyperic.util.units.FormattedNumber;
import org.hyperic.util.units.ParseSpecifics;
import org.hyperic.util.units.SimpleFormatter;
import org.hyperic.util.units.UnitNumber;

public class PercentageFormatter
extends SimpleFormatter {
    @Override
    protected int getUnitType() {
        return 6;
    }

    @Override
    protected int getUnitScale() {
        return 0;
    }

    protected double getMultiplier() {
        return 1.0;
    }

    @Override
    protected FormattedNumber formatNumber(double rawValue, NumberFormat fmt) {
        return new FormattedNumber(fmt.format(rawValue * this.getMultiplier()), "%", "");
    }

    @Override
    public UnitNumber parse(String val, Locale locale, ParseSpecifics specifics) throws ParseException {
        NumberFormat fmt = NumberFormat.getPercentInstance(locale);
        return new UnitNumber(fmt.parse(val).doubleValue(), this.getUnitType(), this.getUnitScale());
    }

    @Override
    public FormattedNumber[] formatSame(double[] vals, int unitType, int scale, Locale locale, FormatSpecifics specifics) {
        if (unitType != this.getUnitType()) {
            throw new IllegalArgumentException("Invalid unit specified");
        }
        if (scale != this.getUnitScale()) {
            throw new IllegalArgumentException("Invalid scale specified");
        }
        NumberFormat fmt = NumberFormat.getInstance(locale);
        fmt.setMaximumFractionDigits(2);
        FormattedNumber[] res = new FormattedNumber[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            res[i] = this.formatNumber(vals[i], fmt);
        }
        return res;
    }
}

