/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.hyperic.util.security.SecurityUtil;
import org.jasypt.encryption.pbe.PBEStringCleanablePasswordEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;

public class SecuredPbeStringEncryptor
implements PBEStringCleanablePasswordEncryptor {
    private static final int KEY_LENGTH_IN_BITS = 128;
    private static final int IV_LENGTH_IN_BITS = 16;
    private static final int SALT_LENGTH_IN_BITS = 16;
    private static final int ITERAIONS_COUNT = 4096;
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_STRING_ENCODING = "UTF-8";
    private static final Log logger = LogFactory.getLog(SecuredPbeStringEncryptor.class);
    private static final String ENCRYPTION_ALGORITHM = "PBEWithSHA256And128BitAES-CBC-BC";
    private char[] password;

    public SecuredPbeStringEncryptor(char[] password) {
        this.setPasswordCharArray(password);
    }

    public String encrypt(String data) {
        String operationName = "encryption";
        String encryptedDataAsString = null;
        try {
            encryptedDataAsString = this.encrypt(SecuredPbeStringEncryptor.convertStringToByteArray(data));
        }
        catch (UnsupportedEncodingException e) {
            this.handleOperationError(operationName);
        }
        return encryptedDataAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encrypt(char[] sensitiveData) {
        String string;
        byte[] sensitiveDataInBytes = null;
        try {
            CharBuffer charBuffer = CharBuffer.wrap(sensitiveData);
            ByteBuffer byteBuffer = Charset.forName(DEFAULT_STRING_ENCODING).encode(charBuffer);
            sensitiveDataInBytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
            string = this.encrypt(sensitiveDataInBytes);
        }
        catch (Throwable throwable) {
            SecurityUtil.clearSensitiveData(sensitiveDataInBytes);
            throw throwable;
        }
        SecurityUtil.clearSensitiveData(sensitiveDataInBytes);
        return string;
    }

    private String encrypt(byte[] data) {
        String operationName = "encryption";
        this.validatePasswordNotEmpty(operationName);
        byte[] salt = this.generateRandomsArray(16);
        byte[] iv = this.generateRandomsArray(16);
        byte[] encryptedBytes = null;
        try {
            encryptedBytes = SecuredPbeStringEncryptor.encrypt(data, this.password, salt, iv);
        }
        catch (Exception e) {
            this.handleOperationError(operationName);
        }
        byte[] saltWithIv = ArrayUtils.addAll((byte[])salt, (byte[])iv);
        byte[] encryptedResult = ArrayUtils.addAll((byte[])saltWithIv, (byte[])encryptedBytes);
        return Base64.toBase64String((byte[])encryptedResult);
    }

    public String decrypt(String data) {
        String operationName = "decryption";
        this.validatePasswordNotEmpty(operationName);
        byte[] dataWithSaltAndIv = Base64.decode((String)data);
        byte[] decryptedData = null;
        try {
            decryptedData = SecuredPbeStringEncryptor.decrypt(dataWithSaltAndIv, this.password);
        }
        catch (Exception e) {
            this.handleOperationError(operationName);
        }
        if (decryptedData == null || decryptedData.length == 0) {
            return EMPTY_STRING;
        }
        return new String(Base64.decode((String)Base64.toBase64String((byte[])decryptedData)));
    }

    private byte[] generateRandomsArray(int size) {
        byte[] randomsArray = new byte[size];
        SecureRandom randomGen = new SecureRandom();
        randomGen.nextBytes(randomsArray);
        return randomsArray;
    }

    private void handleOperationError(String operationName) {
        String errorMessage = String.format("An error occurred while performing %s", operationName);
        logger.error((Object)errorMessage);
        throw new EncryptionOperationNotPossibleException(errorMessage);
    }

    private void validatePasswordNotEmpty(String operationName) {
        if (ArrayUtils.isEmpty((char[])this.password)) {
            throw new EncryptionInitializationException(String.format("Cannot perform %s. Empty password.", operationName));
        }
    }

    public void setPasswordCharArray(char[] password) {
        if (ArrayUtils.isEmpty((char[])password)) {
            this.password = null;
            return;
        }
        this.password = Arrays.copyOf(password, password.length);
    }

    @Deprecated
    public void setPassword(String password) {
        this.password = password.toCharArray();
    }

    private static byte[] convertStringToByteArray(String text) throws UnsupportedEncodingException {
        return text.getBytes(DEFAULT_STRING_ENCODING);
    }

    private static byte[] encrypt(byte[] bytesToEncrypt, char[] password, byte[] salt, byte[] iv) throws GeneralSecurityException {
        SecretKeySpec key = SecuredPbeStringEncryptor.generateSecretKeySpec(password, salt);
        Cipher encryptionCipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
        encryptionCipher.init(1, (Key)key, new IvParameterSpec(iv));
        return encryptionCipher.doFinal(bytesToEncrypt);
    }

    private static SecretKeySpec generateSecretKeySpec(char[] password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password, salt, 4096, 128);
        SecretKeyFactory secretKeyFact = SecretKeyFactory.getInstance(ENCRYPTION_ALGORITHM);
        SecretKeySpec key = new SecretKeySpec(secretKeyFact.generateSecret(pbeKeySpec).getEncoded(), "AES");
        return key;
    }

    private static byte[] decrypt(byte[] bytesToDecrypt, char[] password) throws GeneralSecurityException {
        byte[] salt = ArrayUtils.subarray((byte[])bytesToDecrypt, (int)0, (int)16);
        byte[] iv = ArrayUtils.subarray((byte[])bytesToDecrypt, (int)16, (int)32);
        byte[] encryptedData = ArrayUtils.subarray((byte[])bytesToDecrypt, (int)32, (int)bytesToDecrypt.length);
        SecretKeySpec secretKeySpec = SecuredPbeStringEncryptor.generateSecretKeySpec(password, salt);
        Cipher decryptionCipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
        decryptionCipher.init(2, (Key)secretKeySpec, new IvParameterSpec(iv));
        byte[] decryptedData = decryptionCipher.doFinal(encryptedData);
        return decryptedData;
    }

    static {
        if (null == Security.getProvider("BC")) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

