/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.performance.widgets;

import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class StatsTable
extends JPanel {
    private static final long serialVersionUID = 2821522831471275495L;
    private StatsTableModel tableModel;
    private JLabel label;

    public StatsTable(String[] stringArray) {
        this.setLayout(new BoxLayout(this, 1));
        this.tableModel = new StatsTableModel(stringArray);
        JTable jTable = new JTable(this.tableModel);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.label = new JLabel("");
        this.add(this.label);
        this.add(jScrollPane);
    }

    public void setData(Calendar calendar, long l, String string, List<Object[]> list) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("h:mm:ss a");
        String string2 = "Overall Usage : " + l + " " + string + "  " + simpleDateFormat.format(calendar.getTime());
        this.label.setText(string2);
        this.tableModel.setData(list);
    }

    class StatsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8284592228363242920L;
        private String[] columnNames;
        private List<Object[]> data;

        StatsTableModel(String[] stringArray) {
            this.columnNames = stringArray;
            this.data = new Vector<Object[]>();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data.get(n)[n2];
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            return Long.class;
        }

        public void setData(List<Object[]> list) {
            this.data = list;
            this.fireTableDataChanged();
        }
    }
}

