/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.host;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfDVSNetworkResourcePool;
import com.vmware.vim25.ConcurrentAccessFaultMsg;
import com.vmware.vim25.DVPortSetting;
import com.vmware.vim25.DVPortgroupConfigInfo;
import com.vmware.vim25.DVPortgroupConfigSpec;
import com.vmware.vim25.DVSNetworkResourcePool;
import com.vmware.vim25.DVSNetworkResourcePoolAllocationInfo;
import com.vmware.vim25.DVSNetworkResourcePoolConfigSpec;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.DvsFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SharesInfo;
import com.vmware.vim25.SharesLevel;
import com.vmware.vim25.StringPolicy;
import com.vmware.vim25.TaskInfoState;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

@Sample(name="nico-for-dvs", description="demonstrates how to add/modify NetworkResourcePool to Distributed Virtual Switch")
public class NIOCForDVS
extends ConnectedVimServiceBase {
    private String dvsname = null;
    private String dvPGName = null;
    private String nrpName = null;
    private String nrpAllocationShareLevel = null;
    private String prioritytag = null;
    private String hostLimit = null;
    private int noOfShares = -1;
    private String nrpDesc = null;
    private String enableNIOC = null;
    private String option = null;

    @Option(name="option", description="\n\t\"enablenioc\" for enabling network I/O control\n\t\"addnrp\" for adding Network Resource Pool\n\t\"listnrp\" for Listing existing DVSNetworkResourcePool\n\t\"modifynrp\" for reconfiguring NetworkResourcePool\n\t\"nrptoportgroup\" for adding NetworkResourcePool key to DVS Port Group\n")
    public void setOption(String string) {
        this.option = string;
    }

    @Option(name="dvsname", description="Distributed Virtual Switch name")
    public void setDvsname(String string) {
        this.dvsname = string;
    }

    @Option(name="enablenioc", required=false, description="If true, enables I/O control. If false, disables network I/O control")
    public void setEnableNIOC(String string) {
        this.enableNIOC = string;
    }

    @Option(name="nrpsharelevel", required=false, description="high, normal, low or numeric\n\tThe allocation level. The level is a simplified view of shares.\n\tLevels map to a pre-determined set of numeric values for shares. If the\n\tShares value does not map to a predefined size, then the level is set as custom.\n")
    public void setNrpAllocationShareLevel(String string) {
        this.nrpAllocationShareLevel = string;
    }

    @Option(name="nrphostlimit", required=false, description="\n\tNumeric value: The maximum allowed usage for network clients\n\tbelonging to this resource pool per host.\n")
    public void setHostLimit(String string) {
        this.hostLimit = string;
    }

    @Option(name="nrpprioritytag", required=false, description="\n\tNumeric value: The 802.1p tag to be used for this resource pool.\n\tIts value should be between 0-7\n")
    public void setPrioritytag(String string) {
        this.prioritytag = string;
    }

    @Option(name="nrpname", required=false, description="The user defined name for the resource pool.")
    public void setNrpName(String string) {
        this.nrpName = string;
    }

    @Option(name="nrpdesc", required=false, description="The user defined description for the resource pool.")
    public void setNrpDesc(String string) {
        this.nrpDesc = string;
    }

    @Option(name="dvpgname", required=false, description="The name of the portgroup.")
    public void setDvPGName(String string) {
        this.dvPGName = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void validate() {
        if (this.option != null) {
            if (!(this.option.equalsIgnoreCase("enablenioc") || this.option.equalsIgnoreCase("addnrp") || this.option.equalsIgnoreCase("listnrp") || this.option.equalsIgnoreCase("modifynrp") || this.option.equalsIgnoreCase("nrptoportgroup"))) {
                throw new IllegalArgumentException("Expected valid --option. enablenioc, addnrp, listnrp, modifynrp or nrptoportgroup");
            }
        } else {
            throw new IllegalArgumentException("Expected --option argument. enablenioc, addnrp, listnrp, modifynrp or nrptoportgroup");
        }
        if (this.option.equalsIgnoreCase("enablenioc") && (this.dvsname == null || this.enableNIOC == null)) {
            throw new IllegalArgumentException("Expected --dvsname and --enablenioc arguments");
        }
        if (this.option.equalsIgnoreCase("listnrp") && this.dvsname == null) {
            throw new IllegalArgumentException("Expected --dvsname arguments");
        }
        if (this.option.equalsIgnoreCase("addnrp") || this.option.equalsIgnoreCase("modifynrp")) {
            if (this.dvsname == null || this.nrpName == null) {
                throw new IllegalArgumentException("Expected --dvsname and --nrpname arguments");
            }
            if (this.nrpAllocationShareLevel != null) {
                if (this.nrpAllocationShareLevel.matches("\\d+")) {
                    this.noOfShares = Integer.parseInt(this.nrpAllocationShareLevel);
                } else if (!(this.nrpAllocationShareLevel.equalsIgnoreCase(SharesLevel.HIGH.toString()) || this.nrpAllocationShareLevel.equalsIgnoreCase(SharesLevel.NORMAL.toString()) || this.nrpAllocationShareLevel.equalsIgnoreCase(SharesLevel.LOW.toString()))) {
                    throw new IllegalArgumentException("Expected --nrpsharelevel arguments. high, normal, low or numeric");
                }
            }
            if (this.prioritytag != null && (Integer.parseInt(this.prioritytag) < 0 || Integer.parseInt(this.prioritytag) > 7)) {
                throw new IllegalArgumentException("Expected --nrpprioritytag integer between 0-7");
            }
        }
        if (this.option.equalsIgnoreCase("nrptoportgroup") && (this.dvPGName == null || this.dvsname == null || this.nrpName == null)) {
            throw new IllegalArgumentException("Expected --dvsname, --nrpName and --dvpgname arguments");
        }
    }

    void enableNIOC(String string, boolean bl) throws DvsFaultFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ManagedObjectReference managedObjectReference = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "VmwareDistributedVirtualSwitch").get(string);
        if (managedObjectReference == null) {
            System.out.println("DVS Switch " + string + " Not Found");
            return;
        }
        this.vimPort.enableNetworkResourceManagement(managedObjectReference, bl);
        System.out.printf("Set network I/O control", new Object[0]);
    }

    void addNetworkResourcePool(String string, String string2, String string3, int n, String string4, String string5, String string6) throws DvsFaultFaultMsg, InvalidNameFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        DVSNetworkResourcePoolAllocationInfo dVSNetworkResourcePoolAllocationInfo;
        DVSNetworkResourcePoolConfigSpec dVSNetworkResourcePoolConfigSpec;
        ArrayList<DVSNetworkResourcePoolConfigSpec> arrayList;
        ManagedObjectReference managedObjectReference = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "VmwareDistributedVirtualSwitch").get(string);
        if (managedObjectReference != null) {
            arrayList = new ArrayList<DVSNetworkResourcePoolConfigSpec>();
            dVSNetworkResourcePoolConfigSpec = new DVSNetworkResourcePoolConfigSpec();
            dVSNetworkResourcePoolAllocationInfo = new DVSNetworkResourcePoolAllocationInfo();
            if (string4 != null) {
                SharesInfo sharesInfo = new SharesInfo();
                if (n != -1) {
                    sharesInfo.setLevel(SharesLevel.CUSTOM);
                    sharesInfo.setShares(n);
                } else {
                    sharesInfo.setLevel(SharesLevel.valueOf((String)string4.toUpperCase()));
                }
                dVSNetworkResourcePoolAllocationInfo.setShares(sharesInfo);
            }
            if (string6 != null) {
                dVSNetworkResourcePoolAllocationInfo.setLimit(Long.valueOf(Long.parseLong(string6)));
            }
            if (string5 != null) {
                dVSNetworkResourcePoolAllocationInfo.setPriorityTag(Integer.valueOf(Integer.parseInt(string5)));
            }
            dVSNetworkResourcePoolConfigSpec.setConfigVersion("0");
            if (string3 != null) {
                dVSNetworkResourcePoolConfigSpec.setDescription(string3);
            } else {
                dVSNetworkResourcePoolConfigSpec.setDescription(string2);
            }
        } else {
            System.out.println("DVS Switch " + string + " Not Found");
            return;
        }
        dVSNetworkResourcePoolConfigSpec.setName(string2);
        dVSNetworkResourcePoolConfigSpec.setAllocationInfo(dVSNetworkResourcePoolAllocationInfo);
        dVSNetworkResourcePoolConfigSpec.setKey("");
        arrayList.add(dVSNetworkResourcePoolConfigSpec);
        this.vimPort.addNetworkResourcePool(managedObjectReference, arrayList);
        System.out.printf("Added NetworkResourcePool successfully", new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    void listNetworkResourcePool(String string) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ManagedObjectReference managedObjectReference = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "VmwareDistributedVirtualSwitch").get(string);
        if (managedObjectReference != null) {
            List list = ((ArrayOfDVSNetworkResourcePool)this.getMOREFs.entityProps(managedObjectReference, new String[]{"networkResourcePool"}).get("networkResourcePool")).getDVSNetworkResourcePool();
            if (list == null) {
                System.out.println("No NetworkResourcePool found for DVS Switch " + string);
                return;
            }
            System.out.println("Existing DVSNetworkResourcePool:");
            for (DVSNetworkResourcePool dVSNetworkResourcePool : list) {
                String string2 = "System defined DVSNetworkResourcePool";
                if (dVSNetworkResourcePool.getKey().startsWith("NRP")) {
                    string2 = "User defined DVSNetworkResourcePool";
                }
                System.out.println(dVSNetworkResourcePool.getName() + " : networkResourcePool[\"" + dVSNetworkResourcePool.getKey() + "\"] : " + string2);
            }
            return;
        } else {
            System.out.println("DVS Switch " + string + " Not Found");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void modifyNetworkResourcePool(String string, String string2, int n, String string3, String string4, String string5) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, NotFoundFaultMsg, DvsFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidNameFaultMsg {
        DVSNetworkResourcePool dVSNetworkResourcePool2;
        ManagedObjectReference managedObjectReference = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "VmwareDistributedVirtualSwitch").get(string);
        if (managedObjectReference == null) {
            System.out.println("DVS Switch " + string + " Not Found");
            return;
        }
        List list = ((ArrayOfDVSNetworkResourcePool)this.getMOREFs.entityProps(managedObjectReference, new String[]{"networkResourcePool"}).get("networkResourcePool")).getDVSNetworkResourcePool();
        if (list == null) {
            System.out.println("No NetworkResourcePool found for DVS Switch " + string);
            return;
        }
        String string6 = null;
        String string7 = null;
        for (DVSNetworkResourcePool dVSNetworkResourcePool2 : list) {
            if (!dVSNetworkResourcePool2.getName().equalsIgnoreCase(string2)) continue;
            string7 = dVSNetworkResourcePool2.getKey();
            string6 = dVSNetworkResourcePool2.getConfigVersion();
        }
        if (string7 == null) {
            System.out.println("NetworkResource Pool " + string2 + " Not Found");
            return;
        }
        ArrayList arrayList = new ArrayList();
        dVSNetworkResourcePool2 = new DVSNetworkResourcePoolConfigSpec();
        DVSNetworkResourcePoolAllocationInfo dVSNetworkResourcePoolAllocationInfo = new DVSNetworkResourcePoolAllocationInfo();
        if (string3 != null) {
            SharesInfo sharesInfo = new SharesInfo();
            if (n != -1) {
                sharesInfo.setLevel(SharesLevel.CUSTOM);
                sharesInfo.setShares(n);
            } else {
                sharesInfo.setLevel(SharesLevel.valueOf((String)string3.toUpperCase()));
            }
            dVSNetworkResourcePoolAllocationInfo.setShares(sharesInfo);
        }
        if (string5 != null) {
            dVSNetworkResourcePoolAllocationInfo.setLimit(Long.valueOf(Long.parseLong(string5)));
        }
        if (string4 != null) {
            dVSNetworkResourcePoolAllocationInfo.setPriorityTag(Integer.valueOf(Integer.parseInt(string4)));
        }
        dVSNetworkResourcePool2.setConfigVersion(string6);
        dVSNetworkResourcePool2.setAllocationInfo(dVSNetworkResourcePoolAllocationInfo);
        dVSNetworkResourcePool2.setKey(string7);
        arrayList.add(dVSNetworkResourcePool2);
        this.vimPort.updateNetworkResourcePool(managedObjectReference, (List)arrayList);
        System.out.printf("Modified NetworkResourcePool successfully", new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    void reconfigureDVSPG(String string, String string2, String string3) throws RemoteException, InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, ConcurrentAccessFaultMsg, DuplicateNameFaultMsg, DvsFaultFaultMsg, InvalidNameFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "VmwareDistributedVirtualSwitch").get(string);
        if (managedObjectReference == null) {
            System.out.println("DVS Switch " + string + " Not Found");
            return;
        }
        List list = ((ArrayOfDVSNetworkResourcePool)this.getMOREFs.entityProps(managedObjectReference, new String[]{"networkResourcePool"}).get("networkResourcePool")).getDVSNetworkResourcePool();
        String string4 = null;
        if (list == null) {
            System.out.println("No NetworkResourcePool found for DVS Switch " + string);
            return;
        }
        for (DVSNetworkResourcePool dVSNetworkResourcePool : list) {
            if (!dVSNetworkResourcePool.getName().equalsIgnoreCase(string2)) continue;
            string4 = dVSNetworkResourcePool.getKey();
        }
        if (string4 == null) {
            System.out.println("NetworkResourcePool " + string2 + " Not Found");
            return;
        }
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "DistributedVirtualPortgroup").get(string3);
        if (managedObjectReference2 != null) {
            DVSNetworkResourcePool dVSNetworkResourcePool;
            dVSNetworkResourcePool = (DVPortgroupConfigInfo)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"config"}).get("config");
            String string5 = dVSNetworkResourcePool.getConfigVersion();
            DVPortgroupConfigSpec dVPortgroupConfigSpec = new DVPortgroupConfigSpec();
            DVPortSetting dVPortSetting = new DVPortSetting();
            StringPolicy stringPolicy = new StringPolicy();
            stringPolicy.setValue(string4);
            stringPolicy.setInherited(false);
            dVPortSetting.setNetworkResourcePoolKey(stringPolicy);
            dVPortgroupConfigSpec.setName(string3);
            dVPortgroupConfigSpec.setConfigVersion(string5);
            dVPortgroupConfigSpec.setDefaultPortConfig(dVPortSetting);
            ManagedObjectReference managedObjectReference3 = this.vimPort.reconfigureDVPortgroupTask(managedObjectReference2, dVPortgroupConfigSpec);
            if (!this.getTaskResultAfterDone(managedObjectReference3)) throw new RuntimeException("Failure: Reconfiguring Port Group");
            System.out.printf("Success: Reconfiguring Port Group", new Object[0]);
            return;
        }
        System.out.println("DVS port group " + string3 + " Not Found");
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, DvsFaultFaultMsg, InvalidNameFaultMsg, RuntimeFaultFaultMsg, NotFoundFaultMsg, ConcurrentAccessFaultMsg, DuplicateNameFaultMsg, InvalidCollectorVersionFaultMsg, RemoteException {
        if (this.option.equalsIgnoreCase("enablenioc")) {
            this.enableNIOC(this.dvsname, Boolean.parseBoolean(this.enableNIOC));
        } else if (this.option.equalsIgnoreCase("addnrp")) {
            this.addNetworkResourcePool(this.dvsname, this.nrpName, this.nrpDesc, this.noOfShares, this.nrpAllocationShareLevel, this.prioritytag, this.hostLimit);
        } else if (this.option.equalsIgnoreCase("listnrp")) {
            this.listNetworkResourcePool(this.dvsname);
        } else if (this.option.equalsIgnoreCase("modifynrp")) {
            this.modifyNetworkResourcePool(this.dvsname, this.nrpName, this.noOfShares, this.nrpAllocationShareLevel, this.prioritytag, this.hostLimit);
        } else if (this.option.equalsIgnoreCase("nrptoportgroup")) {
            this.reconfigureDVSPG(this.dvsname, this.nrpName, this.dvPGName);
        }
    }
}

