/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.events;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfEventDescriptionEventDetail;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.Event;
import com.vmware.vim25.EventDescriptionEventDetail;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.UserLoginSessionEvent;
import com.vmware.vim25.VmPoweredOnEvent;
import com.vmware.vim25.VmRenamedEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

@Sample(name="event-format", description="This sample retrieves and formats the lastEvent from Hostd or Vpxd")
public class EventFormat
extends ConnectedVimServiceBase {
    ManagedObjectReference eventManagerRef;
    ManagedObjectReference propCollectorRef;

    PropertyFilterSpec createEventFilterSpec(String string) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(new Boolean(false));
        propertySpec.getPathSet().add(string);
        propertySpec.setType(this.eventManagerRef.getType());
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(this.eventManagerRef);
        objectSpec.setSkip(new Boolean(false));
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        return propertyFilterSpec;
    }

    void formatLatestEvent() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
        arrayList.add(this.createEventFilterSpec("description.eventInfo"));
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList);
        if (list != null) {
            Object object2;
            ArrayOfEventDescriptionEventDetail arrayOfEventDescriptionEventDetail = (ArrayOfEventDescriptionEventDetail)((DynamicProperty)list.get(0).getPropSet().get(0)).getVal();
            List list2 = arrayOfEventDescriptionEventDetail.getEventDescriptionEventDetail();
            Hashtable<String, EventDescriptionEventDetail> hashtable = new Hashtable<String, EventDescriptionEventDetail>();
            for (Object object2 : list2) {
                hashtable.put(object2.getKey(), (EventDescriptionEventDetail)object2);
            }
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(this.createEventFilterSpec("latestEvent"));
            object2 = this.retrievePropertiesAllObjects(arrayList2);
            if (object2 != null) {
                Event event = (Event)((DynamicProperty)((ObjectContent)object2.get(0)).getPropSet().get(0)).getVal();
                System.out.println("The latestEvent was : " + event.getClass().getName());
                this.formatEvent(0, hashtable, event);
                this.formatEvent(1, hashtable, event);
                this.formatEvent(2, hashtable, event);
                this.formatEvent(3, hashtable, event);
                this.formatEvent(4, hashtable, event);
            }
        } else {
            System.out.println("No Events retrieved!");
        }
    }

    void formatEvent(int n, Hashtable<String, EventDescriptionEventDetail> hashtable, Event event) {
        String string = event.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        EventDescriptionEventDetail eventDescriptionEventDetail = hashtable.get(string);
        String string2 = eventDescriptionEventDetail.getFullFormat();
        switch (n) {
            case 2: {
                string2 = eventDescriptionEventDetail.getFormatOnComputeResource();
                break;
            }
            case 3: {
                string2 = eventDescriptionEventDetail.getFormatOnDatacenter();
                break;
            }
            case 1: {
                string2 = eventDescriptionEventDetail.getFormatOnHost();
                break;
            }
            case 0: {
                string2 = eventDescriptionEventDetail.getFormatOnVm();
                break;
            }
            case 4: {
                string2 = eventDescriptionEventDetail.getFullFormat();
            }
        }
        String string3 = "";
        if ("VmPoweredOnEvent".equals(string)) {
            string3 = this.replaceText(string2, (VmPoweredOnEvent)event);
            if (string3 != null) {
                System.out.println(string3);
            }
        } else if ("VmRenamedEvent".equals(string)) {
            string3 = this.replaceText(string2, (VmRenamedEvent)event);
            if (string3 != null) {
                System.out.println(string3);
            }
        } else if ("UserLoginSessionEvent".equals(string)) {
            string3 = this.replaceText(string2, (UserLoginSessionEvent)event);
            if (string3 != null) {
                System.out.println(string3);
            }
        } else {
            string3 = this.replaceText(string2, event);
            if (string3.length() == 0 || string3.indexOf("{") != -1) {
                string3 = event.getFullFormattedMessage();
            }
            if (string3 != null) {
                System.out.println(string3);
            }
        }
    }

    String replaceText(String string, UserLoginSessionEvent userLoginSessionEvent) {
        string = this.replaceText(string, (Event)userLoginSessionEvent);
        string = string.replaceAll("\\{ipAddress\\}", userLoginSessionEvent.getIpAddress());
        return string;
    }

    String replaceText(String string, VmPoweredOnEvent vmPoweredOnEvent) {
        return this.replaceText(string, (Event)vmPoweredOnEvent);
    }

    String replaceText(String string, VmRenamedEvent vmRenamedEvent) {
        string = this.replaceText(string, (Event)vmRenamedEvent);
        string = string.replaceAll("\\{oldName\\}", vmRenamedEvent.getOldName());
        string = string.replaceAll("\\{newName\\}", vmRenamedEvent.getNewName());
        return string;
    }

    String replaceText(String string, Event event) {
        string = string.replaceAll("\\{userName\\}", event.getUserName());
        if (event.getComputeResource() != null) {
            string = string.replaceAll("\\{computeResource.name\\}", event.getComputeResource().getName());
        }
        if (event.getDatacenter() != null) {
            string = string.replaceAll("\\{datacenter.name\\}", event.getDatacenter().getName());
        }
        if (event.getHost() != null) {
            string = string.replaceAll("\\{host.name\\}", event.getHost().getName());
        }
        if (event.getVm() != null) {
            string = string.replaceAll("\\{vm.name\\}", event.getVm().getName());
        }
        return string;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.eventManagerRef = this.serviceContent.getEventManager();
        System.out.println("EV Man Val " + this.eventManagerRef.getValue());
        this.formatLatestEvent();
    }
}

