/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.samples;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.pbm.InvalidArgumentFaultMsg;
import com.vmware.pbm.PbmCapabilityProfile;
import com.vmware.pbm.PbmComplianceResult;
import com.vmware.pbm.PbmFaultFaultMsg;
import com.vmware.pbm.PbmServerObjectRef;
import com.vmware.pbm.PbmServiceInstanceContent;
import com.vmware.spbm.connection.ConnectedServiceBase;
import com.vmware.spbm.connection.helpers.PbmUtil;
import com.vmware.spbm.connection.helpers.VCUtil;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Sample(name="checkcompliance", description="Check compliance of the VM's associated with a storage profile.")
public class CheckCompliance
extends ConnectedServiceBase {
    private PbmServiceInstanceContent spbmsc;
    private String profileName;
    private PbmCapabilityProfile profile;

    @Action
    public void checkProfileCompliance() throws InvalidArgumentFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, PbmFaultFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        Object object2;
        this.spbmsc = this.connection.getPbmServiceContent();
        ManagedObjectReference managedObjectReference = this.spbmsc.getProfileManager();
        List list = this.connection.getPbmPort().pbmQueryProfile(managedObjectReference, PbmUtil.getStorageResourceType(), null);
        if (list == null || list.isEmpty()) {
            throw new RuntimeFaultFaultMsg("No storage Profiles exist.", null);
        }
        List list2 = this.connection.getPbmPort().pbmRetrieveContent(managedObjectReference, list);
        for (Object object2 : list2) {
            if (!object2.getName().equals(this.profileName)) continue;
            this.profile = (PbmCapabilityProfile)object2;
        }
        if (this.profile == null) {
            throw new InvalidArgumentFaultMsg("Specified storage profile name does not exist.", null);
        }
        List list3 = this.connection.getPbmPort().pbmQueryAssociatedEntity(this.connection.getPbmServiceContent().getProfileManager(), this.profile.getProfileId(), "virtualMachine");
        if (list3.isEmpty()) {
            System.out.println("Storage Profile should have associated VM's.");
            return;
        }
        object2 = this.connection.getPbmPort().pbmCheckCompliance(this.connection.getPbmServiceContent().getComplianceManager(), list3, this.profile.getProfileId());
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            PbmComplianceResult pbmComplianceResult = (PbmComplianceResult)iterator.next();
            System.out.println("Compliance status of VM " + this.getVMName(pbmComplianceResult.getEntity()) + ": " + pbmComplianceResult.getComplianceStatus().toUpperCase());
        }
    }

    private String getVMName(PbmServerObjectRef pbmServerObjectRef) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setType("VirtualMachine");
        managedObjectReference.setValue(pbmServerObjectRef.getKey());
        Map<String, Object> map = VCUtil.getEntityProps(this.connection, managedObjectReference, new String[]{"name"});
        return (String)map.get("name");
    }

    @Option(name="profilename", description="name of the storage profile")
    public void setProfileName(String string) {
        this.profileName = string;
    }
}

