/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.wssecurity;

import com.vmware.sso.client.utils.Utils;
import com.vmware.sso.client.wssecurity.WsSecuritySignatureImpl;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.oasis_open.docs.ws_sx.ws_trust._200512.UseKeyType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.BinarySecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ReferenceType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityTokenReferenceType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsSecuritySignatureCertificate
extends WsSecuritySignatureImpl {
    public WsSecuritySignatureCertificate(PrivateKey privateKey, X509Certificate x509Certificate) {
        super(privateKey, x509Certificate);
    }

    @Override
    protected String addUseKeySignatureId(SOAPMessage sOAPMessage) {
        String string = "_" + UUID.randomUUID().toString();
        try {
            sOAPMessage.getSOAPBody().appendChild(sOAPMessage.getSOAPPart().importNode(this.createUseKeyElement(string), true));
        }
        catch (DOMException dOMException) {
            System.out.println("Error creating UseKey element");
            dOMException.printStackTrace();
            throw new RuntimeException("Error creating UseKey element", dOMException);
        }
        catch (SOAPException sOAPException) {
            System.out.println("Error creating UseKey element");
            sOAPException.printStackTrace();
            throw new RuntimeException("Error creating UseKey element", sOAPException);
        }
        return string;
    }

    @Override
    protected Node createKeyInfoContent(SOAPMessage sOAPMessage) {
        String string = "_" + UUID.randomUUID().toString();
        NodeList nodeList = sOAPMessage.getSOAPPart().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        if (nodeList.getLength() != 1) {
            throw new RuntimeException("No/too many security elements found");
        }
        nodeList.item(0).appendChild(sOAPMessage.getSOAPPart().importNode(this.createBinarySecurityToken(string), true));
        return this.createSecurityTokenReference(string);
    }

    private Node createUseKeyElement(String string) {
        org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory objectFactory = new org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory();
        UseKeyType useKeyType = objectFactory.createUseKeyType();
        useKeyType.setSig(string);
        return Utils.marshallJaxbElement(objectFactory.createUseKey(useKeyType)).getFirstChild();
    }

    private Node createBinarySecurityToken(String string) {
        ObjectFactory objectFactory = new ObjectFactory();
        BinarySecurityTokenType binarySecurityTokenType = objectFactory.createBinarySecurityTokenType();
        try {
            binarySecurityTokenType.setValue(DatatypeConverter.printBase64Binary((byte[])this.getUserCert().getEncoded()));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            certificateEncodingException.printStackTrace();
            throw new RuntimeException("Error creating BinarySecurityToken", certificateEncodingException);
        }
        binarySecurityTokenType.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        binarySecurityTokenType.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        binarySecurityTokenType.setId(string);
        return Utils.marshallJaxbElement(objectFactory.createBinarySecurityToken(binarySecurityTokenType)).getFirstChild();
    }

    private Node createSecurityTokenReference(String string) {
        ObjectFactory objectFactory = new ObjectFactory();
        SecurityTokenReferenceType securityTokenReferenceType = objectFactory.createSecurityTokenReferenceType();
        ReferenceType referenceType = objectFactory.createReferenceType();
        referenceType.setURI("#" + string);
        referenceType.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        securityTokenReferenceType.getAny().add(objectFactory.createReference(referenceType));
        return Utils.marshallJaxbElement(objectFactory.createSecurityTokenReference(securityTokenReferenceType)).getFirstChild();
    }
}

