# VMware vSphere Automation REST API Javascript Samples

This is a node/npm implementation of the VMware vSphere Automation REST APIs.

Requirements
------------
<ul>
  <li>Node 4+</li>
  <li>NPM 3+</li>
</ul>

Installation
------------

<pre>
unzip <file>.zip
cd <file>
npm install
</pre>

===Settings===

Before you can run any of the samples, you will need to configure the settings.js file found in this same directory.

In particular, you need to provide the URL to the host you will be running samples against, as well as the username and password for authentication to be successful. Some of the samples may make use of the other values in the settings.js file, namely the host1 and host2 ip addresses when adding new hosts, as well as the name of the datacenter, datastore and VM.

===Run examples===

We have provided a few samples to show how to use the VMware vSphere Automation API. It is important to understand that the individual resource calls use a library called Unirest (http://unirest.io/nodejs.html). This library is what makes the HTTP requests to the API. The nature of this library is that calls are made asynchronously. Because of this, our sample code makes use of javascript promises, and another library, Async (https://github.com/caolan/async) to process the asynchronous calls in a synchronous order.

Also, the first call of each sample is to load a library called rootpath. This
allows subsequent require() calls to avoid using ../../ relative path syntax
when using modules we provide, such as those found in the resources/ and
common/ paths. Essentially it helps the code look a little prettier.

To execute the samples:

<pre>
npm run name-of-sample
</pre>

 You will see output to the console as the sample executes.

 The samples provided are as follows:

 ==vm-details==
  This sample shows the call chain to list the details of the specified virtual
  machine.

==vm-create-details==
  This sample will create a vm with the some of the configuration details found
  in common/settings.js. If successful, you can run the vm-details to verify
  the details of the created virtual machine, including its state.

==vm-create-defaults==
  This sample is the simplest shortest way to create a virtual machine, only
  needing data from a couple of other resources. Take a look at the sample
  body to see how little data is passed in. The rest uses the VM defaults.

==vm-power-on==
  This sample will attempt to power on the specified virtual machine.

==vm-power-off==
  This sample will attempt to power off the specified virtual machine.

==host-add==
  This sample will add a host to a datacenter.

==host-remove==
  This sample will remove a host if it exists from a datacenter.

==host-connect==
  This sample will connect to a host.

==host-disconnect==
  This sample will disconnect a host.
