"""
rpc provider factory
"""

__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright (c) 2015 VMware, Inc.  All rights reserved.'

import logging
from vmware.vapi.lib.load import dynamic_import

logger = logging.getLogger(__name__)


class RpcProviderFactory(object):
    """ Rpc provider factory """
    def __init__(self):
        """ Rpc provider factory init """
        self.rpc_providers = {
           # rpc provider name : constructor / constructor name
           'http': 'vmware.vapi.protocol.client.rpc.http_provider.HttpRpcProvider',
           'https': 'vmware.vapi.protocol.client.rpc.http_provider.HttpRpcProvider',
           'requests': 'vmware.vapi.protocol.client.rpc.requests_provider.RequestsRpcProvider',
        }

    def get_rpc_provider(self, rpc_provider_name, *args, **kwargs):
        """
        Create rpc provider

        :type  rpc_provider_name:
        :param rpc_provider_name:
        :type    args: :class:`tuple`
        :param   args: position parameters to rpc provider constructor
        :type    kwargs: :class:`dict`
        :param   kwargs: key parameters to rpc provider constructor
        :rtype:  :class:`vmware.vapi.protocol.client.rpc.provider.RpcProvider`
        :return: Rpc provider object
        """
        constructor = self.rpc_providers.get(rpc_provider_name)
        if constructor is not None:
            constructor = dynamic_import(constructor)
            if constructor:
                return constructor(*args, **kwargs)
