#!/usr/bin/env python

"""
Connecter interface
"""
__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright (c) 2015 VMware, Inc.  All rights reserved.'


## Connector interface
#
# Interface class, don't need to warn about unused argument / method
# could be function, or abstracted class not referenced
# pylint: disable=W0613,R0201,R0921
class Connector(object):
    """ Connector interface """
    def __init__(self):
        """ Connector interface init """
        pass

    def connect(self):
        """ rpc provider connect """
        raise NotImplementedError

    def disconnect(self):
        """ rpc provider disconnect """
        raise NotImplementedError

    def set_application_context(self, ctx):
        """
        Set the application context

        All the subsequent calls made using this
        connector will use this as the application
        context in the ExecutionContext

        :type  ctx: :class:`vmware.vapi.core.ApplicationContext`
        :param ctx: New application context
        """
        raise NotImplementedError

    def set_security_context(self, ctx):
        """
        Set the security context

        All the subsequent calls made using this
        connector will use this as the security
        context in the ExecutionContext

        :type  ctx: :class:`vmware.vapi.core.SecurityContext`
        :param ctx: New security context
        """
        raise NotImplementedError

    def new_context(self):
        """
        create new execution context object

        :rtype:  :class:`vmware.vapi.core.ExecutionContext`
        :return: execution context
        """
        raise NotImplementedError

    def get_api_provider(self):
        """
        get api provider

        :rtype:  :class:`vmware.vapi.core.ApiProvider`
        :return: api provider
        """
        raise NotImplementedError
