"""
Factory methods for creating application context
"""

__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright (c) 2015 VMware, Inc.  All rights reserved.'


import uuid

from vmware.vapi.core import ApplicationContext
from vmware.vapi.lib.constants import OPID


def create_default_application_context():
    """
    Create a default application context. The
    created context will only have opId.

    :rtype: :class:`vmware.vapi.core.ApplicationContext`
    :return: Newly created application context
    """
    op_id = str(uuid.uuid4())
    return ApplicationContext({OPID: op_id})
