"""
Setup file for creating Runtime package
"""
__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright (c) 2015 VMware, Inc.  All rights reserved.'

try:
    from setuptools import setup, find_packages
except ImportError:
    from distribute_setup import use_setuptools
    use_setuptools()
    from setuptools import setup, find_packages

setup(
    name='vapi_runtime',
    version='2.5.0',
    description='vAPI Runtime',
    classifiers=[],
    keywords='VMware',
    author='VMware',
    namespace_packages=['vmware'],
    packages=find_packages(),
    package_data={
        'vmware': ['vapi/settings/*.properties'],
    },
    include_package_data=True,
    zip_safe=False,
    install_requires=['setuptools',
                      'simplejson>=3.6.5',
                      'pyOpenSSL==0.15.1',
                      'requests==2.6.0',
                      'six==1.9',
                      'werkzeug==0.10.4'],
    entry_points={
        'console_scripts': [
            'vapi-server = vmware.vapi.server.vapid:main'
        ]
    }
)
