/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.helpers;

import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vcenter.Network;
import com.vmware.vcenter.NetworkTypes;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import vmware.samples.vcenter.helpers.DatacenterHelper;

public class NetworkHelper {
    public static String getStandardNetworkBacking(StubFactory stubFactory, StubConfiguration sessionStubConfig, String datacenterName, String stdPortgroupName) {
        Network networkService = (Network)stubFactory.createStub(Network.class, (StubConfigurationBase)sessionStubConfig);
        Set<String> datacenters = Collections.singleton(DatacenterHelper.getDatacenter(stubFactory, sessionStubConfig, datacenterName));
        Set<String> networkNames = Collections.singleton(stdPortgroupName);
        HashSet<NetworkTypes.Type> networkTypes = new HashSet<NetworkTypes.Type>(Collections.singletonList(NetworkTypes.Type.STANDARD_PORTGROUP));
        NetworkTypes.FilterSpec networkFilterSpec = new NetworkTypes.FilterSpec.Builder().setDatacenters(datacenters).setNames(networkNames).setTypes(networkTypes).build();
        List networkSummaries = networkService.list(networkFilterSpec);
        assert (networkSummaries.size() > 0) : "Standard Portgroup with name " + stdPortgroupName + " not found in datacenter " + datacenterName;
        return ((NetworkTypes.Summary)networkSummaries.get(0)).getNetwork();
    }

    public static String getDistributedNetworkBacking(StubFactory stubFactory, StubConfiguration sessionStubConfig, String datacenterName, String vdPortgroupName) {
        Network networkService = (Network)stubFactory.createStub(Network.class, (StubConfigurationBase)sessionStubConfig);
        Set<String> datacenters = Collections.singleton(DatacenterHelper.getDatacenter(stubFactory, sessionStubConfig, datacenterName));
        Set<String> networkNames = Collections.singleton(vdPortgroupName);
        HashSet<NetworkTypes.Type> networkTypes = new HashSet<NetworkTypes.Type>(Collections.singletonList(NetworkTypes.Type.DISTRIBUTED_PORTGROUP));
        NetworkTypes.FilterSpec networkFilterSpec = new NetworkTypes.FilterSpec.Builder().setDatacenters(datacenters).setNames(networkNames).setTypes(networkTypes).build();
        List networkSummaries = networkService.list(networkFilterSpec);
        assert (networkSummaries.size() > 0) : "Distributed Portgroup with name " + vdPortgroupName + " not found in datacenter " + datacenterName;
        return ((NetworkTypes.Summary)networkSummaries.get(0)).getNetwork();
    }
}

