/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.helpers;

import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vcenter.Datastore;
import com.vmware.vcenter.DatastoreTypes;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import vmware.samples.vcenter.helpers.DatacenterHelper;

public class DatastoreHelper {
    public static String getDatastore(StubFactory stubFactory, StubConfiguration sessionStubConfig, String datacenterName, String datastoreName) {
        Set<String> datacenters = Collections.singleton(DatacenterHelper.getDatacenter(stubFactory, sessionStubConfig, datacenterName));
        Datastore datastoreService = (Datastore)stubFactory.createStub(Datastore.class, (StubConfigurationBase)sessionStubConfig);
        Set<String> datastores = Collections.singleton(datastoreName);
        DatastoreTypes.FilterSpec datastoreFilterSpec = new DatastoreTypes.FilterSpec.Builder().setNames(datastores).setDatacenters(datacenters).build();
        List datastoreSummaries = datastoreService.list(datastoreFilterSpec);
        assert (datastoreSummaries.size() > 0) : "Datastore " + datastoreName + "not found in datacenter : " + datacenterName;
        return ((DatastoreTypes.Summary)datastoreSummaries.get(0)).getDatastore();
    }
}

