/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.helpers;

import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vcenter.Cluster;
import com.vmware.vcenter.ClusterTypes;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import vmware.samples.vcenter.helpers.DatacenterHelper;

public class ClusterHelper {
    public static String getCluster(StubFactory stubFactory, StubConfiguration sessionStubConfig, String datacenterName, String clusterName) {
        Set<String> datacenters = Collections.singleton(DatacenterHelper.getDatacenter(stubFactory, sessionStubConfig, datacenterName));
        Cluster clusterService = (Cluster)stubFactory.createStub(Cluster.class, (StubConfigurationBase)sessionStubConfig);
        Set<String> clusters = Collections.singleton(clusterName);
        ClusterTypes.FilterSpec clusterFilterSpec = new ClusterTypes.FilterSpec.Builder().setNames(clusters).setDatacenters(datacenters).build();
        List clusterSummaries = clusterService.list(clusterFilterSpec);
        assert (clusterSummaries.size() > 0) : "Cluster " + clusterName + "not found in datacenter: " + datacenterName;
        return ((ClusterTypes.Summary)clusterSummaries.get(0)).getCluster();
    }
}

