/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.tagging.workflow;

import com.vmware.cis.tagging.Category;
import com.vmware.cis.tagging.CategoryModel;
import com.vmware.cis.tagging.CategoryTypes;
import com.vmware.cis.tagging.Tag;
import com.vmware.cis.tagging.TagAssociation;
import com.vmware.cis.tagging.TagTypes;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.std.DynamicID;
import com.vmware.vim25.ManagedObjectReference;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.common.vim.helpers.VimUtil;

public class TaggingWorkflow
extends SamplesAbstractBase {
    private String clusterName;
    private Category categoryService;
    private Tag taggingService;
    private TagAssociation tagAssociation;
    private String categoryName = "Asset";
    private String categoryDescription = "All data center assets";
    private String tagName = "Server";
    private String tagDescription = "Cluster running application server";
    private String assetCategoryId;
    private String serverTagId;
    private boolean tagAttached = false;
    private ManagedObjectReference clusterMoRef;
    private DynamicID clusterDynamicId;

    @Override
    public void parseArgs(String[] args) {
        Option clusterNameOpt = Option.builder().longOpt("cluster").desc("The name of the cluster to be tagged").required(true).hasArg().argName("CLUSTER").build();
        List<Option> optionList = Collections.singletonList(clusterNameOpt);
        super.parseArgs(optionList, args);
        this.clusterName = (String)this.parsedOptions.get("cluster");
    }

    @Override
    public void setup() throws Exception {
        this.categoryService = (Category)this.vapiAuthHelper.getStubFactory().createStub(Category.class, (StubConfigurationBase)this.sessionStubConfig);
        this.taggingService = (Tag)this.vapiAuthHelper.getStubFactory().createStub(Tag.class, (StubConfigurationBase)this.sessionStubConfig);
        this.tagAssociation = (TagAssociation)this.vapiAuthHelper.getStubFactory().createStub(TagAssociation.class, (StubConfigurationBase)this.sessionStubConfig);
        this.clusterMoRef = VimUtil.getCluster(this.vimAuthHelper.getVimPort(), this.vimAuthHelper.getServiceContent(), this.clusterName);
        assert (this.clusterMoRef != null);
        System.out.println("Cluster MoRef: " + this.clusterMoRef.getValue());
    }

    @Override
    public void run() throws Exception {
        List categories = this.categoryService.list();
        System.out.println("Tag Categories:\n" + categories + "\nEnd of tag categories");
        List tags = this.taggingService.list();
        System.out.println(" Tags: " + tags + "End of tags");
        this.assetCategoryId = this.createTagCategory(this.categoryName, this.categoryDescription, CategoryModel.Cardinality.MULTIPLE);
        System.out.println("Tag category created; Id: " + this.assetCategoryId);
        this.serverTagId = this.createTag(this.tagName, this.tagDescription, this.assetCategoryId);
        System.out.println("Tag created; Id: " + this.serverTagId);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS");
        Date dt = new Date();
        String date = sdf.format(dt);
        this.updateTag(this.serverTagId, "Server Tag updated at " + date);
        System.out.println("Tag updated; Id: " + this.serverTagId);
        this.clusterDynamicId = new DynamicID(this.clusterMoRef.getType(), this.clusterMoRef.getValue());
        List attachableTags = this.tagAssociation.listAttachableTags(this.clusterDynamicId);
        System.out.println("Attachable Tags:\n" + attachableTags + "\nEnd of Attachable tags");
        assert (attachableTags.contains(this.serverTagId));
        this.tagAssociation.attach(this.serverTagId, this.clusterDynamicId);
        assert (this.tagAssociation.listAttachedTags(this.clusterDynamicId).contains(this.serverTagId));
        this.tagAttached = true;
        System.out.println("Cluster: " + this.clusterDynamicId + " tagged");
    }

    @Override
    public void cleanup() throws Exception {
        if (this.tagAttached) {
            this.tagAssociation.detach(this.serverTagId, this.clusterDynamicId);
            System.out.println("Cluster: " + this.clusterDynamicId + " untagged");
        }
        if (this.serverTagId != null) {
            this.deleteTag(this.serverTagId);
            System.out.println("Tag deleted; Id: " + this.serverTagId);
        }
        if (this.assetCategoryId != null) {
            this.deleteTagCategory(this.assetCategoryId);
            System.out.println("Tag category deleted; Id: " + this.assetCategoryId);
        }
    }

    private String createTagCategory(String name, String description, CategoryModel.Cardinality cardinality) {
        CategoryTypes.CreateSpec createSpec = new CategoryTypes.CreateSpec();
        createSpec.setName(name);
        createSpec.setDescription(description);
        createSpec.setCardinality(cardinality);
        HashSet associableTypes = new HashSet();
        createSpec.setAssociableTypes(associableTypes);
        return this.categoryService.create(createSpec);
    }

    private void deleteTagCategory(String categoryId) {
        this.categoryService.delete(categoryId);
    }

    private String createTag(String name, String description, String categoryId) {
        TagTypes.CreateSpec spec = new TagTypes.CreateSpec();
        spec.setName(name);
        spec.setDescription(description);
        spec.setCategoryId(categoryId);
        return this.taggingService.create(spec);
    }

    private void updateTag(String tagId, String description) {
        TagTypes.UpdateSpec updateSpec = new TagTypes.UpdateSpec();
        updateSpec.setDescription(description);
        this.taggingService.update(tagId, updateSpec);
    }

    private void deleteTag(String tagId) {
        this.taggingService.delete(tagId);
    }

    public static void main(String[] args) throws Exception {
        new TaggingWorkflow().execute(args);
    }
}

