/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.sso.soaphandlers;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WssHelper {
    static final ObjectFactory wsseObjFactory = new ObjectFactory();

    public static String getNodeProperty(Node node, String propertyName) {
        return node.getAttributes().getNamedItem(propertyName).getNodeValue();
    }

    public static Node getSecurityElement(SOAPHeader header) {
        NodeList targetElement = header.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        if (targetElement == null || targetElement.getLength() == 0) {
            JAXBElement value = wsseObjFactory.createSecurity(wsseObjFactory.createSecurityHeaderType());
            Element headerNode = WssHelper.marshallJaxbElement(value).getDocumentElement();
            return header.appendChild(header.getOwnerDocument().importNode(headerNode, true));
        }
        if (targetElement.getLength() > 1) {
            throw new RuntimeException("Error inserting Security header into the SOAP message. Too many Security found.");
        }
        return targetElement.item(0);
    }

    public static SOAPHeader getSOAPHeader(SOAPMessageContext smc) throws SOAPException {
        return smc.getMessage().getSOAPPart().getEnvelope().getHeader() == null ? smc.getMessage().getSOAPPart().getEnvelope().addHeader() : smc.getMessage().getSOAPPart().getEnvelope().getHeader();
    }

    public static boolean isHoKToken(Node token) {
        if (WssHelper.isSamlToken(token)) {
            NodeList elements = ((Element)token).getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmation");
            if (elements.getLength() != 1) {
                throw new IllegalArgumentException("Token provided is not a SAML token");
            }
            Node value = elements.item(0).getAttributes().getNamedItem("Method");
            return "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equalsIgnoreCase(value.getNodeValue());
        }
        throw new RuntimeException("The Node does not represnt a SAML token");
    }

    public static boolean isOutgoingMessage(SOAPMessageContext smc) {
        Boolean outboundProperty = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        return outboundProperty;
    }

    public static boolean isSamlToken(Node token) {
        boolean isValid = false;
        isValid = "urn:oasis:names:tc:SAML:2.0:assertion".equalsIgnoreCase(token.getNamespaceURI()) && "assertion".equalsIgnoreCase(token.getLocalName());
        return isValid;
    }

    public static final <T> Document marshallJaxbElement(JAXBElement<T> jaxbElement) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document result = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.oasis_open.docs.ws_sx.ws_trust._200512:org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0:org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0");
            result = dbf.newDocumentBuilder().newDocument();
            jaxbContext.createMarshaller().marshal(jaxbElement, (Node)result);
        }
        catch (JAXBException jaxbException) {
            jaxbException.printStackTrace();
            throw new RuntimeException("Error marshalling JAXB document", jaxbException);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new RuntimeException("Error marshalling JAXB document", pce);
        }
        return result;
    }

    public static void printMessage(SOAPMessageContext smc) {
        try {
            System.out.println("*********Message Start********");
            System.out.println("This is a " + ((Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound") != false ? "Outbound request" : "Inbound response"));
            smc.getMessage().writeTo((OutputStream)System.out);
            System.out.println("*********Message End**********");
        }
        catch (SOAPException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void printToken(Element token) {
        if (WssHelper.isSamlToken(token)) {
            System.out.println("Token details:");
            System.out.println("\tAssertionId = " + WssHelper.getNodeProperty(token, "ID"));
            System.out.println("\tToken type = " + (WssHelper.isHoKToken(token) ? "Holder-Of-Key" : "Bearer"));
            System.out.println("\tIssued On = " + WssHelper.getNodeProperty(token, "IssueInstant"));
        } else {
            System.out.println("Invalid token");
        }
    }
}

