/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.sso;

import com.rsa.names._2009._12.product.riat.wsdl.STSService;
import com.rsa.names._2009._12.product.riat.wsdl.STSServicePortType;
import com.vmware.vapi.saml.DefaultTokenFactory;
import com.vmware.vapi.saml.SamlToken;
import com.vmware.vapi.saml.exception.InvalidTokenException;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import org.oasis_open.docs.ws_sx.ws_trust._200512.LifetimeType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RenewingType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.AttributedDateTime;
import org.w3c.dom.Element;
import vmware.samples.common.SslUtil;
import vmware.samples.sso.soaphandlers.HeaderHandlerResolver;
import vmware.samples.sso.soaphandlers.SamlTokenExtractionHandler;
import vmware.samples.sso.soaphandlers.TimeStampHandler;
import vmware.samples.sso.soaphandlers.UserCredentialHandler;

public class SsoHelper {
    public static SamlToken getSamlBearerToken(String ssoUrl, String username, String password) throws DatatypeConfigurationException, InvalidTokenException {
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        SslUtil.trustAllHttpsCertificates();
        STSService stsService = new STSService();
        HeaderHandlerResolver headerResolver = new HeaderHandlerResolver();
        headerResolver.addHandler(new TimeStampHandler());
        UserCredentialHandler ucHandler = new UserCredentialHandler(username, password);
        SamlTokenExtractionHandler sbHandler = new SamlTokenExtractionHandler();
        headerResolver.addHandler(ucHandler);
        headerResolver.addHandler(sbHandler);
        stsService.setHandlerResolver((HandlerResolver)headerResolver);
        STSServicePortType stsPort = stsService.getSTSServicePort();
        RequestSecurityTokenType tokenType = new RequestSecurityTokenType();
        LifetimeType lifetime = new LifetimeType();
        DatatypeFactory dtFactory = DatatypeFactory.newInstance();
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        XMLGregorianCalendar xmlCalendar = dtFactory.newXMLGregorianCalendar(cal);
        AttributedDateTime created = new AttributedDateTime();
        created.setValue(xmlCalendar.toXMLFormat());
        AttributedDateTime expires = new AttributedDateTime();
        xmlCalendar.add(dtFactory.newDuration(1800000L));
        expires.setValue(xmlCalendar.toXMLFormat());
        lifetime.setCreated(created);
        lifetime.setExpires(expires);
        tokenType.setTokenType("urn:oasis:names:tc:SAML:2.0:assertion");
        tokenType.setRequestType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue");
        tokenType.setLifetime(lifetime);
        tokenType.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        tokenType.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        tokenType.setDelegatable(Boolean.valueOf(true));
        RenewingType renewing = new RenewingType();
        renewing.setAllow(Boolean.FALSE);
        renewing.setOK(Boolean.FALSE);
        tokenType.setRenewing(renewing);
        Map reqContext = ((BindingProvider)stsPort).getRequestContext();
        reqContext.put("javax.xml.ws.service.endpoint.address", ssoUrl);
        stsPort.issue(tokenType);
        Element bearerTokenElement = sbHandler.getToken();
        return DefaultTokenFactory.createTokenFromDom((Element)bearerTokenElement);
    }
}

