/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.sso;

import com.vmware.vsphereautomation.lookup.LookupServiceContent;
import com.vmware.vsphereautomation.lookup.LookupServiceRegistrationAttribute;
import com.vmware.vsphereautomation.lookup.LookupServiceRegistrationEndpoint;
import com.vmware.vsphereautomation.lookup.LookupServiceRegistrationEndpointType;
import com.vmware.vsphereautomation.lookup.LookupServiceRegistrationFilter;
import com.vmware.vsphereautomation.lookup.LookupServiceRegistrationInfo;
import com.vmware.vsphereautomation.lookup.LookupServiceRegistrationServiceType;
import com.vmware.vsphereautomation.lookup.LsPortType;
import com.vmware.vsphereautomation.lookup.LsService;
import com.vmware.vsphereautomation.lookup.ManagedObjectReference;
import com.vmware.vsphereautomation.lookup.RuntimeFaultFaultMsg;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.w3c.dom.Element;
import vmware.samples.common.SslUtil;

public class LookupServiceHelper {
    private final String lookupServiceUrl;
    private final LsPortType lsPort;
    private final ManagedObjectReference serviceInstanceRef;
    private final LookupServiceContent lookupServiceContent;
    private final ManagedObjectReference serviceRegistration;

    public String getLookupServiceUrl() {
        return this.lookupServiceUrl;
    }

    public LsPortType getLsPort() {
        return this.lsPort;
    }

    public ManagedObjectReference getServiceInstanceRef() {
        return this.serviceInstanceRef;
    }

    public LookupServiceContent getLookupServiceContent() {
        return this.lookupServiceContent;
    }

    public ManagedObjectReference getServiceRegistration() {
        return this.serviceRegistration;
    }

    public LookupServiceHelper(String lookupServiceUrl) throws RuntimeFaultFaultMsg {
        this(lookupServiceUrl, null);
    }

    public LookupServiceHelper(String lookupServiceUrl, Element samlBearerTokenElement) throws RuntimeFaultFaultMsg {
        try {
            new URL(lookupServiceUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed lookup service url - " + e);
        }
        this.lookupServiceUrl = lookupServiceUrl;
        SslUtil.trustAllHttpsCertificates();
        this.serviceInstanceRef = new ManagedObjectReference();
        this.serviceInstanceRef.setType("LookupServiceInstance");
        this.serviceInstanceRef.setValue("ServiceInstance");
        LsService lookupService = new LsService();
        this.lsPort = lookupService.getLsPort();
        ((BindingProvider)this.lsPort).getRequestContext().put("javax.xml.ws.service.endpoint.address", lookupServiceUrl);
        this.lookupServiceContent = this.lsPort.retrieveServiceContent(this.serviceInstanceRef);
        this.serviceRegistration = this.lookupServiceContent.getServiceRegistration();
    }

    public String findSsoServer() throws RuntimeFaultFaultMsg {
        Map<String, String> result = this.getServiceEndpointUrl("com.vmware.cis", "cs.identity", "com.vmware.cis.cs.identity.sso", "wsTrust", null);
        return result.values().toArray(new String[0])[0];
    }

    public Map<String, String> findSsoUrls() throws RuntimeFaultFaultMsg {
        return this.getServiceEndpointUrl("com.vmware.cis", "cs.identity", "com.vmware.cis.cs.identity.sso", "wsTrust", null);
    }

    public String findSsoUrl() throws RuntimeFaultFaultMsg {
        Map<String, String> result = this.getServiceEndpointUrl("com.vmware.cis", "cs.identity", "com.vmware.cis.cs.identity.sso", "wsTrust", null);
        return result.values().toArray(new String[0])[0];
    }

    public Map<String, String> findVapiUrls() throws RuntimeFaultFaultMsg {
        return this.getServiceEndpointUrl("com.vmware.cis", "cs.vapi", "com.vmware.vapi.endpoint", "vapi.json.https.public", null);
    }

    public String findVapiUrl(String nodeId) throws RuntimeFaultFaultMsg {
        Map<String, String> result = this.getServiceEndpointUrl("com.vmware.cis", "cs.vapi", "com.vmware.vapi.endpoint", "vapi.json.https.public", nodeId);
        return result.get(nodeId);
    }

    public Map<String, String> findVimUrls() throws RuntimeFaultFaultMsg {
        return this.getServiceEndpointUrl("com.vmware.cis", "vcenterserver", "com.vmware.vim", "vmomi", null);
    }

    public String findVimUrl(String nodeId) throws RuntimeFaultFaultMsg {
        Map<String, String> result = this.getServiceEndpointUrl("com.vmware.cis", "vcenterserver", "com.vmware.vim", "vmomi", nodeId);
        return result.get(nodeId);
    }

    public Map<String, String> findVimPbmUrls() throws RuntimeFaultFaultMsg {
        return this.getServiceEndpointUrl("com.vmware.vim.sms", "sms", "com.vmware.vim.pbm", "https", null);
    }

    public String findVimPbmUrl(String nodeId) throws RuntimeFaultFaultMsg {
        Map<String, String> result = this.getServiceEndpointUrl("com.vmware.vim.sms", "sms", "com.vmware.vim.pbm", "https", nodeId);
        return result.get(nodeId);
    }

    public Map<String, String> findMgmtNodes() throws RuntimeFaultFaultMsg {
        LookupServiceRegistrationServiceType filterServiceType = new LookupServiceRegistrationServiceType();
        filterServiceType.setProduct("com.vmware.cis");
        filterServiceType.setType("vcenterserver");
        LookupServiceRegistrationEndpointType filterEndpointType = new LookupServiceRegistrationEndpointType();
        filterEndpointType.setProtocol("vmomi");
        filterEndpointType.setType("com.vmware.vim");
        LookupServiceRegistrationFilter filterCriteria = new LookupServiceRegistrationFilter();
        filterCriteria.setServiceType(filterServiceType);
        filterCriteria.setEndpointType(filterEndpointType);
        HashMap<String, String> retVal = new HashMap<String, String>();
        List results = this.lsPort.list(this.serviceRegistration, filterCriteria);
        for (LookupServiceRegistrationInfo service : results) {
            for (LookupServiceRegistrationAttribute serviceAttr : service.getServiceAttributes()) {
                if (!"com.vmware.vim.vcenter.instanceName".equals(serviceAttr.getKey())) continue;
                retVal.put(serviceAttr.getValue(), service.getNodeId());
            }
        }
        return retVal;
    }

    public String getMgmtNodeId(String instanceName) throws RuntimeFaultFaultMsg {
        Map<String, String> nodes = this.findMgmtNodes();
        return nodes.get(instanceName);
    }

    public String getMgmtNodeInstanceName(String nodeId) throws RuntimeFaultFaultMsg {
        Map<String, String> nodes = this.findMgmtNodes();
        for (String name : nodes.keySet()) {
            if (!nodeId.equals(nodes.get(name))) continue;
            return name;
        }
        return null;
    }

    public String getDefaultMgmtNode() throws RuntimeFaultFaultMsg, MultipleManagementNodeException {
        Map<String, String> nodes = this.findMgmtNodes();
        if (nodes.size() == 1) {
            return nodes.values().toArray(new String[0])[0];
        }
        if (nodes.size() > 1) {
            throw new MultipleManagementNodeException(nodes);
        }
        throw new RuntimeException("No Management Node found");
    }

    private Map<String, String> getServiceEndpointUrl(String productType, String serviceType, String endpointType, String endpointProtocol, String mgmtNodeId) throws RuntimeFaultFaultMsg {
        LookupServiceRegistrationServiceType filterServiceType = new LookupServiceRegistrationServiceType();
        filterServiceType.setProduct(productType);
        filterServiceType.setType(serviceType);
        LookupServiceRegistrationEndpointType filterEndpointType = new LookupServiceRegistrationEndpointType();
        filterEndpointType.setProtocol(endpointProtocol);
        filterEndpointType.setType(endpointType);
        LookupServiceRegistrationFilter filterCriteria = new LookupServiceRegistrationFilter();
        filterCriteria.setServiceType(filterServiceType);
        filterCriteria.setEndpointType(filterEndpointType);
        if (mgmtNodeId != null) {
            filterCriteria.setNodeId(mgmtNodeId);
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        List results = this.lsPort.list(this.serviceRegistration, filterCriteria);
        for (LookupServiceRegistrationInfo lookupServiceRegistrationInfo : results) {
            LookupServiceRegistrationEndpoint lookupServiceRegistrationEndpoint = (LookupServiceRegistrationEndpoint)lookupServiceRegistrationInfo.getServiceEndpoints().get(0);
            if (lookupServiceRegistrationEndpoint == null) continue;
            String nodeId = lookupServiceRegistrationInfo.getNodeId();
            String url = lookupServiceRegistrationEndpoint.getUrl();
            retVal.put(nodeId, url);
        }
        return retVal;
    }

    private class MultipleManagementNodeException
    extends Exception {
        private static final long serialVersionUID = -6179103331243513328L;
        Map<String, String> nodes;

        public MultipleManagementNodeException(Map<String, String> nodes) {
            this.nodes = nodes;
        }

        @Override
        public String getMessage() {
            String separator = System.getProperty("line.separator");
            String message = "Multiple Management Node Found on server";
            for (String name : this.nodes.keySet()) {
                message = message + String.format(separator + "Node name: %s uuid: %s", name, this.nodes.get(name));
            }
            return message;
        }
    }
}

