/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.contentlibrary.ovfdeploy;

import com.vmware.content.library.ItemTypes;
import com.vmware.vcenter.ovf.LibraryItemTypes;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.ManagedObjectReference;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.Option;
import org.apache.commons.lang.StringUtils;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.common.vim.helpers.VimUtil;
import vmware.samples.common.vim.helpers.VmVappPowerOps;
import vmware.samples.contentlibrary.client.ClsApiClient;

public class DeployOvfTemplate
extends SamplesAbstractBase {
    private String libItemName;
    private String clusterName;
    private String vmName;
    private ClsApiClient client;
    private VmVappPowerOps vmPowerOps;
    private ManagedObjectReference vmMoRef;

    @Override
    protected void parseArgs(String[] args) {
        Option clusterNameOption = Option.builder().longOpt("clustername").desc("The name of the VM to be created in the cluster. Defaults to a generated VM name based on the current date if not specified").required(true).hasArg().argName("CLUSTER").build();
        Option libItemNameOption = Option.builder().longOpt("libitemname").desc("The name of the library item todeploy. The library item should contain an OVF package").required(true).hasArg().argName("CONTENT LIBRARY").build();
        List<Option> optionList = Arrays.asList(clusterNameOption, libItemNameOption);
        super.parseArgs(optionList, args);
        this.clusterName = (String)this.parsedOptions.get("clustername");
        this.libItemName = (String)this.parsedOptions.get("libitemname");
    }

    @Override
    protected void setup() throws Exception {
        this.client = new ClsApiClient(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig);
        this.vmPowerOps = new VmVappPowerOps(this.vimAuthHelper.getVimPort(), this.vimAuthHelper.getServiceContent());
        if (StringUtils.isBlank((String)this.vmName)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-kkmmss");
            this.vmName = "VM-" + sdf.format(new Date());
        }
    }

    @Override
    protected void run() throws Exception {
        ManagedObjectReference clusterMoRef = VimUtil.getCluster(this.vimAuthHelper.getVimPort(), this.vimAuthHelper.getServiceContent(), this.clusterName);
        assert (clusterMoRef != null);
        System.out.println("Cluster MoRef : " + clusterMoRef.getType() + " : " + clusterMoRef.getValue());
        List<DynamicProperty> dynamicProps = VimUtil.getProperties(this.vimAuthHelper.getVimPort(), this.vimAuthHelper.getServiceContent(), clusterMoRef, clusterMoRef.getType(), Arrays.asList("resourcePool"));
        assert (dynamicProps != null && dynamicProps.size() > 0);
        ManagedObjectReference rootResPoolMoRef = (ManagedObjectReference)dynamicProps.get(0).getVal();
        System.out.println("Resource pool MoRef : " + rootResPoolMoRef.getType() + " : " + rootResPoolMoRef.getValue());
        ItemTypes.FindSpec findSpec = new ItemTypes.FindSpec();
        findSpec.setName(this.libItemName);
        List itemIds = this.client.itemService().find(findSpec);
        assert (!itemIds.isEmpty()) : "Unable to find a library item with name: " + this.libItemName;
        String itemId = (String)itemIds.get(0);
        System.out.println("Library item ID : " + itemId);
        System.out.println("Deploying Vm : " + this.vmName);
        String vmId = this.deployVMFromOvfItem(rootResPoolMoRef, this.vmName, itemId);
        assert (vmId != null);
        System.out.println("Vm created : " + vmId);
        this.vmMoRef = new ManagedObjectReference();
        this.vmMoRef.setType("VirtualMachine");
        this.vmMoRef.setValue(vmId);
        this.vmPowerOps.powerOnVM(this.vmName, this.vmMoRef);
    }

    @Override
    protected void cleanup() throws Exception {
        if (this.vmMoRef != null) {
            this.vmPowerOps.powerOffVM(this.vmName, this.vmMoRef);
            VimUtil.deleteManagedEntity(this.vimAuthHelper.getVimPort(), this.vimAuthHelper.getServiceContent(), this.vmMoRef);
        }
    }

    private String deployVMFromOvfItem(ManagedObjectReference rootResPoolMoRef, String vmName, String libItemId) {
        LibraryItemTypes.DeploymentTarget deploymentTarget = new LibraryItemTypes.DeploymentTarget();
        deploymentTarget.setResourcePoolId(rootResPoolMoRef.getValue());
        LibraryItemTypes.ResourcePoolDeploymentSpec deploymentSpec = new LibraryItemTypes.ResourcePoolDeploymentSpec();
        deploymentSpec.setName(this.vmName);
        deploymentSpec.setAcceptAllEULA(true);
        LibraryItemTypes.OvfSummary ovfSummary = this.client.ovfLibraryItemService().filter(libItemId, deploymentTarget);
        deploymentSpec.setAnnotation(ovfSummary.getAnnotation());
        LibraryItemTypes.DeploymentResult deploymentResult = this.client.ovfLibraryItemService().deploy(UUID.randomUUID().toString(), libItemId, deploymentTarget, deploymentSpec);
        if (deploymentResult.getSucceeded()) {
            return deploymentResult.getResourceId().getId();
        }
        throw new RuntimeException(deploymentResult.getError().toString());
    }

    public static void main(String[] args) throws Exception {
        new DeployOvfTemplate().execute(args);
    }
}

