/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.contentlibrary.helpers;

import com.vmware.content.library.Item;
import com.vmware.content.library.item.DownloadSession;
import com.vmware.content.library.item.DownloadSessionModel;
import com.vmware.content.library.item.downloadsession.FileTypes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.UUID;
import vmware.samples.common.HttpClient;

public class ItemDownloadHelper {
    private static final long SESSION_FILE_TIMEOUT = 360L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performDownload(DownloadSession downloadService, com.vmware.content.library.item.downloadsession.File downloadFileService, Item libItemService, String libraryItemId, File dir) {
        System.out.println("Download start for Library Item : " + libraryItemId + " Name : " + libItemService.get(libraryItemId).getName());
        String downloadSessionId = null;
        try {
            downloadSessionId = ItemDownloadHelper.createDownloadSession(downloadService, libraryItemId, UUID.randomUUID().toString());
            ItemDownloadHelper.downloadFiles(downloadService, downloadFileService, downloadSessionId, dir);
        }
        catch (Throwable throwable) {
            downloadService.delete(downloadSessionId);
            throw throwable;
        }
        downloadService.delete(downloadSessionId);
    }

    private static void downloadFiles(DownloadSession downloadService, com.vmware.content.library.item.downloadsession.File downloadFileService, String sessionId, File dir) {
        HttpClient httpClient = new HttpClient(true);
        List downloadFileInfos = downloadFileService.list(sessionId);
        for (FileTypes.Info downloadFileInfo : downloadFileInfos) {
            ItemDownloadHelper.prepareForDownload(downloadService, downloadFileService, sessionId, downloadFileInfo);
            downloadFileInfo = downloadFileService.get(sessionId, downloadFileInfo.getName());
            System.out.println("Download File Info : " + downloadFileInfo);
            try {
                URI downloadUri = downloadFileInfo.getDownloadEndpoint().getUri();
                String downloadUrl = downloadUri.toURL().toString();
                System.out.println("Download from URL : " + downloadUrl);
                InputStream inputStream = httpClient.downloadFile(downloadUrl);
                String fileName = downloadFileInfo.getName();
                ItemDownloadHelper.downloadFile(inputStream, dir.getAbsolutePath() + System.getProperty("file.separator") + fileName);
            }
            catch (MalformedURLException e) {
                System.out.println("Failed to download due to IOException!" + e);
                throw new RuntimeException("Failed to download due to IOException!", e);
            }
            catch (IOException e) {
                System.out.println("IO exception during download" + e);
                throw new RuntimeException("Failed to download due to IOException!", e);
            }
        }
    }

    private static void prepareForDownload(DownloadSession downloadService, com.vmware.content.library.item.downloadsession.File downloadFileService, String sessionId, FileTypes.Info downloadFileInfo) {
        System.out.println("Download File name : " + downloadFileInfo.getName());
        System.out.println("Download File Prepare Status : " + downloadFileInfo.getStatus());
        downloadFileService.prepare(sessionId, downloadFileInfo.getName(), FileTypes.EndpointType.HTTPS);
        ItemDownloadHelper.waitForDownloadFileReady(downloadService, downloadFileService, sessionId, downloadFileInfo.getName(), FileTypes.PrepareStatus.PREPARED, 360L);
    }

    private static void waitForDownloadFileReady(DownloadSession downloadService, com.vmware.content.library.item.downloadsession.File downloadFileService, String sessionId, String fileName, FileTypes.PrepareStatus expectedStatus, long timeOut) {
        Long endTime = System.currentTimeMillis() + timeOut * 1000L;
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FileTypes.Info fileInfo = downloadFileService.get(sessionId, fileName);
        FileTypes.PrepareStatus currentStatus = fileInfo.getStatus();
        if (currentStatus == expectedStatus) {
            return;
        }
        while (endTime > System.currentTimeMillis()) {
            fileInfo = downloadFileService.get(sessionId, fileName);
            currentStatus = fileInfo.getStatus();
            System.out.println("Current Status : " + currentStatus);
            if (currentStatus == expectedStatus) {
                return;
            }
            if (currentStatus != FileTypes.PrepareStatus.ERROR) continue;
            System.out.println("DownloadSession Info : " + downloadService.get(sessionId));
            System.out.println("list on the downloadSessionFile : " + downloadFileService.list(sessionId));
            throw new RuntimeException("Error while waiting for download file status to be PREPARED...");
        }
        throw new RuntimeException("Timeout waiting for download file status to be PREPARED,  status : " + currentStatus.toString());
    }

    private static String createDownloadSession(DownloadSession downloadService, String libraryItemId, String clientToken) {
        DownloadSessionModel downloadSpec = new DownloadSessionModel();
        downloadSpec.setLibraryItemId(libraryItemId);
        String sessionId = downloadService.create(clientToken, downloadSpec);
        return sessionId;
    }

    private static void downloadFile(InputStream inputStream, String fullPath) throws IOException {
        Files.copy(inputStream, Paths.get(fullPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }
}

