/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.contentlibrary.helpers;

import com.vmware.content.LibraryModel;
import com.vmware.content.library.ItemModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import vmware.samples.contentlibrary.client.ClsApiClient;

public class ClsApiHelper {
    private final ClsApiClient client;

    public ClsApiHelper(ClsApiClient client) {
        this.client = client;
    }

    public boolean waitForLibrarySync(String pubLibraryId, String subLibraryId, long timeout, TimeUnit unit) throws InterruptedException {
        return new SyncHelper(timeout, unit).waitForLibrarySync(pubLibraryId, subLibraryId);
    }

    public boolean waitForItemSync(String subItemId, long timeout, TimeUnit unit) throws InterruptedException {
        return new SyncHelper(timeout, unit).waitForItemSync(subItemId);
    }

    private class SyncHelper {
        private static final long WAIT_INTERVAL_MS = 1000L;
        private final long startTime = System.nanoTime();
        private final long timeoutNano;

        public SyncHelper(long timeout, TimeUnit unit) {
            this.timeoutNano = TimeUnit.NANOSECONDS.convert(timeout, unit);
        }

        public boolean waitForLibrarySync(String pubLibraryId, String subLibraryId) throws InterruptedException {
            if (!this.waitForSameItems(pubLibraryId, subLibraryId)) {
                return false;
            }
            List subItemIds = ClsApiHelper.this.client.itemService().list(subLibraryId);
            for (String subItemId : subItemIds) {
                if (this.waitForItemSync(subItemId)) continue;
                return false;
            }
            return this.waitForLibraryLastSyncTime(subLibraryId);
        }

        public boolean waitForItemSync(String subItemId) throws InterruptedException {
            boolean isSynced = false;
            String pubItemId = ClsApiHelper.this.client.itemService().get(subItemId).getSourceId();
            ItemModel pubItem = ClsApiHelper.this.client.itemService().get(pubItemId);
            while (this.notTimedOut()) {
                ItemModel subItem = ClsApiHelper.this.client.itemService().get(subItemId);
                if (this.isSubscribedItemLatest(pubItem, subItem)) {
                    isSynced = true;
                    break;
                }
                Thread.sleep(1000L);
            }
            return isSynced;
        }

        private boolean waitForSameItems(String pubLibraryId, String subLibraryId) throws InterruptedException {
            boolean isSynced = false;
            List pubItemIds = ClsApiHelper.this.client.itemService().list(pubLibraryId);
            while (this.notTimedOut()) {
                List subItemIds = ClsApiHelper.this.client.itemService().list(subLibraryId);
                if (this.hasSameItems(pubItemIds, subItemIds)) {
                    isSynced = true;
                    break;
                }
                Thread.sleep(1000L);
            }
            return isSynced;
        }

        private boolean hasSameItems(List<String> pubItemIds, List<String> subItemIds) {
            if (pubItemIds.size() != subItemIds.size()) {
                return false;
            }
            ArrayList<String> syncedIds = new ArrayList<String>(pubItemIds.size());
            for (String subItemId : subItemIds) {
                ItemModel subItem = ClsApiHelper.this.client.itemService().get(subItemId);
                String sourceId = subItem.getSourceId();
                if (syncedIds.contains(subItemId) || !pubItemIds.contains(sourceId)) continue;
                syncedIds.add(subItemId);
            }
            return pubItemIds.size() == syncedIds.size();
        }

        private boolean waitForLibraryLastSyncTime(String subLibraryId) throws InterruptedException {
            boolean isSynced = false;
            while (this.notTimedOut()) {
                LibraryModel library = ClsApiHelper.this.client.subscribedLibraryService().get(subLibraryId);
                if (library.getLastSyncTime() != null) {
                    isSynced = true;
                    break;
                }
                Thread.sleep(1000L);
            }
            return isSynced;
        }

        private boolean isSubscribedItemLatest(ItemModel pubItem, ItemModel subItem) {
            String metadataVersion = pubItem.getMetadataVersion();
            String contentVersion = pubItem.getContentVersion();
            return subItem.getMetadataVersion().equals(metadataVersion) && subItem.getContentVersion().equals(contentVersion);
        }

        private boolean notTimedOut() {
            long elapsedTime = System.nanoTime() - this.startTime;
            return elapsedTime < this.timeoutNano;
        }
    }
}

