/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.common.vim.helpers;

import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VimPortType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import vmware.samples.common.vim.helpers.WaitForValues;

public class VimUtil {
    public static ServiceContent getServiceContent(VimPortType vimPortType) throws RuntimeFaultFaultMsg {
        ManagedObjectReference serviceInstance = new ManagedObjectReference();
        serviceInstance.setType("ServiceInstance");
        serviceInstance.setValue("ServiceInstance");
        return vimPortType.retrieveServiceContent(serviceInstance);
    }

    public static ManagedObjectReference getCluster(VimPortType vimPortType, ServiceContent serviceContent, String clusterName) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, NotFoundFaultMsg {
        SelectionSpec folderToFolderSelection = new SelectionSpec();
        folderToFolderSelection.setName("folderToFolder");
        SelectionSpec dcToHostFolderSelection = new SelectionSpec();
        dcToHostFolderSelection.setName("dcToHostFolder");
        TraversalSpec dcToHostFolderTraversal = new TraversalSpec();
        dcToHostFolderTraversal.setName("dcToHostFolder");
        dcToHostFolderTraversal.setPath("hostFolder");
        dcToHostFolderTraversal.setType("Datacenter");
        dcToHostFolderTraversal.getSelectSet().addAll(Arrays.asList(folderToFolderSelection));
        dcToHostFolderTraversal.setSkip(Boolean.valueOf(false));
        TraversalSpec folderToFolderTraversal = new TraversalSpec();
        folderToFolderTraversal.setName("folderToFolder");
        folderToFolderTraversal.setPath("childEntity");
        folderToFolderTraversal.setType("Folder");
        folderToFolderTraversal.getSelectSet().addAll(Arrays.asList(folderToFolderSelection, dcToHostFolderSelection));
        folderToFolderTraversal.setSkip(Boolean.valueOf(false));
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.getPathSet().addAll(Arrays.asList("name"));
        propertySpec.setType("ClusterComputeResource");
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(serviceContent.getRootFolder());
        objectSpec.getSelectSet().addAll(Arrays.asList(folderToFolderTraversal, dcToHostFolderTraversal));
        objectSpec.setSkip(Boolean.valueOf(false));
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().addAll(Arrays.asList(propertySpec));
        propertyFilterSpec.getObjectSet().addAll(Arrays.asList(objectSpec));
        ManagedObjectReference morPropertyCollector = serviceContent.getPropertyCollector();
        List objectContents = vimPortType.retrieveProperties(morPropertyCollector, Arrays.asList(propertyFilterSpec));
        for (ObjectContent objectContent : objectContents) {
            ManagedObjectReference clusterManagedObjectReference = objectContent.getObj();
            List dynamicProperties = objectContent.getPropSet();
            for (DynamicProperty dynamicProperty : dynamicProperties) {
                if (!dynamicProperty.getName().equalsIgnoreCase("name") || !dynamicProperty.getVal().toString().equalsIgnoreCase(clusterName)) continue;
                return clusterManagedObjectReference;
            }
        }
        throw new NotFoundFaultMsg("Cluster Not Found - " + clusterName, new NotFound());
    }

    public static List<ManagedObjectReference> getHosts(VimPortType vimPort, ServiceContent serviceContent, ManagedObjectReference cluster) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        PropertySpec hostPropSpec = new PropertySpec();
        hostPropSpec.setType("HostSystem");
        hostPropSpec.setAll(Boolean.valueOf(false));
        hostPropSpec.getPathSet().addAll(Collections.emptyList());
        TraversalSpec hostTSpec = new TraversalSpec();
        hostTSpec.setType("ComputeResource");
        hostTSpec.setPath("host");
        hostTSpec.setName("hosts");
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName(hostTSpec.getName());
        hostTSpec.getSelectSet().add(selectionSpec);
        ArrayList<ObjectSpec> ospecList = new ArrayList<ObjectSpec>();
        ObjectSpec ospec = new ObjectSpec();
        ospec.setObj(cluster);
        ospec.setSkip(Boolean.valueOf(true));
        ospec.getSelectSet().addAll(Arrays.asList(hostTSpec));
        ospecList.add(ospec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().addAll(Arrays.asList(hostPropSpec));
        propertyFilterSpec.getObjectSet().addAll(ospecList);
        ArrayList<PropertyFilterSpec> listpfs = new ArrayList<PropertyFilterSpec>(1);
        listpfs.add(propertyFilterSpec);
        List<ObjectContent> listObjContent = VimUtil.retrievePropertiesAllObjects(vimPort, serviceContent.getPropertyCollector(), listpfs);
        ArrayList<ManagedObjectReference> hosts = new ArrayList<ManagedObjectReference>();
        if (listObjContent != null) {
            for (ObjectContent oc : listObjContent) {
                hosts.add(oc.getObj());
            }
        }
        return hosts;
    }

    public static ManagedObjectReference getVM(VimPortType vimPortType, ServiceContent serviceContent, String vmname) throws NotFoundFaultMsg, InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        ManagedObjectReference propCollectorRef = serviceContent.getPropertyCollector();
        ManagedObjectReference rootFolderRef = serviceContent.getRootFolder();
        ManagedObjectReference retVmRef = null;
        TraversalSpec tSpec = VimUtil.getVMTraversalSpec();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.getPathSet().add("name");
        propertySpec.setType("VirtualMachine");
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(rootFolderRef);
        objectSpec.setSkip(Boolean.TRUE);
        objectSpec.getSelectSet().add(tSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> listpfs = new ArrayList<PropertyFilterSpec>(1);
        listpfs.add(propertyFilterSpec);
        List<ObjectContent> listobjcont = VimUtil.retrievePropertiesAllObjects(vimPortType, propCollectorRef, listpfs);
        if (listobjcont != null) {
            for (ObjectContent oc : listobjcont) {
                ManagedObjectReference mr = oc.getObj();
                String vmnm = null;
                List dps = oc.getPropSet();
                if (dps != null) {
                    for (DynamicProperty dp : dps) {
                        vmnm = (String)dp.getVal();
                    }
                }
                if (vmnm == null || !vmnm.equals(vmname)) continue;
                retVmRef = mr;
                break;
            }
        }
        if (retVmRef == null) {
            throw new NotFoundFaultMsg("VM Not Found - " + vmname, new NotFound());
        }
        return retVmRef;
    }

    private static TraversalSpec getVMTraversalSpec() {
        TraversalSpec vAppToVM = new TraversalSpec();
        vAppToVM.setName("vAppToVM");
        vAppToVM.setType("VirtualApp");
        vAppToVM.setPath("vm");
        TraversalSpec vAppToVApp = new TraversalSpec();
        vAppToVApp.setName("vAppToVApp");
        vAppToVApp.setType("VirtualApp");
        vAppToVApp.setPath("resourcePool");
        SelectionSpec vAppRecursion = new SelectionSpec();
        vAppRecursion.setName("vAppToVApp");
        SelectionSpec vmInVApp = new SelectionSpec();
        vmInVApp.setName("vAppToVM");
        ArrayList<SelectionSpec> vAppToVMSS = new ArrayList<SelectionSpec>();
        vAppToVMSS.add(vAppRecursion);
        vAppToVMSS.add(vmInVApp);
        vAppToVApp.getSelectSet().addAll(vAppToVMSS);
        SelectionSpec sSpec = new SelectionSpec();
        sSpec.setName("VisitFolders");
        TraversalSpec dataCenterToVMFolder = new TraversalSpec();
        dataCenterToVMFolder.setName("DataCenterToVMFolder");
        dataCenterToVMFolder.setType("Datacenter");
        dataCenterToVMFolder.setPath("vmFolder");
        dataCenterToVMFolder.setSkip(Boolean.valueOf(false));
        dataCenterToVMFolder.getSelectSet().add(sSpec);
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("VisitFolders");
        traversalSpec.setType("Folder");
        traversalSpec.setPath("childEntity");
        traversalSpec.setSkip(Boolean.valueOf(false));
        ArrayList<Object> sSpecArr = new ArrayList<Object>();
        sSpecArr.add(sSpec);
        sSpecArr.add(dataCenterToVMFolder);
        sSpecArr.add(vAppToVM);
        sSpecArr.add(vAppToVApp);
        traversalSpec.getSelectSet().addAll(sSpecArr);
        return traversalSpec;
    }

    public static List<ObjectContent> retrievePropertiesAllObjects(VimPortType vimPort, ManagedObjectReference propCollectorRef, List<PropertyFilterSpec> listpfs) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        RetrieveOptions propObjectRetrieveOpts = new RetrieveOptions();
        ArrayList<ObjectContent> listobjcontent = new ArrayList<ObjectContent>();
        RetrieveResult rslts = vimPort.retrievePropertiesEx(propCollectorRef, listpfs, propObjectRetrieveOpts);
        if (rslts != null && rslts.getObjects() != null && !rslts.getObjects().isEmpty()) {
            listobjcontent.addAll(rslts.getObjects());
        }
        String token = null;
        if (rslts != null && rslts.getToken() != null) {
            token = rslts.getToken();
        }
        while (token != null && !token.isEmpty()) {
            rslts = vimPort.continueRetrievePropertiesEx(propCollectorRef, token);
            token = null;
            if (rslts == null) continue;
            token = rslts.getToken();
            if (rslts.getObjects() == null || rslts.getObjects().isEmpty()) continue;
            listobjcontent.addAll(rslts.getObjects());
        }
        return listobjcontent;
    }

    public static ManagedObjectReference getEntityByName(VimPortType vimPortType, ServiceContent serviceContent, String entityName, String entityType) {
        ManagedObjectReference retVal;
        block3: {
            ManagedObjectReference propCollectorRef = serviceContent.getPropertyCollector();
            ManagedObjectReference rootFolderRef = serviceContent.getRootFolder();
            retVal = null;
            try {
                PropertySpec propertySpec = new PropertySpec();
                propertySpec.setAll(Boolean.FALSE);
                propertySpec.setType(entityType);
                propertySpec.getPathSet().add("name");
                ObjectSpec objectSpec = new ObjectSpec();
                objectSpec.setObj(rootFolderRef);
                objectSpec.setSkip(Boolean.TRUE);
                objectSpec.getSelectSet().addAll(Arrays.asList(VimUtil.buildTraversal()));
                PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
                propertyFilterSpec.getPropSet().add(propertySpec);
                propertyFilterSpec.getObjectSet().add(objectSpec);
                ArrayList<PropertyFilterSpec> listpfs = new ArrayList<PropertyFilterSpec>(1);
                listpfs.add(propertyFilterSpec);
                List<ObjectContent> listobjcont = VimUtil.retrievePropertiesAllObjects(vimPortType, propCollectorRef, listpfs);
                if (listobjcont == null) break block3;
                for (ObjectContent oc : listobjcont) {
                    if (!((DynamicProperty)oc.getPropSet().get(0)).getVal().equals(entityName)) continue;
                    retVal = oc.getObj();
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    public static List<DynamicProperty> getProperties(VimPortType vimPort, ServiceContent serviceContent, ManagedObjectReference moRef, String type, List<String> properties) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.valueOf(false));
        propertySpec.setType(type);
        propertySpec.getPathSet().addAll(properties);
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(moRef);
        objectSpec.setSkip(Boolean.valueOf(false));
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> listpfs = new ArrayList<PropertyFilterSpec>(1);
        listpfs.add(propertyFilterSpec);
        List<ObjectContent> listobjcontent = VimUtil.retrievePropertiesAllObjects(vimPort, serviceContent.getPropertyCollector(), listpfs);
        assert (listobjcontent != null && listobjcontent.size() > 0);
        ObjectContent contentObj = listobjcontent.get(0);
        List objList = contentObj.getPropSet();
        return objList;
    }

    private static SelectionSpec[] buildTraversal() {
        SelectionSpec sspecvfolders = new SelectionSpec();
        sspecvfolders.setName("VisitFolders");
        TraversalSpec dcToDf = new TraversalSpec();
        dcToDf.setType("Datacenter");
        dcToDf.setSkip(Boolean.FALSE);
        dcToDf.setPath("datastoreFolder");
        dcToDf.setName("dcToDf");
        dcToDf.getSelectSet().add(sspecvfolders);
        TraversalSpec dcToDs = new TraversalSpec();
        dcToDs.setType("Datacenter");
        dcToDs.setPath("datastore");
        dcToDs.setName("dcToDs");
        dcToDs.setSkip(Boolean.FALSE);
        TraversalSpec visitFolders = new TraversalSpec();
        visitFolders.setType("Folder");
        visitFolders.setPath("childEntity");
        visitFolders.setSkip(Boolean.FALSE);
        visitFolders.setName("VisitFolders");
        ArrayList<Object> sspecarrvf = new ArrayList<Object>();
        sspecarrvf.add(dcToDs);
        sspecarrvf.add(dcToDf);
        sspecarrvf.add(sspecvfolders);
        visitFolders.getSelectSet().addAll(sspecarrvf);
        return new SelectionSpec[]{visitFolders};
    }

    public static boolean deleteManagedEntity(VimPortType vimPort, ServiceContent serviceContent, ManagedObjectReference mor) {
        WaitForValues waitForValues = new WaitForValues(vimPort, serviceContent);
        System.out.println("Deleting : [" + mor.getValue() + "]");
        try {
            ManagedObjectReference taskmor = vimPort.destroyTask(mor);
            if (waitForValues.getTaskResultAfterDone(taskmor)) {
                System.out.println("Successful delete of Managed Entity - [" + mor.getValue() + "]" + " and Entity Type - [" + mor.getType() + "]");
                return true;
            }
            System.out.println("Unable to delete : [" + mor.getValue() + "]");
            return false;
        }
        catch (Exception e) {
            System.out.println("Unable to delete : [" + mor.getValue() + "]");
            System.out.println("Reason :" + e.getLocalizedMessage());
            return false;
        }
    }

    public static boolean createSnapshot(VimPortType vimPort, ServiceContent serviceContent, ManagedObjectReference vmMor, String snapshotname, String description) {
        WaitForValues waitForValues = new WaitForValues(vimPort, serviceContent);
        System.out.println("Taking snapshot : [" + snapshotname + "]");
        try {
            ManagedObjectReference taskMor = vimPort.createSnapshotTask(vmMor, snapshotname, description, false, false);
            if (waitForValues.getTaskResultAfterDone(taskMor)) {
                System.out.println("Snapshot - [" + snapshotname + "] Creation Successful");
                return true;
            }
            System.out.println("Snapshot - [" + snapshotname + "] Creation Failed");
            return false;
        }
        catch (Exception e) {
            System.out.println("Snapshot - [" + snapshotname + "] Creation Failed");
            System.out.println("Reason :" + e.getLocalizedMessage());
            return false;
        }
    }
}

