/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.std;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.Message;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DynamicStructDefinition;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.ListDefinition;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalDefinition;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.StringDefinition;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructDefinition;
import com.vmware.vapi.data.StructValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class StandardDataFactory {
    public static final String ALREADY_EXISTS = "com.vmware.vapi.std.errors.already_exists";
    public static final String INTERNAL_SERVER_ERROR = "com.vmware.vapi.std.errors.internal_server_error";
    public static final String OPERATION_NOT_FOUND = "com.vmware.vapi.std.errors.operation_not_found";
    public static final String INVALID_ARGUMENT = "com.vmware.vapi.std.errors.invalid_argument";
    public static final String NOT_FOUND = "com.vmware.vapi.std.errors.not_found";
    public static final String UNAUTHENTICATED = "com.vmware.vapi.std.errors.unauthenticated";
    public static final String UNEXPECTED_INPUT = "com.vmware.vapi.std.errors.unexpected_input";
    public static final String MESSAGE_STRUCT_NAME = "com.vmware.vapi.std.localizable_message";
    public static final String ID_FIELD_NAME = "id";
    public static final String DEFAUL_MSG_FIELD_NAME = "default_message";
    public static final String ARGS_FIELD_NAME = "args";
    public static final String MESSAGES_FIELD_NAME = "messages";
    public static final String DATA_FIELD_NAME = "data";
    private static StructDefinition locMessageDef;
    public static final Map<String, DataDefinition> STANDARD_ERROR_FIELDS;

    public static StructDefinition getLocalizableMessageDefinition() {
        return locMessageDef;
    }

    public static ErrorDefinition createStandardErrorDefinition(String errorName) {
        return new ErrorDefinition(errorName, STANDARD_ERROR_FIELDS);
    }

    public static ErrorValue createErrorValueForMessages(String errorName, List<Message> messages) {
        return StandardDataFactory.createErrorValueForMessages(StandardDataFactory.createStandardErrorDefinition(errorName), messages);
    }

    public static ErrorValue createErrorValueForMessages(ErrorDefinition errorDef, List<Message> messages) {
        Validate.notNull((Object)errorDef);
        Validate.notNull(messages);
        if (messages.size() < 1) {
            throw new IllegalArgumentException("The messages parameter must contain at least 1 message");
        }
        try {
            if (messages.contains(null)) {
                throw new IllegalArgumentException("null message detected");
            }
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        ListValue msgListValue = new ListValue();
        for (Message m : messages) {
            msgListValue.add(StandardDataFactory.convertMessageToDataValue(m));
        }
        ErrorValue result = errorDef.newInstance();
        result.setField(MESSAGES_FIELD_NAME, msgListValue);
        result.setField(DATA_FIELD_NAME, new OptionalValue());
        return result;
    }

    private static StructValue convertMessageToDataValue(Message msg) {
        StructDefinition resultDef = StandardDataFactory.getLocalizableMessageDefinition();
        StructValue result = resultDef.newInstance();
        result.setField(ID_FIELD_NAME, msg.getId());
        result.setField(DEFAUL_MSG_FIELD_NAME, msg.getDefaultMessage());
        result.setField(ARGS_FIELD_NAME, StandardDataFactory.convertArgsToDataValue(msg.getArgs()));
        return result;
    }

    private static DataValue convertArgsToDataValue(String[] args) {
        ListValue result = new ListValue();
        if (args != null) {
            for (String argument : args) {
                result.add(new StringValue(argument));
            }
        }
        return result;
    }

    public static List<Message> getMessagesFromErrorValue(StructValue error) {
        try {
            ListValue messageList = error.getList(MESSAGES_FIELD_NAME);
            ArrayList<Message> result = new ArrayList<Message>();
            for (DataValue messageStruct : messageList) {
                result.add(StandardDataFactory.buildLegacyMessage((StructValue)messageStruct));
            }
            return result;
        }
        catch (CoreException ex) {
            return Collections.emptyList();
        }
    }

    private static Message buildLegacyMessage(StructValue messageStruct) {
        String id = messageStruct.getString(ID_FIELD_NAME);
        String defaultMessage = messageStruct.getString(DEFAUL_MSG_FIELD_NAME);
        ListValue argsList = messageStruct.getList(ARGS_FIELD_NAME);
        List<String> stringArgsList = argsList.getStringList();
        return new Message(id, defaultMessage, stringArgsList.toArray(new String[stringArgsList.size()]));
    }

    static {
        HashMap<String, DataDefinition> msgFields = new HashMap<String, DataDefinition>();
        msgFields.put(ID_FIELD_NAME, StringDefinition.getInstance());
        msgFields.put(DEFAUL_MSG_FIELD_NAME, StringDefinition.getInstance());
        msgFields.put(ARGS_FIELD_NAME, new ListDefinition(StringDefinition.getInstance()));
        locMessageDef = new StructDefinition(MESSAGE_STRUCT_NAME, msgFields);
        STANDARD_ERROR_FIELDS = new HashMap<String, DataDefinition>();
        STANDARD_ERROR_FIELDS.put(MESSAGES_FIELD_NAME, new ListDefinition(locMessageDef));
        STANDARD_ERROR_FIELDS.put(DATA_FIELD_NAME, new OptionalDefinition(DynamicStructDefinition.getInstance()));
    }
}

