/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.provider.local;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.ErrorValueFactory;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.core.ProviderDefinition;
import com.vmware.vapi.data.ConstraintValidationException;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.diagnostics.LogDiagnosticUtil;
import com.vmware.vapi.diagnostics.LogDiagnosticsConfigurator;
import com.vmware.vapi.diagnostics.Slf4jMDCLogConfigurator;
import com.vmware.vapi.internal.diagnostics.DiagnosticsKey;
import com.vmware.vapi.internal.provider.introspection.OperationIntrospectionService;
import com.vmware.vapi.internal.provider.introspection.ProviderIntrospectionService;
import com.vmware.vapi.internal.provider.introspection.ServiceIntrospectionService;
import com.vmware.vapi.internal.util.async.StrictAsyncHandle;
import com.vmware.vapi.provider.ApiInterface;
import com.vmware.vapi.provider.introspection.SyncApiIntrospection;
import com.vmware.vapi.std.StandardDataFactory;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProvider
implements ApiProvider,
SyncApiIntrospection {
    public static final String LOCAL_PROVIDER_DEFAULT_NAME = "LocalProvider";
    private static final Logger logger = LoggerFactory.getLogger(LocalProvider.class);
    private static final String INVOKE_METHOD_COUNTER = "invokeMethodCounter";
    private static final String INVOKE_METHOD_TIME = "invokeMethodTime";
    private final LogDiagnosticsConfigurator logDiag = new Slf4jMDCLogConfigurator();
    static final Set<ErrorDefinition> LOCAL_PROVIDER_ERROR_DEFS = Collections.unmodifiableSet(new HashSet<ErrorDefinition>(Arrays.asList(StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.internal_server_error"), StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.invalid_argument"), StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.operation_not_found"))));
    private final ConcurrentMap<InterfaceIdentifier, ApiInterface> interfaces = new ConcurrentHashMap<InterfaceIdentifier, ApiInterface>();
    private final String name;

    public LocalProvider(String name) {
        this(name, Collections.emptyList());
    }

    public LocalProvider(String name, List<ApiInterface> ifaces) {
        this(name, ifaces, true);
    }

    public LocalProvider(String name, List<ApiInterface> ifaces, boolean deployIntrospectionServices) {
        this.name = name != null && !name.trim().isEmpty() ? name.trim() : LOCAL_PROVIDER_DEFAULT_NAME;
        DiagnosticsKey key = new DiagnosticsKey(LOCAL_PROVIDER_DEFAULT_NAME, new String[]{INVOKE_METHOD_COUNTER, INVOKE_METHOD_TIME});
        if (deployIntrospectionServices) {
            this.addInterface(new ProviderIntrospectionService(this));
            this.addInterface(new ServiceIntrospectionService(this));
            this.addInterface(new OperationIntrospectionService(this));
        }
        if (ifaces != null) {
            for (ApiInterface i : ifaces) {
                this.addInterface(i);
            }
        }
    }

    public void addInterface(ApiInterface iface) {
        Validate.notNull((Object)iface);
        InterfaceIdentifier id = iface.getIdentifier();
        ApiInterface duplicate = this.interfaces.putIfAbsent(id, iface);
        if (duplicate != null) {
            throw new IllegalArgumentException("Duplicate interface for id: " + id.getName());
        }
        logger.info("Registered the interface identifier " + id.toString());
    }

    public void addInterfaces(List<ApiInterface> ifaces) {
        Validate.notNull(ifaces);
        for (ApiInterface i : ifaces) {
            this.addInterface(i);
        }
    }

    @Override
    public ProviderDefinition getDefinition(ExecutionContext ctx) {
        return new ProviderDefinition(this.name, this.computeCheckSum());
    }

    private String computeCheckSum() {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (ApiInterface iface : this.interfaces.values()) {
                md.update(iface.getIdentifier().getName().getBytes("UTF-8"));
                for (MethodIdentifier methodId : iface.getDefinition().getMethodIdentifiers()) {
                    MethodDefinition methodDef = iface.getMethodDefinition(methodId);
                    md.update(methodDef.toString().getBytes("UTF-8"));
                }
            }
            return Hex.encodeHexString((byte[])md.digest());
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("Unable to get UTF-8 bytes for data for checksum", (Throwable)ex);
            return "";
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error("Unable to load algorithm to compute provider checksum", (Throwable)ex);
            return "";
        }
    }

    @Override
    public Set<InterfaceIdentifier> getInterfaceIdentifiers(ExecutionContext ctx) {
        LinkedHashSet<InterfaceIdentifier> ids = new LinkedHashSet<InterfaceIdentifier>();
        for (ApiInterface i : this.interfaces.values()) {
            ids.add(i.getIdentifier());
        }
        return ids;
    }

    @Override
    public InterfaceDefinition getInterface(ExecutionContext ctx, InterfaceIdentifier iface) {
        if (iface == null) {
            return null;
        }
        ApiInterface service = (ApiInterface)this.interfaces.get(iface);
        if (service != null) {
            return service.getDefinition();
        }
        return null;
    }

    @Override
    public MethodDefinition getMethod(ExecutionContext ctx, MethodIdentifier methodId) {
        if (methodId == null) {
            return null;
        }
        ApiInterface iface = (ApiInterface)this.interfaces.get(methodId.getInterfaceIdentifier());
        if (iface == null) {
            return null;
        }
        MethodDefinition methodDef = iface.getMethodDefinition(methodId);
        if (methodDef == null) {
            return null;
        }
        HashSet<ErrorDefinition> augmentedErrors = new HashSet<ErrorDefinition>(methodDef.getErrorDefinitions());
        augmentedErrors.addAll(LOCAL_PROVIDER_ERROR_DEFS);
        return new MethodDefinition(methodDef.getIdentifier(), methodDef.getInputDefinition(), methodDef.getOutputDefinition(), augmentedErrors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        try {
            this.logDiag.configureContext(LogDiagnosticUtil.getDiagnosticContext(ctx));
            this.invokeMethodInt(serviceId, operationId, input, ctx, asyncHandle);
        }
        catch (Exception ex) {
            MethodResult errorResult = LocalProvider.invokeMethodError(serviceId, operationId, ex);
            try {
                asyncHandle.setResult(errorResult);
            }
            catch (IllegalStateException e) {
                logger.error(String.format("Operation '{}' from Service '{}'  threw an exception after completing the invocation", operationId, serviceId), (Throwable)ex);
            }
        }
        finally {
            this.logDiag.cleanUpContext(LogDiagnosticUtil.getDiagnosticKeys());
        }
    }

    private static MethodResult invokeMethodError(String serviceId, String operationId, Exception e) {
        if (e instanceof ConstraintValidationException) {
            ConstraintValidationException cve = (ConstraintValidationException)e;
            logger.error("Validation error", (Throwable)cve);
            return MethodResult.newErrorResult(StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.invalid_argument", cve.getExceptionMessages()));
        }
        if (e instanceof CoreException) {
            CoreException ex = (CoreException)e;
            logger.error("invokeMethod error:", (Throwable)ex);
            return MethodResult.newErrorResult(StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.internal_server_error", ex.getExceptionMessages()));
        }
        logger.warn("invokeMethod error:", (Throwable)e);
        Message message = MessageFactory.getMessage("vapi.provider.local.invoke.exception", operationId, serviceId);
        return MethodResult.newErrorResult(StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.internal_server_error", Arrays.asList(message)));
    }

    private void invokeMethodInt(final String serviceId, final String operationId, DataValue input, ExecutionContext ctx, final AsyncHandle<MethodResult> asyncHandle) {
        final StopWatch invokeMethodTimer = new StopWatch();
        invokeMethodTimer.start();
        if (ctx == null) {
            asyncHandle.setResult(LocalProvider.buildMethodResultForError("com.vmware.vapi.std.errors.internal_server_error", "vapi.provider.local.invoke.missing.execution.context", new String[0]));
            invokeMethodTimer.stop();
            return;
        }
        if (serviceId == null) {
            asyncHandle.setResult(LocalProvider.buildMethodResultForError("com.vmware.vapi.std.errors.internal_server_error", "vapi.provider.local.invoke.missing.serviceId", new String[0]));
            invokeMethodTimer.stop();
            return;
        }
        if (operationId == null) {
            asyncHandle.setResult(LocalProvider.buildMethodResultForError("com.vmware.vapi.std.errors.internal_server_error", "vapi.provider.local.invoke.missing.operationId", new String[0]));
            invokeMethodTimer.stop();
            return;
        }
        if (input == null) {
            asyncHandle.setResult(LocalProvider.buildMethodResultForError("com.vmware.vapi.std.errors.internal_server_error", "vapi.provider.local.invoke.missing.input.value", serviceId, operationId));
            invokeMethodTimer.stop();
            return;
        }
        ApiInterface iface = (ApiInterface)this.interfaces.get(new InterfaceIdentifier(serviceId));
        if (iface == null) {
            asyncHandle.setResult(LocalProvider.buildMethodResultForError("com.vmware.vapi.std.errors.operation_not_found", "vapi.method.input.invalid.interface", serviceId));
            invokeMethodTimer.stop();
            return;
        }
        MethodIdentifier methodId = new MethodIdentifier(new InterfaceIdentifier(serviceId), operationId);
        final MethodDefinition methodDef = iface.getMethodDefinition(methodId);
        if (methodDef == null) {
            asyncHandle.setResult(LocalProvider.buildMethodResultForError("com.vmware.vapi.std.errors.operation_not_found", "vapi.method.input.invalid.method", operationId, serviceId));
            invokeMethodTimer.stop();
            return;
        }
        logger.debug("call to invoke() for service '{}', operation '{}'", (Object)serviceId, (Object)operationId);
        ErrorValue valError = this.validateMethodInput(methodDef, input);
        if (valError != null) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("Will not invoke method %s because the input is invalid", methodId));
            }
            asyncHandle.setResult(MethodResult.newErrorResult(valError));
            invokeMethodTimer.stop();
            return;
        }
        AsyncHandle<MethodResult> cb = new AsyncHandle<MethodResult>(){

            @Override
            public void updateProgress(DataValue progress) {
                asyncHandle.updateProgress(progress);
            }

            @Override
            public void setResult(MethodResult result) {
                ErrorValue valError;
                try {
                    valError = LocalProvider.this.validateMethodResult(methodDef, result);
                }
                catch (RuntimeException ex) {
                    asyncHandle.setResult(LocalProvider.invokeMethodError(serviceId, operationId, ex));
                    invokeMethodTimer.stop();
                    return;
                }
                if (valError != null) {
                    asyncHandle.setResult(MethodResult.newErrorResult(valError));
                } else {
                    asyncHandle.setResult(result);
                }
                invokeMethodTimer.stop();
            }

            @Override
            public void setError(RuntimeException error) {
                asyncHandle.setResult(LocalProvider.invokeMethodError(serviceId, operationId, error));
            }
        };
        iface.invoke(ctx, methodId, input, new StrictAsyncHandle<MethodResult>(cb));
    }

    private ErrorValue validateMethodInput(MethodDefinition method, DataValue input) {
        DataDefinition inputType = method.getInputDefinition();
        if (inputType == null) {
            throw new CoreException("vapi.provider.local.invokemethod.missing.input.def", method.getIdentifier().toString());
        }
        inputType.completeValue(input);
        List<Message> inputErrors = inputType.validate(input);
        if (!inputErrors.isEmpty()) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("Validation failed for input value of method %s: %s", method.getIdentifier(), inputErrors));
            }
            LinkedList<Message> allMsgs = new LinkedList<Message>();
            allMsgs.add(MessageFactory.getMessage("vapi.invoke.input.invalid", method.getIdentifier().toString()));
            allMsgs.addAll(inputErrors);
            return StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.invalid_argument", allMsgs);
        }
        return null;
    }

    private ErrorValue validateMethodResult(MethodDefinition method, MethodResult result) {
        if (result == null) {
            throw new CoreException("vapi.provider.local.invokemethod.missing.result", method.getIdentifier().toString());
        }
        if (result.success()) {
            return this.validateMethodOutput(method, result.getOutput());
        }
        return this.validateMethodError(method, result);
    }

    private ErrorValue validateMethodOutput(MethodDefinition method, DataValue output) {
        DataDefinition outputType = method.getOutputDefinition();
        if (outputType == null) {
            throw new CoreException("vapi.provider.local.invokemethod.missing.output.def", method.getIdentifier().toString());
        }
        List<Message> outputErrors = outputType.validate(output);
        if (!outputErrors.isEmpty()) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("Method %s returned invalid output: %s", method.getIdentifier(), outputErrors));
            }
            LinkedList<Message> allMsgs = new LinkedList<Message>();
            allMsgs.add(MessageFactory.getMessage("vapi.provider.local.invokemethod.output.invalid", method.getIdentifier().toString()));
            allMsgs.addAll(outputErrors);
            return StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.internal_server_error", allMsgs);
        }
        return null;
    }

    private ErrorValue validateMethodError(MethodDefinition method, MethodResult result) {
        ErrorValue error = result.getError();
        ErrorDefinition errorDef = method.getErrorDefinition(error.getName());
        if (errorDef == null) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("Undeclared error %s reported from method %s", error.getName(), method.getIdentifier()));
            }
            Message newMessage = MessageFactory.getMessage("vapi.provider.local.invokemethod.errors.undeclared", error.getName(), method.getIdentifier().toString());
            List<Message> msgs = StandardDataFactory.getMessagesFromErrorValue(error);
            ArrayList<Message> allMessages = new ArrayList<Message>(msgs.size() + 1);
            allMessages.add(newMessage);
            allMessages.addAll(msgs);
            return StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.internal_server_error", allMessages);
        }
        List<Message> validationProblems = errorDef.validate(error);
        if (validationProblems.size() > 0) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("Invalid error %s reported from method %s: %s", error, method.getIdentifier(), validationProblems));
            }
            Message newMessage = MessageFactory.getMessage("vapi.provider.local.invokemethod.errors.invalid", error.getName(), method.getIdentifier().toString());
            List<Message> msgs = StandardDataFactory.getMessagesFromErrorValue(error);
            ArrayList<Message> allMessages = new ArrayList<Message>(msgs.size() + validationProblems.size() + 1);
            allMessages.add(newMessage);
            allMessages.addAll(validationProblems);
            allMessages.addAll(msgs);
            return StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.internal_server_error", allMessages);
        }
        return null;
    }

    private static MethodResult buildMethodResultForError(String errorName, String msgId, String ... msgArgs) {
        return MethodResult.newErrorResult(ErrorValueFactory.buildErrorValue(errorName, msgId, msgArgs));
    }
}

