/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol;

import java.security.KeyStore;
import java.security.cert.CertStore;
import org.apache.commons.lang.Validate;

public final class HttpConfiguration {
    private final LibType libraryType;
    private final SslConfiguration sslConfig;
    private final int ioThreadCount;
    private final int connectTimeout;
    private final int soTimeout;
    private final int maxConnections;
    private final long keepAlivePeriod;

    private HttpConfiguration(LibType libraryType, SslConfiguration sslConfig, int ioThreadCount, int connectTimeout, int soTimeout, int maxConnections, long keepAlivePeriod) {
        this.libraryType = libraryType;
        this.sslConfig = sslConfig;
        this.ioThreadCount = ioThreadCount;
        this.connectTimeout = connectTimeout;
        this.soTimeout = soTimeout;
        this.maxConnections = maxConnections;
        this.keepAlivePeriod = keepAlivePeriod;
    }

    public LibType getLibraryType() {
        return this.libraryType;
    }

    public SslConfiguration getSslConfiguration() {
        return this.sslConfig;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public long getKeepAlivePeriod() {
        return this.keepAlivePeriod;
    }

    public static final class Builder {
        private static final int DEFAULT_MAX_CONNECTIONS = 20;
        private static final long DEFAULT_KEEP_ALIVE_PERIOD = 45000L;
        private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
        private static final int DEFAULT_SOCKET_TIMEOUT = 0;
        private LibType libraryType = LibType.APACHE_HTTP_CLIENT;
        private SslConfiguration sslConfig;
        private Integer ioThreadCount;
        private int connectTimeout = 15000;
        private int soTimeout = 0;
        private int maxConnections = 20;
        private long keepAlivePeriod = 45000L;

        public Builder setLibraryType(LibType libraryType) {
            Validate.notNull((Object)((Object)libraryType));
            this.libraryType = libraryType;
            return this;
        }

        public Builder setSslConfiguration(SslConfiguration sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public Builder setIoThreadCount(int ioThreadCount) {
            Validate.isTrue((ioThreadCount > 0 ? 1 : 0) != 0);
            this.ioThreadCount = ioThreadCount;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            Validate.isTrue((connectTimeout >= 0 ? 1 : 0) != 0);
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setSoTimeout(int soTimeout) {
            Validate.isTrue((soTimeout >= 0 ? 1 : 0) != 0);
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            Validate.isTrue((maxConnections > 0 ? 1 : 0) != 0);
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setKeepAlivePeriod(long keepAlivePeriod) {
            this.keepAlivePeriod = keepAlivePeriod;
            return this;
        }

        public HttpConfiguration getConfig() {
            this.validate();
            int ioThreads = this.ioThreadCount == null ? Runtime.getRuntime().availableProcessors() : this.ioThreadCount.intValue();
            return new HttpConfiguration(this.libraryType, this.sslConfig, ioThreads, this.connectTimeout, this.soTimeout, this.maxConnections, this.keepAlivePeriod);
        }

        private void validate() {
            if (this.ioThreadCount != null && this.libraryType != LibType.APACHE_HTTP_ASYNC_CLIENT) {
                throw new IllegalStateException("IO thread count setting is not supported for transport based on library " + (Object)((Object)this.libraryType));
            }
        }
    }

    public static final class KeyStoreConfig {
        private final String keyAlias;
        private final String keyStorePassword;

        public KeyStoreConfig(String keyAlias, String keyStorePassword) {
            Validate.notNull((Object)keyAlias);
            Validate.notNull((Object)keyStorePassword);
            this.keyAlias = keyAlias;
            this.keyStorePassword = keyStorePassword;
        }

        public String getKeyAlias() {
            return this.keyAlias;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }
    }

    public static final class SslConfiguration {
        private static final String[] DEFAULT_PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
        private final KeyStore trustStore;
        private final KeyStore keyStore;
        private final KeyStoreConfig keyStoreConfig;
        private final CertStore crlCertStore;
        private final String[] enabledProtocols;
        private final String[] enabledCipherSuites;

        public SslConfiguration(KeyStore trustStore) {
            this(trustStore, null, null);
        }

        public SslConfiguration(KeyStore trustStore, KeyStore keyStore, KeyStoreConfig keyStoreConfig) {
            this(trustStore, keyStore, keyStoreConfig, null);
        }

        public SslConfiguration(KeyStore trustStore, KeyStore keyStore, KeyStoreConfig keyStoreConfig, CertStore crlCertStore) {
            this(trustStore, keyStore, keyStoreConfig, crlCertStore, DEFAULT_PROTOCOLS, null);
        }

        private SslConfiguration(KeyStore trustStore, KeyStore keyStore, KeyStoreConfig keyStoreConfig, CertStore crlCertStore, String[] enabledProtocols, String[] enabledCipherSuites) {
            Validate.notNull((Object)trustStore);
            this.trustStore = trustStore;
            this.keyStore = keyStore;
            this.keyStoreConfig = keyStoreConfig;
            this.crlCertStore = crlCertStore;
            this.enabledProtocols = enabledProtocols;
            this.enabledCipherSuites = enabledCipherSuites;
        }

        public KeyStore getTrustStore() {
            return this.trustStore;
        }

        public KeyStore getKeyStore() {
            return this.keyStore;
        }

        public KeyStoreConfig getKeyStoreConfig() {
            return this.keyStoreConfig;
        }

        public CertStore getCrlCertStore() {
            return this.crlCertStore;
        }

        public String[] getEnabledProtocols() {
            return this.enabledProtocols;
        }

        public String[] getEnabledCipherSuites() {
            return this.enabledCipherSuites;
        }

        static /* synthetic */ String[] access$000() {
            return DEFAULT_PROTOCOLS;
        }

        public static final class Builder {
            private KeyStore trustStore;
            private KeyStore keyStore;
            private KeyStoreConfig keyStoreConfig;
            private CertStore crlCertStore;
            private String[] enabledProtocols = SslConfiguration.access$000();
            private String[] enabledCipherSuites;

            public Builder(KeyStore trustStore) {
                Validate.notNull((Object)trustStore);
                this.trustStore = trustStore;
            }

            public Builder setKeyStore(KeyStore keyStore) {
                this.keyStore = keyStore;
                return this;
            }

            public Builder setKeyStoreConfig(KeyStoreConfig keyStoreConfig) {
                this.keyStoreConfig = keyStoreConfig;
                return this;
            }

            public Builder setCrlCertStore(CertStore crlCertStore) {
                this.crlCertStore = crlCertStore;
                return this;
            }

            public Builder setEnabledProtocols(String[] enabledProtocols) {
                Validate.notEmpty((Object[])enabledProtocols);
                this.enabledProtocols = enabledProtocols;
                return this;
            }

            public Builder setEnabledCipherSuites(String[] enabledCipherSuites) {
                this.enabledCipherSuites = enabledCipherSuites;
                return this;
            }

            public SslConfiguration getConfig() {
                return new SslConfiguration(this.trustStore, this.keyStore, this.keyStoreConfig, this.crlCertStore, this.enabledProtocols, this.enabledCipherSuites);
            }
        }
    }

    public static enum LibType {
        APACHE_HTTP_CLIENT,
        APACHE_HTTP_ASYNC_CLIENT;

    }
}

