/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.client.exception.SslException;
import com.vmware.vapi.internal.protocol.client.rpc.http.KeyManagerWrapper;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.Validate;

public final class SslClientUtil {
    private SslClientUtil() {
    }

    public static SSLContext createSslContext(HttpConfiguration.SslConfiguration sslConfig) {
        Validate.notNull((Object)sslConfig);
        try {
            SSLContext sslCtx = SSLContext.getInstance("TLS");
            KeyManager[] keyManagers = SslClientUtil.createKeyManagers(sslConfig);
            String trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(trustAlgorithm);
            trustFactory.init(sslConfig.getTrustStore());
            TrustManager[] trustManagers = trustFactory.getTrustManagers();
            if (sslConfig.getCrlCertStore() != null) {
                for (TrustManager trustManager : trustManagers) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    X509TrustManager defaultX509TrustManager = (X509TrustManager)trustManager;
                    trustManagers = new TrustManager[]{SslClientUtil.createCRLCheckingTrustManager(defaultX509TrustManager, sslConfig.getCrlCertStore())};
                }
            }
            sslCtx.init(keyManagers, trustManagers, null);
            return sslCtx;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SslException(ex);
        }
        catch (KeyStoreException ex) {
            throw new SslException(ex);
        }
        catch (KeyManagementException ex) {
            throw new SslException(ex);
        }
    }

    private static X509TrustManager createCRLCheckingTrustManager(final X509TrustManager defaultTrustManager, final CertStore crlCertStore) {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String paramString) throws CertificateException {
                defaultTrustManager.checkClientTrusted(chain, paramString);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String paramString) throws CertificateException {
                if (crlCertStore != null) {
                    try {
                        for (X509Certificate cert : chain) {
                            X509CRLSelector selector = new X509CRLSelector();
                            selector.setCertificateChecking(cert);
                            for (CRL cRL : crlCertStore.getCRLs(selector)) {
                                if (!cRL.isRevoked(cert)) continue;
                                throw new CertificateException("Server certificate revoked by the CRL");
                            }
                        }
                    }
                    catch (CertStoreException e) {
                        throw new CertificateException("Failed to validate certificate againstCertStore CRL", e);
                    }
                }
                defaultTrustManager.checkServerTrusted(chain, paramString);
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return defaultTrustManager.getAcceptedIssuers();
            }
        };
    }

    protected static KeyManager[] createKeyManagers(HttpConfiguration.SslConfiguration sslConfig) {
        if (sslConfig.getKeyStore() == null || sslConfig.getKeyStoreConfig() == null) {
            return null;
        }
        String password = sslConfig.getKeyStoreConfig().getKeyStorePassword();
        String alias = sslConfig.getKeyStoreConfig().getKeyAlias();
        try {
            if (password != null && alias != null) {
                KeyStore store = sslConfig.getKeyStore();
                KeyManagerFactory keyMngrFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyMngrFactory.init(store, password.toCharArray());
                KeyManager[] keyManagers = keyMngrFactory.getKeyManagers();
                for (int i = 0; i < keyManagers.length; ++i) {
                    if (!(keyManagers[i] instanceof X509KeyManager)) continue;
                    keyManagers[i] = new KeyManagerWrapper((X509KeyManager)keyManagers[i], alias);
                }
                return keyManagers;
            }
        }
        catch (Exception e) {
            throw new SslException("Unable to create KeyManagers", e);
        }
        return null;
    }

    static String stripHostnameBrackets(String hostname) {
        if (hostname != null && hostname.startsWith("[") && hostname.endsWith("]")) {
            try {
                return InetAddress.getByName(hostname).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return hostname;
    }
}

