/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.dsig.json;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.dsig.json.SignatureException;
import com.vmware.vapi.internal.dsig.json.CanonicalizationUtil;
import com.vmware.vapi.internal.dsig.json.Canonicalizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.std.SerializerBase;
import org.codehaus.jackson.node.DoubleNode;

public final class JsonCanonicalizer
implements Canonicalizer {
    private static final Message CANONICALIZATION_ERROR = MessageFactory.getMessage("vapi.signature.canonicalization", new String[0]);

    @Override
    public String asCanonicalString(String message) {
        JsonNode root;
        Validate.notNull((Object)message);
        ObjectMapper m = new ObjectMapper();
        SimpleModule module = new SimpleModule("Custom serializer", new Version(1, 0, 0, ""));
        module.addSerializer((JsonSerializer)new DoubleSerializer());
        m.registerModule((Module)module);
        Object canonicalizedForm = root = this.parseToTree(message, m);
        if (root.isObject()) {
            canonicalizedForm = this.canonicalizeObject(root);
        } else if (root.isArray()) {
            canonicalizedForm = this.canonicalizeArray(root);
        }
        return this.serializeToString(m, canonicalizedForm);
    }

    private TreeMap<String, Object> canonicalizeObject(JsonNode jsonObject) {
        assert (jsonObject != null);
        TreeMap<String, Object> sorted = new TreeMap<String, Object>();
        Iterator fieldsIterator = jsonObject.getFields();
        while (fieldsIterator.hasNext()) {
            Map.Entry nextField = (Map.Entry)fieldsIterator.next();
            String key = (String)nextField.getKey();
            JsonNode value = (JsonNode)nextField.getValue();
            if (value.isArray()) {
                sorted.put(key, this.canonicalizeArray(value));
                continue;
            }
            if (value.isObject()) {
                sorted.put(key, this.canonicalizeObject(value));
                continue;
            }
            sorted.put(key, value);
        }
        return sorted;
    }

    private List<Object> canonicalizeArray(JsonNode jsonArray) {
        assert (jsonArray != null);
        ArrayList<Object> sorted = new ArrayList<Object>();
        for (JsonNode element : jsonArray) {
            if (element.isArray()) {
                sorted.add(this.canonicalizeArray(element));
                continue;
            }
            if (element.isObject()) {
                sorted.add(this.canonicalizeObject(element));
                continue;
            }
            sorted.add(element);
        }
        return sorted;
    }

    private String serializeToString(ObjectMapper mapper, Object canonicalizedForm) {
        String result;
        assert (mapper != null && canonicalizedForm != null);
        try {
            result = mapper.writeValueAsString(canonicalizedForm);
        }
        catch (JsonGenerationException e) {
            throw new SignatureException(CANONICALIZATION_ERROR, (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new SignatureException(CANONICALIZATION_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            throw new SignatureException(CANONICALIZATION_ERROR, (Throwable)e);
        }
        return result;
    }

    private JsonNode parseToTree(String message, ObjectMapper mapper) {
        JsonNode root;
        assert (message != null && mapper != null);
        try {
            root = mapper.readTree(message);
        }
        catch (JsonProcessingException e) {
            throw new SignatureException(CANONICALIZATION_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            throw new SignatureException(CANONICALIZATION_ERROR, (Throwable)e);
        }
        return root;
    }

    private static final class DoubleSerializer
    extends SerializerBase<DoubleNode> {
        protected DoubleSerializer() {
            super(DoubleNode.class);
        }

        public void serialize(DoubleNode value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            double doubleValue = value.asDouble();
            jgen.writeNumber(CanonicalizationUtil.canonicalizeDouble(doubleValue));
        }
    }
}

