/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.bindings.ApiError;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.server.impl.InvocationContextImpl;
import com.vmware.vapi.bindings.type.ErrorType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.ConstraintValidationException;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.ListDefinition;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalDefinition;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.StructDefinition;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.ValidatorUtil;
import com.vmware.vapi.internal.bindings.type.TypeUtil;
import com.vmware.vapi.internal.data.DeepDefinitionVisitor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.provider.local.LocalProvider;
import com.vmware.vapi.std.StandardDataFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiMethodSkeleton
implements ApiMethod {
    private static final Logger logger = LoggerFactory.getLogger(LocalProvider.class);
    static final Set<ErrorDefinition> API_METHOD_SKELETON_ERRORS = Collections.unmodifiableSet(new HashSet<ErrorDefinition>(Arrays.asList(StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.invalid_argument"), StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.internal_server_error"), StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.unexpected_input"))));
    private final MethodIdentifier id;
    private final MethodDefinition definition;
    private final TypeConverter converter;
    private final Map<Class<?>, ErrorType> errorClass2Type;
    private final StructType inputType;
    private final Type outputType;

    public ApiMethodSkeleton(InterfaceIdentifier ifaceId, String name, StructType inputType, Type outputType, TypeConverter converter, Collection<Type> errorTypes) {
        Validate.notNull((Object)ifaceId);
        Validate.notNull((Object)name);
        Validate.notNull((Object)inputType);
        Validate.notNull((Object)outputType);
        Validate.notNull((Object)converter);
        this.id = new MethodIdentifier(ifaceId, name);
        this.errorClass2Type = new HashMap();
        HashSet<ErrorDefinition> augmentedErrors = new HashSet<ErrorDefinition>(API_METHOD_SKELETON_ERRORS);
        if (errorTypes != null) {
            for (Type type : errorTypes) {
                augmentedErrors.add((ErrorDefinition)TypeUtil.toDataDefinition(type));
                ErrorType errType = (ErrorType)((TypeReference)type).resolve();
                this.errorClass2Type.put(errType.getBindingClass(), errType);
            }
        }
        this.inputType = inputType;
        this.outputType = outputType;
        this.definition = new MethodDefinition(this.id, TypeUtil.toDataDefinition(inputType), TypeUtil.toDataDefinition(outputType), augmentedErrors);
        this.converter = converter;
    }

    @Override
    public MethodIdentifier getIdentifier() {
        return this.id;
    }

    @Override
    public MethodDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public DataDefinition getInputDefinition() {
        return this.definition.getInputDefinition();
    }

    @Override
    public DataDefinition getOutputDefinition() {
        return this.definition.getOutputDefinition();
    }

    @Override
    public void invoke(ExecutionContext ctx, DataValue input, AsyncHandle<MethodResult> asyncHandle) {
        try {
            ErrorValue valError = this.validateInput(ctx, input);
            if (valError != null) {
                logger.debug("Input validation failed. Completing invocation with error\n {}", (Object)valError);
                asyncHandle.setResult(MethodResult.newErrorResult(valError));
                return;
            }
            ValidatingAsyncHandle validatingHandle = new ValidatingAsyncHandle(asyncHandle, this.outputType, this.id);
            InvocationContextImpl invocationContext = new InvocationContextImpl(ctx);
            this.doInvoke(invocationContext, (StructValue)input, validatingHandle);
        }
        catch (RuntimeException ex) {
            logger.debug("Method {} threw an exception", (Object)this.id, (Object)ex);
            MethodResult errorResult = MethodResult.newErrorResult(this.toErrorValue(ex));
            try {
                asyncHandle.setResult(errorResult);
            }
            catch (IllegalStateException e) {
                logger.error("Method {} threw an exception after completing the invocation", (Object)this.id, (Object)ex);
            }
        }
    }

    private ErrorValue validateInput(ExecutionContext ctx, DataValue input) {
        ErrorValue validationError = this.validateInputTypes(input);
        if (validationError != null) {
            return validationError;
        }
        StructValue inStruct = (StructValue)input;
        validationError = this.validateInput(inStruct);
        if (validationError != null) {
            return validationError;
        }
        StructDefinition inDef = (StructDefinition)this.definition.getInputDefinition();
        validationError = this.checkForUnknownFields(inStruct, inDef);
        if (validationError != null) {
            return validationError;
        }
        return null;
    }

    protected ErrorValue toErrorValue(RuntimeException ex) {
        return this.toErrorValue(this.converter, ex, true);
    }

    public ErrorValue toErrorValue(TypeConverter converter, RuntimeException ex) {
        return this.toErrorValue(converter, ex, false);
    }

    public ErrorValue toErrorValue(TypeConverter converter, RuntimeException ex, boolean onInput) {
        if (ex instanceof ConstraintValidationException) {
            ConstraintValidationException cve = (ConstraintValidationException)ex;
            logger.error("Validation error", (Throwable)cve);
            return StandardDataFactory.createErrorValueForMessages(onInput ? "com.vmware.vapi.std.errors.invalid_argument" : "com.vmware.vapi.std.errors.internal_server_error", cve.getExceptionMessages());
        }
        if (ex instanceof CoreException) {
            CoreException coreExc = (CoreException)ex;
            logger.error("Invocation error", (Throwable)coreExc);
            return ApiMethodSkeleton.buildInternalServerErrorValue(coreExc.getExceptionMessages());
        }
        return this.convertToErrorValue(converter, ex);
    }

    private ErrorValue validateInputTypes(DataValue input) {
        if (input != null && !(input instanceof StructValue) || !(this.definition.getInputDefinition() instanceof StructDefinition)) {
            return StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.invalid_request", Arrays.asList(MessageFactory.getMessage("vapi.bindings.method.invalid.input.type", new String[0])));
        }
        return null;
    }

    private ErrorValue validateInput(StructValue input) {
        try {
            ValidatorUtil.validate(this.inputType, input, this.id);
        }
        catch (CoreException ex) {
            logger.debug("Validation failed in method {}", (Object)this.id, (Object)ex);
            return StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.invalid_argument", ex.getExceptionMessages());
        }
        return null;
    }

    private ErrorValue checkForUnknownFields(StructValue inStruct, StructDefinition inDef) {
        assert (inStruct != null);
        CheckForUnknownFieldsVisitor checkVisitor = new CheckForUnknownFieldsVisitor(inStruct);
        inDef.accept(checkVisitor);
        return checkVisitor.getErrorValue();
    }

    private ErrorValue convertToErrorValue(TypeConverter converter, RuntimeException ex) {
        ErrorType type = this.errorClass2Type.get(ex.getClass());
        if (type == null) {
            logger.warn("Implementation method reported unexpected exception: {}", (Object)ex.getClass().getCanonicalName(), (Object)ex);
            String msgArg = null;
            msgArg = ex instanceof ApiError ? ex.getClass().getName() : String.valueOf(ex.getMessage());
            ArrayList<Message> msgs = new ArrayList<Message>();
            msgs.add(MessageFactory.getMessage("vapi.bindings.method.impl.unexpected", msgArg));
            if (ex instanceof StaticStructure) {
                msgs.addAll(StandardDataFactory.getMessagesFromErrorValue(((StaticStructure)((Object)ex))._getDataValue()));
            }
            return ApiMethodSkeleton.buildInternalServerErrorValue(msgs);
        }
        logger.debug("Method implementation threw a VMODL2 error", (Throwable)ex);
        return (ErrorValue)converter.convertToVapi(ex, type);
    }

    private static ErrorValue buildInternalServerErrorValue(List<Message> messages) {
        return StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.internal_server_error", messages);
    }

    public abstract void doInvoke(InvocationContext var1, StructValue var2, AsyncHandle<MethodResult> var3);

    private static final class CheckForUnknownFieldsVisitor
    extends DeepDefinitionVisitor {
        private final DataValue dataValue;
        private ErrorValue error;

        CheckForUnknownFieldsVisitor(DataValue dataValue) {
            this.dataValue = dataValue;
        }

        @Override
        public void visit(StructDefinition def) {
            assert (this.dataValue != null && (this.dataValue.getType() == DataType.STRUCTURE || this.dataValue.getType() == DataType.ERROR));
            StructValue value = (StructValue)this.dataValue;
            Set<String> unexpected = this.findUnknownSetOptionalFields(def, value);
            if (!unexpected.isEmpty()) {
                this.error = StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.unexpected_input", Arrays.asList(MessageFactory.getMessage("vapi.data.structure.field.unexpected", unexpected.toString(), value.getName())));
                return;
            }
            for (String fieldName : def.getFieldNames()) {
                DataDefinition fieldDef = def.getField(fieldName);
                CheckForUnknownFieldsVisitor checkVisitor = new CheckForUnknownFieldsVisitor(value.getField(fieldName));
                fieldDef.accept(checkVisitor);
                this.error = checkVisitor.getErrorValue();
                if (this.error == null) continue;
                return;
            }
        }

        @Override
        public void visit(OptionalDefinition def) {
            assert (this.dataValue != null && this.dataValue.getType() == DataType.OPTIONAL);
            OptionalValue value = (OptionalValue)this.dataValue;
            if (value.isSet()) {
                CheckForUnknownFieldsVisitor checkVisitor = new CheckForUnknownFieldsVisitor(value.getValue());
                def.getElementType().accept(checkVisitor);
                this.error = checkVisitor.getErrorValue();
            }
        }

        @Override
        public void visit(ListDefinition fieldDef) {
            assert (this.dataValue != null && this.dataValue.getType() == DataType.LIST);
            ListValue value = (ListValue)this.dataValue;
            for (DataValue elemValue : value) {
                CheckForUnknownFieldsVisitor checkVisitor = new CheckForUnknownFieldsVisitor(elemValue);
                fieldDef.getElementType().accept(checkVisitor);
                this.error = checkVisitor.getErrorValue();
                if (this.error == null) continue;
                return;
            }
        }

        private ErrorValue getErrorValue() {
            return this.error;
        }

        private Set<String> findUnknownSetOptionalFields(StructDefinition def, StructValue value) {
            HashSet<String> unexpected = new HashSet<String>();
            for (String fieldName : value.getFieldNames()) {
                DataValue fieldValue;
                if (def.hasField(fieldName) || (fieldValue = value.getField(fieldName)) instanceof OptionalValue && !((OptionalValue)fieldValue).isSet()) continue;
                unexpected.add(fieldName);
            }
            return unexpected;
        }
    }

    private static final class ValidatingAsyncHandle
    extends AsyncHandle<MethodResult> {
        private final AsyncHandle<MethodResult> decoratedHandle;
        private final Type resultType;
        private final MethodIdentifier methodId;

        public ValidatingAsyncHandle(AsyncHandle<MethodResult> decoratedHandle, Type outputType, MethodIdentifier methodId) {
            Validate.notNull(decoratedHandle);
            Validate.notNull((Object)outputType);
            Validate.notNull((Object)methodId);
            this.decoratedHandle = decoratedHandle;
            this.resultType = outputType;
            this.methodId = methodId;
        }

        @Override
        public void updateProgress(DataValue progress) {
            this.decoratedHandle.updateProgress(progress);
        }

        @Override
        public void setResult(MethodResult result) {
            ErrorValue error = null;
            try {
                if (result.success()) {
                    DataValue output = result.getOutput();
                    ValidatorUtil.validate(this.resultType, output, this.methodId);
                }
            }
            catch (ConstraintValidationException e) {
                logger.debug("Method {} returned value which does not comply with the declared result type", (Object)this.methodId, (Object)e);
                error = StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.internal_server_error", e.getExceptionMessages());
            }
            if (error == null) {
                this.decoratedHandle.setResult(result);
            } else {
                this.decoratedHandle.setResult(MethodResult.newErrorResult(error));
            }
        }

        @Override
        public void setError(RuntimeException error) {
            this.decoratedHandle.setError(error);
        }
    }
}

