/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DefinitionVisitor;
import com.vmware.vapi.data.ListValue;
import java.util.List;

public class ListDefinition
extends DataDefinition {
    private DataDefinition elementType;

    public ListDefinition(DataDefinition elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException("List definition requires element definition.");
        }
        this.elementType = elementType;
    }

    @Override
    public DataType getType() {
        return DataType.LIST;
    }

    public DataDefinition getElementType() {
        return this.elementType;
    }

    public ListValue newInstance() {
        return new ListValue();
    }

    @Override
    public List<Message> validate(DataValue value) {
        List<Message> errors = super.validate(value);
        if (!errors.isEmpty()) {
            return errors;
        }
        ListValue list = (ListValue)value;
        int index = 0;
        for (DataValue elem : list) {
            List<Message> subErrors = this.elementType.validate(elem);
            if (!subErrors.isEmpty()) {
                errors.add(MessageFactory.getMessage("vapi.data.list.invalid.entry", elem.toString(), String.valueOf(index)));
                errors.addAll(subErrors);
                break;
            }
            ++index;
        }
        return errors;
    }

    @Override
    public void completeValue(DataValue value) {
        if (value != null && value.getType() == DataType.LIST) {
            ListValue list = (ListValue)value;
            for (DataValue elem : list) {
                this.elementType.completeValue(elem);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ListDefinition)) {
            return false;
        }
        ListDefinition otherList = (ListDefinition)other;
        return this.elementType.equals(otherList.elementType);
    }

    public int hashCode() {
        return 17 + 31 * this.elementType.hashCode();
    }

    @Override
    public String toString() {
        return "List[" + this.elementType.toString() + "]";
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }
}

