/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.logging.supportbundle;

import com.vmware.vide.logging.supportbundle.ISupportBundleContribution;
import com.vmware.vide.logging.supportbundle.ISupportBundleContributor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class SupportBundleRegistry {
    private LinkedHashSet<ISupportBundleContribution> bundleContributionSet = new LinkedHashSet();
    private LinkedHashSet<ISupportBundleContributor> bundleContributorSet = new LinkedHashSet();
    private static final SupportBundleRegistry INSTANCE = new SupportBundleRegistry();

    public static SupportBundleRegistry getInstance() {
        return INSTANCE;
    }

    public synchronized void addBundleContribution(ISupportBundleContribution contribution) {
        this.bundleContributionSet.add(contribution);
    }

    public synchronized void removeBundleContribution(ISupportBundleContribution contribution) {
        this.bundleContributionSet.remove(contribution);
    }

    public synchronized void addBundleContributor(ISupportBundleContributor contributor) {
        this.bundleContributorSet.add(contributor);
    }

    public synchronized void removeBundleContributor(ISupportBundleContributor contributor) {
        this.bundleContributorSet.remove(contributor);
    }

    public synchronized List<ISupportBundleContribution> getAllBundleContributions() {
        ArrayList<ISupportBundleContribution> returnList = new ArrayList<ISupportBundleContribution>(10);
        returnList.addAll(this.bundleContributionSet);
        for (ISupportBundleContributor contributor : this.bundleContributorSet) {
            returnList.addAll(contributor.getContributions());
        }
        List<ISupportBundleContributor> extensionContributors = this.getContributorsFromExtensions();
        for (ISupportBundleContributor contributor : extensionContributors) {
            returnList.addAll(contributor.getContributions());
        }
        return returnList;
    }

    private List<ISupportBundleContributor> getContributorsFromExtensions() {
        IConfigurationElement[] elements;
        LinkedList<ISupportBundleContributor> contributors = new LinkedList<ISupportBundleContributor>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("com.vmware.vide.logging.supportbundle.contributor");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object obj = element.createExecutableExtension("class");
                if (obj instanceof ISupportBundleContributor) {
                    ISupportBundleContributor contributor = (ISupportBundleContributor)obj;
                    contributors.add(contributor);
                }
            }
            catch (CoreException e) {
                System.err.println("Exception querying for com.vmware.vide.logging.supportbundle.contributor extensions: " + e.getMessage());
            }
            ++n2;
        }
        return contributors;
    }

    private SupportBundleRegistry() {
    }
}

