/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.logging.output;

import com.vmware.vide.logging.listener.ILoggingOutputStreamFlushListener;
import java.io.IOException;
import java.io.OutputStream;

public class LoggingOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_LENGTH = 2048;
    private ILoggingOutputStreamFlushListener listener;
    private int length;
    private byte[] buffer;
    private int count;
    private boolean closed;

    public LoggingOutputStream(ILoggingOutputStreamFlushListener listener) {
        this.listener = listener;
        this.length = 2048;
        this.buffer = new byte[this.length];
        this.count = 0;
        this.closed = false;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.closed = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("The stream has already been closed");
        }
        if (b == 0) {
            return;
        }
        if (b == 13 || b == 10) {
            this.flush();
            return;
        }
        if (this.count == this.length) {
            int newLength = this.length + 2048;
            byte[] newBuffer = new byte[newLength];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.length);
            this.buffer = newBuffer;
            this.length = newLength;
        }
        this.buffer[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("The stream has already been closed");
        }
        if (this.count == 0) {
            return;
        }
        byte[] bytes = new byte[this.count];
        System.arraycopy(this.buffer, 0, bytes, 0, this.count);
        this.listener.onFlush(bytes);
        this.count = 0;
    }
}

