/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.logging.bundle;

import com.vmware.vide.logging.PlatformLoggingController;
import com.vmware.vide.logging.bundle.ILogBundleReadyListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogBundleRunnable
implements Runnable {
    private static final String ECLIPSE_APP_PROP = "eclipse.product";
    private static final Logger logger = LoggerFactory.getLogger(LogBundleRunnable.class);
    private File outputDir;
    private ILogBundleReadyListener listener;

    public LogBundleRunnable(File outputDir, ILogBundleReadyListener listener) {
        this.outputDir = outputDir;
        this.listener = listener;
    }

    private void createLogBundle(File zip, File[] logs) throws IOException {
        try (ZipOutputStream outStream = null;){
            outStream = new ZipOutputStream(new FileOutputStream(zip));
            byte[] buffer = new byte[1024];
            File[] fileArray = logs;
            int n = logs.length;
            int n2 = 0;
            while (n2 < n) {
                File log = fileArray[n2];
                FileInputStream inStream = null;
                try {
                    int len;
                    inStream = new FileInputStream(log);
                    outStream.putNextEntry(new ZipEntry(log.getName()));
                    while ((len = inStream.read(buffer)) > 0) {
                        outStream.write(buffer, 0, len);
                    }
                }
                finally {
                    outStream.closeEntry();
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void run() {
        LogFileFilter filter;
        File[] logs;
        File bundle = null;
        String logDir = PlatformLoggingController.getInstance().getLogDirPath();
        File dir = new File(logDir);
        String appName = System.getProperty(ECLIPSE_APP_PROP);
        if (appName != null && (logs = dir.listFiles(filter = new LogFileFilter(appName))) != null && logs.length > 0) {
            try {
                bundle = new File(this.outputDir, String.valueOf(appName) + ".zip");
                this.createLogBundle(bundle, logs);
            }
            catch (IOException e) {
                logger.error("Unable to create log bundle", (Throwable)e);
            }
        }
        if (this.listener != null) {
            this.listener.onReady(bundle);
        }
    }

    private class LogFileFilter
    implements FileFilter {
        private String appName;

        public LogFileFilter(String appName) {
            this.appName = appName;
        }

        @Override
        public boolean accept(File path) {
            return path.getName().startsWith(this.appName);
        }
    }
}

