/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.net.URL;
import org.slf4j.LoggerFactory;

public class PlatformLoggingController {
    public static final String LOG_DIR_PROP = "com.vmware.vide.log.dir";
    public static final String VMWB_DIR = ".vmwb";
    public static final String MY_LOGGER = "MY_LOGGER";
    private static FileAppender<ILoggingEvent> fileAppender;
    private static boolean initialized;
    private static final PlatformLoggingController instance;

    static {
        initialized = false;
        instance = new PlatformLoggingController();
    }

    public static PlatformLoggingController getInstance() {
        return instance;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public String getDefaultLogDirPath() {
        if (PlatformLoggingController.isWindows()) {
            return String.valueOf(System.getenv("HOMEDRIVE")) + System.getenv("HOMEPATH") + File.separator + VMWB_DIR + File.separator;
        }
        return String.valueOf(System.getProperty("user.home")) + File.separator + VMWB_DIR + File.separator;
    }

    public String getLogDirPath() {
        String logDirProperty = System.getProperty(LOG_DIR_PROP);
        if (logDirProperty == null || logDirProperty.isEmpty()) {
            return this.getDefaultLogDirPath();
        }
        return logDirProperty;
    }

    public void checkAndSetLogFileLocation() {
        String logDirProperty = System.getProperty(LOG_DIR_PROP);
        if (logDirProperty == null || logDirProperty.isEmpty() || logDirProperty.contains("${user.home}")) {
            logDirProperty = this.getDefaultLogDirPath();
            System.setProperty(LOG_DIR_PROP, logDirProperty);
        }
        System.out.println("com.vmware.vide.log.dir='" + logDirProperty + "'");
        try {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            ContextInitializer ci = new ContextInitializer(lc);
            lc.reset();
            try {
                URL defaultConfigUrl = ci.findURLOfDefaultConfigurationFile(false);
                String newConfigFile = defaultConfigUrl.getFile().replace("logback.xml", "logback-using-vars.xml");
                URL newUrl = new URL(defaultConfigUrl.getProtocol(), defaultConfigUrl.getHost(), defaultConfigUrl.getPort(), newConfigFile);
                ci.configureByResource(newUrl);
            }
            catch (JoranException e) {
                e.printStackTrace();
            }
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PlatformLoggingController() {
    }
}

