/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.symbol;

import java.util.ArrayList;
import java.util.Collection;

public class StringUtil {
    public static ArrayList<String> convertCommandLineToCommandAndArgs(String line) {
        ArrayList<String> segments = new ArrayList<String>();
        int index = 0;
        while (index < line.length()) {
            if (Character.isWhitespace(line.charAt(index))) {
                ++index;
                continue;
            }
            StringBuffer seg = new StringBuffer();
            while (index < line.length()) {
                if (StringUtil.isBackslashed(line.substring(index))) {
                    seg.append(line.substring(index + 1, index + 2));
                    index += 2;
                    continue;
                }
                if (line.charAt(index) == '\"' || line.charAt(index) == '\'') {
                    int next = StringUtil.findNextQuoteAndAppend(line.substring(index), seg);
                    index += next;
                    continue;
                }
                if (Character.isWhitespace(line.charAt(index))) break;
                seg.append(line.charAt(index));
                ++index;
            }
            segments.add(seg.toString());
        }
        return segments;
    }

    public static boolean isBackslashed(String str) {
        if (str.startsWith("\\\\")) {
            return true;
        }
        if (str.startsWith("\\ ")) {
            return true;
        }
        if (str.startsWith("\\\"")) {
            return true;
        }
        return str.startsWith("\\'");
    }

    public static int findNextQuoteAndAppend(String str, StringBuffer out) {
        char searchFor = str.charAt(0);
        int index = 1;
        boolean found = false;
        while (index < str.length()) {
            if (str.substring(index).startsWith("\\" + searchFor)) {
                out.append(str.charAt(index + 1));
                index += 2;
                continue;
            }
            if (str.charAt(index) == searchFor) {
                ++index;
                found = true;
                break;
            }
            out.append(str.charAt(index));
            ++index;
        }
        if (!found) {
            System.err.println("Unmatched " + searchFor + ".");
        }
        return index;
    }

    public static String join(Collection<?> objects, String delimiter) {
        StringBuilder builder = new StringBuilder();
        String d = "";
        for (Object object : objects) {
            builder.append(d);
            builder.append(object.toString());
            d = delimiter;
        }
        return builder.toString();
    }
}

